/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.xrr.resultimport.impl;

import com.sap.sailing.domain.common.BoatClassMasterdata;
import com.sap.sailing.domain.common.RegattaScoreCorrections;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.xrr.resultimport.Parser;
import com.sap.sailing.xrr.resultimport.impl.XRRParserUtil;
import com.sap.sailing.xrr.resultimport.impl.XRRRegattaResultsAsScoreCorrections;
import com.sap.sailing.xrr.schema.Boat;
import com.sap.sailing.xrr.schema.Division;
import com.sap.sailing.xrr.schema.Event;
import com.sap.sailing.xrr.schema.EventGender;
import com.sap.sailing.xrr.schema.Person;
import com.sap.sailing.xrr.schema.Race;
import com.sap.sailing.xrr.schema.RegattaResults;
import com.sap.sailing.xrr.schema.TRResult;
import com.sap.sailing.xrr.schema.Team;
import com.sap.sse.util.XmlUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import org.xml.sax.SAXException;

public class ParserImpl
implements Parser {
    private final Map<String, Person> personByID = new HashMap<String, Person>();
    private final Map<String, Team> teamByID = new HashMap<String, Team>();
    private final Map<String, Boat> boatByID = new HashMap<String, Boat>();
    private final Map<String, Race> raceByID = new HashMap<String, Race>();
    private final InputStream inputStream;
    private final String name;

    public ParserImpl(InputStream inputStream, String name) {
        this.inputStream = inputStream;
        this.name = name;
    }

    @Override
    public RegattaResults parse() throws JAXBException, SAXException, ParserConfigurationException {
        Source xmlSource = XmlUtil.getXmlSourceForInputStream((InputStream)this.inputStream);
        JAXBContext jc = JAXBContext.newInstance((String)TRResult.class.getPackage().getName(), (ClassLoader)ParserImpl.class.getClassLoader());
        Unmarshaller um = jc.createUnmarshaller();
        RegattaResults regattaResults = (RegattaResults)((JAXBElement)um.unmarshal(xmlSource)).getValue();
        for (Object o : regattaResults.getPersonOrBoatOrTeam()) {
            if (o instanceof Person) {
                Person person = (Person)o;
                this.personByID.put(person.getPersonID(), person);
                continue;
            }
            if (o instanceof Boat) {
                Boat boat = (Boat)o;
                this.boatByID.put(boat.getBoatID(), boat);
                continue;
            }
            if (o instanceof Team) {
                Team team = (Team)o;
                this.teamByID.put(team.getTeamID(), team);
                continue;
            }
            if (!(o instanceof Event)) continue;
            Event event = (Event)o;
            for (Object o2 : event.getRaceOrDivisionOrRegattaSeriesResult()) {
                if (!(o2 instanceof Race)) continue;
                Race race = (Race)o2;
                this.raceByID.put(race.getRaceID(), race);
            }
        }
        return regattaResults;
    }

    @Override
    public String getBoatClassName(Division division) {
        return XRRParserUtil.getBoatClassName(division);
    }

    @Override
    public Boat getBoat(String boatID) {
        return this.boatByID.get(boatID);
    }

    @Override
    public Team getTeam(String teamID) {
        return this.teamByID.get(teamID);
    }

    @Override
    public Person getPerson(String personID) {
        return this.personByID.get(personID);
    }

    @Override
    public Race getRace(String raceID) {
        return this.raceByID.get(raceID);
    }

    public String toString() {
        return this.name == null ? "" : this.name;
    }

    @Override
    public RegattaScoreCorrections getRegattaScoreCorrections(RegattaResults regattaResults, ScoreCorrectionProvider scoreCorrectionProvider, Optional<String> eventNameFilter, Optional<String> boatClassNameFilter) {
        for (Object o : regattaResults.getPersonOrBoatOrTeam()) {
            if (!(o instanceof Event)) continue;
            Event event = (Event)o;
            if (eventNameFilter.isPresent() && !event.getTitle().equals(eventNameFilter.get())) continue;
            for (Object eventO : event.getRaceOrDivisionOrRegattaSeriesResult()) {
                if (!(eventO instanceof Division)) continue;
                Division division = (Division)eventO;
                EventGender divisionGender = division.getGender();
                String divisionBoatClass = this.getBoatClassName(division);
                String divisionBoatClassAndGender = divisionGender != null ? String.valueOf(divisionBoatClass) + ", " + divisionGender.name() : divisionBoatClass;
                String unifiedBoatClassNameFilter = boatClassNameFilter.map(n -> BoatClassMasterdata.unifyBoatClassNameBasedOnExistingMasterdata((String)n)).orElse(null);
                if (unifiedBoatClassNameFilter != null && !unifiedBoatClassNameFilter.equals(BoatClassMasterdata.unifyBoatClassNameBasedOnExistingMasterdata((String)divisionBoatClass)) && !unifiedBoatClassNameFilter.equals(BoatClassMasterdata.unifyBoatClassNameBasedOnExistingMasterdata((String)divisionBoatClassAndGender)) && !unifiedBoatClassNameFilter.contains(BoatClassMasterdata.unifyBoatClassNameBasedOnExistingMasterdata((String)divisionBoatClassAndGender))) continue;
                return new XRRRegattaResultsAsScoreCorrections(event, division, scoreCorrectionProvider, this);
            }
        }
        return null;
    }
}

