/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.simulator.impl;

import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.simulator.TimedPosition;
import java.util.BitSet;

public class PathCandidateBitSet
implements Comparable<PathCandidateBitSet> {
    TimedPosition pos;
    boolean reached;
    double vrt;
    double hrz;
    int trn;
    BitSet path;
    int length;
    boolean sid;

    public PathCandidateBitSet(TimedPosition pos, boolean reached, double vrt, double hrz, int trn, BitSet path, int length, boolean sid, Wind wind) {
        this.pos = pos;
        this.reached = reached;
        this.vrt = vrt;
        this.hrz = hrz;
        this.trn = trn;
        this.path = path;
        this.length = length;
        this.sid = sid;
    }

    public int getIndexOfTurnLR() {
        int step = 0;
        while (step < this.length - 1) {
            if (!this.path.get(step) && this.path.get(step + 1)) {
                return step;
            }
            ++step;
        }
        return -1;
    }

    public int getIndexOfTurnRL() {
        int step = 0;
        while (step < this.length - 1) {
            if (this.path.get(step) && !this.path.get(step + 1)) {
                return step;
            }
            ++step;
        }
        return -1;
    }

    @Override
    public int compareTo(PathCandidateBitSet other) {
        if (Math.abs(this.pos.getTimePoint().asMillis() - other.pos.getTimePoint().asMillis()) <= 1000L) {
            if (this.trn == other.trn) {
                if (Math.abs(this.hrz) == Math.abs(other.hrz)) {
                    return 0;
                }
                return Math.abs(this.hrz) < Math.abs(other.hrz) ? -1 : 1;
            }
            return this.trn < other.trn ? -1 : 1;
        }
        return this.pos.getTimePoint().asMillis() < other.pos.getTimePoint().asMillis() ? -1 : 1;
    }
}

