/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.interfaces;

import com.sap.sse.security.shared.Account;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.UserGroupProvider;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.impl.LockingAndBanning;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.SecurityUserImpl;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.shared.subscription.Subscription;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.shiro.crypto.hash.Sha256Hash;

public class UserImpl
extends SecurityUserImpl<RoleDefinition, Role, UserGroup, WildcardPermission>
implements User {
    private static final long serialVersionUID = 1788215575606546042L;
    private String fullName;
    private String company;
    private Locale locale;
    private String email;
    private String validationSecret;
    private String passwordResetSecret;
    private boolean emailValidated;
    private final Map<Account.AccountType, Account> accounts;
    private transient UserGroupProvider userGroupProvider;
    private transient Set<Role> roles;
    private List<Role> roleListForSerialization;
    private Subscription[] subscriptions;
    private final LockingAndBanning lockingAndBanning;
    private Map<String, UserGroup> defaultTenantForServer;

    public UserImpl(String name, String email, Map<String, UserGroup> defaultTenantForServer, UserGroupProvider userGroupProvider, LockingAndBanning lockingAndBanning, Account ... accounts) {
        this(name, email, defaultTenantForServer, Arrays.asList(accounts), userGroupProvider, lockingAndBanning);
    }

    public UserImpl(String name, String email, Map<String, UserGroup> defaultTenantForServer, Collection<Account> accounts, UserGroupProvider userGroupProvider, LockingAndBanning lockingAndBanning) {
        this(name, email, null, null, null, false, null, null, defaultTenantForServer, accounts, userGroupProvider, lockingAndBanning);
    }

    public UserImpl(String name, String email, String fullName, String company, Locale locale, Boolean emailValidated, String passwordResetSecret, String validationSecret, Map<String, UserGroup> defaultTenantForServer, Collection<Account> accounts, UserGroupProvider userGroupProvider, LockingAndBanning lockingAndBanning) {
        super(name);
        this.lockingAndBanning = lockingAndBanning;
        this.defaultTenantForServer = defaultTenantForServer;
        this.fullName = fullName;
        this.company = company;
        this.locale = locale;
        this.email = email;
        this.passwordResetSecret = passwordResetSecret;
        this.validationSecret = validationSecret;
        this.emailValidated = emailValidated;
        this.accounts = new HashMap<Account.AccountType, Account>();
        this.userGroupProvider = userGroupProvider;
        for (Account a : accounts) {
            this.accounts.put(a.getAccountType(), a);
        }
        this.roles = new HashSet<Role>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Role> getRolesInternal() {
        if (this.roles != null) {
            Set<Role> result = this.roles;
        } else {
            UserImpl userImpl = this;
            synchronized (userImpl) {
                if (this.roles == null) {
                    HashSet<Role> result = new HashSet<Role>(this.roleListForSerialization);
                    this.roleListForSerialization = null;
                    this.roles = result;
                }
            }
        }
        return this.roles;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(new ArrayList<Role>(this.getRolesInternal()));
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.roleListForSerialization = (List)ois.readObject();
    }

    public void setUserGroupProvider(UserGroupProvider userGroupProvider) {
        this.userGroupProvider = userGroupProvider;
    }

    public UserGroupProvider getUserGroupProvider() {
        return this.userGroupProvider;
    }

    public Serializable getId() {
        return this.getName();
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocaleOrDefault() {
        return this.locale == null ? Locale.ENGLISH : this.locale;
    }

    public Account getAccount(Account.AccountType type) {
        return this.accounts.get(type);
    }

    public void removeAccount(Account.AccountType type) {
        this.accounts.remove(type);
    }

    public Map<Account.AccountType, Account> getAllAccounts() {
        return Collections.unmodifiableMap(this.accounts);
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void startEmailValidation(String randomSecret) {
        this.validationSecret = randomSecret;
        this.emailValidated = false;
    }

    public void startPasswordReset(String randomSecret) {
        this.passwordResetSecret = randomSecret;
    }

    public String getPasswordResetSecret() {
        return this.passwordResetSecret;
    }

    public String createRandomSecret() {
        byte[] bytes1 = new byte[64];
        new SecureRandom().nextBytes(bytes1);
        byte[] bytes2 = new byte[64];
        new Random().nextBytes(bytes2);
        return new Sha256Hash((Object)bytes1, (Object)bytes2, 1024).toBase64();
    }

    public boolean validate(String validationSecret) {
        boolean result;
        if (this.emailValidated) {
            result = true;
        } else if (validationSecret.equals(this.validationSecret)) {
            this.emailValidated = true;
            this.validationSecret = null;
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    public void passwordWasReset() {
        this.passwordResetSecret = null;
    }

    public boolean isEmailValidated() {
        return this.emailValidated;
    }

    public Iterable<UserGroup> getUserGroups() {
        return this.userGroupProvider.getUserGroupsOfUser((User)this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UserImpl [");
        builder.append("getName()=");
        builder.append(this.getName());
        builder.append(", ");
        if (this.defaultTenantForServer != null) {
            builder.append("defaultTenantForServer=[");
            for (Map.Entry<String, UserGroup> entry : this.defaultTenantForServer.entrySet()) {
                builder.append(entry.getValue().getName());
                builder.append("@");
                builder.append(entry.getKey());
                builder.append(",");
            }
            builder.append("], ");
        }
        if (this.getFullName() != null) {
            builder.append("getFullName()=");
            builder.append(this.getFullName());
            builder.append(", ");
        }
        if (this.getCompany() != null) {
            builder.append("getCompany()=");
            builder.append(this.getCompany());
            builder.append(", ");
        }
        if (this.getLocale() != null) {
            builder.append("getLocale()=");
            builder.append(this.getLocale());
            builder.append(", ");
        }
        if (this.getEmail() != null) {
            builder.append("getEmail()=");
            builder.append(this.getEmail());
            builder.append(", ");
        }
        builder.append("isEmailValidated()=");
        builder.append(this.isEmailValidated());
        builder.append(", ");
        if (this.getPermissions() != null) {
            builder.append("getPermissions()=");
            builder.append(this.getPermissions());
        }
        builder.append("]");
        return builder.toString();
    }

    public String getValidationSecret() {
        return this.validationSecret;
    }

    public UserGroup getDefaultTenant(String serverName) {
        return this.defaultTenantForServer.get(serverName);
    }

    public void setDefaultTenant(UserGroup newDefaultTenant, String serverName) {
        this.defaultTenantForServer.put(serverName, newDefaultTenant);
    }

    public Map<String, UserGroup> getDefaultTenantMap() {
        return this.defaultTenantForServer;
    }

    public Iterable<Subscription> getSubscriptions() {
        List<Subscription> result = this.subscriptions == null ? null : Arrays.asList(this.subscriptions);
        return result;
    }

    public void setSubscriptions(Subscription[] subscriptions) {
        this.subscriptions = subscriptions;
    }

    public Subscription getSubscriptionByPlan(String planId) {
        if (planId != null && !planId.equals("") && this.subscriptions != null && this.subscriptions != null && this.subscriptions.length > 0) {
            Subscription[] subscriptionArray = this.subscriptions;
            int n = this.subscriptions.length;
            int n2 = 0;
            while (n2 < n) {
                Subscription subscription = subscriptionArray[n2];
                if (subscription.getPlanId() != null && subscription.getPlanId().equals(planId)) {
                    return subscription;
                }
                ++n2;
            }
        }
        return null;
    }

    public Subscription getSubscriptionById(String subscriptionId) {
        if (subscriptionId != null && !subscriptionId.isEmpty() && this.subscriptions != null && this.subscriptions.length > 0) {
            Subscription[] subscriptionArray = this.subscriptions;
            int n = this.subscriptions.length;
            int n2 = 0;
            while (n2 < n) {
                Subscription subscription = subscriptionArray[n2];
                if (subscription.getSubscriptionId() != null && subscription.getSubscriptionId().equals(subscriptionId)) {
                    return subscription;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean hasActiveSubscription(String planId) {
        boolean result = false;
        if (this.subscriptions != null && this.subscriptions.length > 0) {
            Subscription[] subscriptionArray = this.subscriptions;
            int n = this.subscriptions.length;
            int n2 = 0;
            while (n2 < n) {
                Subscription subscription = subscriptionArray[n2];
                if (subscription.isActiveSubscription() && subscription.getPlanId() != null && subscription.getPlanId().equals(planId)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }

    public boolean hasAnySubscription(String planId) {
        if (this.subscriptions != null && this.subscriptions.length > 0) {
            Subscription[] subscriptionArray = this.subscriptions;
            int n = this.subscriptions.length;
            int n2 = 0;
            while (n2 < n) {
                Subscription subscription = subscriptionArray[n2];
                if (planId.equals(subscription.getPlanId())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public LockingAndBanning getLockingAndBanning() {
        return this.lockingAndBanning;
    }
}

