/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.util.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.leaderboard.ResultDiscardingRule;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.tracking.TrackedRace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class RaceColumnListeners
implements Serializable {
    private static final long serialVersionUID = -7278209809901582157L;
    private transient Set<RaceColumnListener> raceColumnListeners = new HashSet<RaceColumnListener>();

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        this.raceColumnListeners = (Set)ois.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream oos) throws IOException {
        HashSet<RaceColumnListener> setToWrite;
        Set<RaceColumnListener> set = this.raceColumnListeners;
        synchronized (set) {
            setToWrite = new HashSet<RaceColumnListener>();
            for (RaceColumnListener listener : this.raceColumnListeners) {
                if (listener.isTransient()) continue;
                setToWrite.add(listener);
            }
        }
        oos.writeObject(setToWrite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRaceColumnListener(RaceColumnListener listener) {
        Set<RaceColumnListener> set = this.raceColumnListeners;
        synchronized (set) {
            this.raceColumnListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRaceColumnListener(RaceColumnListener listener) {
        Set<RaceColumnListener> set = this.raceColumnListeners;
        synchronized (set) {
            this.raceColumnListeners.remove(listener);
        }
    }

    public void notifyListenersAboutTrackedRaceLinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.trackedRaceLinked(raceColumn, fleet, trackedRace);
        }
    }

    public void notifyListenersAboutTrackedRaceUnlinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.trackedRaceUnlinked(raceColumn, fleet, trackedRace);
        }
    }

    public void notifyListenersAboutFactorChanged(RaceColumn raceColumn, Double oldFactor, Double newFactor) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.factorChanged(raceColumn, oldFactor, newFactor);
        }
    }

    public void notifyListenersAboutIsMedalRaceChanged(RaceColumn raceColumn, boolean newIsMedalRace) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.isMedalRaceChanged(raceColumn, newIsMedalRace);
        }
    }

    public void notifyListenersAboutIsFleetsCanRunInParallelChanged(RaceColumn raceColumn, boolean newIsFleetsCanRunInParallel) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.isFleetsCanRunInParallelChanged(raceColumn, newIsFleetsCanRunInParallel);
        }
    }

    public void notifyListenersAboutIsStartsWithZeroScoreChanged(RaceColumn raceColumn, boolean newIsStartsWithZeroScore) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.isStartsWithZeroScoreChanged(raceColumn, newIsStartsWithZeroScore);
        }
    }

    public void notifyListenersAboutHasSplitFleetContiguousScoringChanged(RaceColumn raceColumn, boolean hasSplitFleetContiguousScoring) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.hasSplitFleetContiguousScoringChanged(raceColumn, hasSplitFleetContiguousScoring);
        }
    }

    public void notifyListenersAboutHasCrossFleetMergedRankingChanged(RaceColumn raceColumn, boolean hasCrossFleetMergedRanking) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.hasCrossFleetMergedRankingChanged(raceColumn, hasCrossFleetMergedRanking);
        }
    }

    public void notifyListenersAboutIsFirstColumnIsNonDiscardableCarryForwardChanged(RaceColumn raceColumn, boolean firstColumnIsNonDiscardableCarryForward) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.isFirstColumnIsNonDiscardableCarryForwardChanged(raceColumn, firstColumnIsNonDiscardableCarryForward);
        }
    }

    public void notifyListenersAboutRaceColumnAddedToContainer(RaceColumn raceColumn) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.raceColumnAddedToContainer(raceColumn);
        }
    }

    public void notifyListenersAboutRaceColumnRemovedFromContainer(RaceColumn raceColumn) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.raceColumnRemovedFromContainer(raceColumn);
        }
    }

    public void notifyListenersAboutRaceColumnMoved(RaceColumn raceColumn, int newIndex) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.raceColumnMoved(raceColumn, newIndex);
        }
    }

    public void notifyListenersAboutRaceColumnNameChanged(RaceColumn raceColumn, String oldName, String newName) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.raceColumnNameChanged(raceColumn, oldName, newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<RaceColumnListener> getRaceColumnListeners() {
        Set<RaceColumnListener> set = this.raceColumnListeners;
        synchronized (set) {
            return new HashSet<RaceColumnListener>(this.raceColumnListeners);
        }
    }

    public boolean canAddRaceColumnToContainer(RaceColumn columnToAdd) {
        boolean result = true;
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            result = listener.canAddRaceColumnToContainer(columnToAdd);
            if (!result) break;
        }
        return result;
    }

    public void notifyListenersAboutCompetitorDisplayNameChanged(Competitor competitor, String oldDisplayName, String displayName) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.competitorDisplayNameChanged(competitor, oldDisplayName, displayName);
        }
    }

    public void notifyListenersAboutResultDiscardingRuleChanged(ResultDiscardingRule oldDiscardingRule, ResultDiscardingRule newDiscardingRule) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.resultDiscardingRuleChanged(oldDiscardingRule, newDiscardingRule);
        }
    }

    public void notifyListenersAboutMaximumNumberOfDiscardsChanged(Integer oldMaximumNumberOfDiscards, Integer newMaximumNumberOfDiscards) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.maximumNumberOfDiscardsChanged(oldMaximumNumberOfDiscards, newMaximumNumberOfDiscards);
        }
    }

    public void notifyListenersAboutRaceLogEventAdded(RaceColumn raceColumn, RaceLogIdentifier raceLogIdentifier, RaceLogEvent event) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.raceLogEventAdded(raceColumn, raceLogIdentifier, event);
        }
    }

    public void notifyListenersAboutRegattaLogEventAdded(RegattaLogEvent event) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.regattaLogEventAdded(event);
        }
    }

    public void notifyListenersAboutOneAlwaysStaysOneChanged(RaceColumn raceColumn, boolean oneAlwaysStaysOne) {
        for (RaceColumnListener listener : this.getRaceColumnListeners()) {
            listener.oneAlwaysStaysOneChanged(raceColumn, oneAlwaysStaysOne);
        }
    }
}

