/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.orc.impl;

import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.orc.ORCCertificatesCollection;
import com.sap.sse.common.Util;

public abstract class AbstractORCCertificatesCollection
implements ORCCertificatesCollection {
    protected String getCanonicalizedBoatName(String boatName) {
        String replaced = boatName.toUpperCase().replaceAll("[^A-Z0-9]", "");
        return replaced.substring(0, Math.min(replaced.length(), 16));
    }

    @Override
    public ORCCertificate getCertificateByBoatName(String boatName) {
        String canonicalizedBoatNameToSearchFor = this.getCanonicalizedBoatName(boatName);
        for (ORCCertificate certificate : this.getCertificates()) {
            if (!canonicalizedBoatNameToSearchFor.equals(this.getCanonicalizedBoatName(certificate.getBoatName()))) continue;
            return certificate;
        }
        return null;
    }

    protected String canonicalizeId(String certificateId) {
        return certificateId.replaceAll(" ", "").replaceAll("\t", "");
    }

    @Override
    public Iterable<ORCCertificate> getCertificates() {
        return Util.map(this.getCertificateIds(), certificateId -> this.getCertificateById((String)certificateId));
    }

    @Override
    public Iterable<String> getBoatNames() {
        return Util.map(this.getCertificates(), c -> this.getCanonicalizedBoatName(c.getBoatName()));
    }

    public String toString() {
        return Util.joinStrings((String)", ", (Iterable)Util.map(this.getCertificates(), c -> c.toString()));
    }
}

