/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.markpassingcalculation.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.markpassingcalculation.Candidate;
import com.sap.sailing.domain.markpassingcalculation.impl.StationarySequence;
import com.sap.sailing.domain.tracking.DynamicGPSFixTrack;
import com.sap.sse.common.Util;
import java.util.Comparator;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;

public class StationarySequenceBasedFilter {
    private static final Logger logger = Logger.getLogger(StationarySequenceBasedFilter.class.getName());
    private final NavigableSet<StationarySequence> stationarySequences = new TreeSet<StationarySequence>((ss1, ss2) -> candidateComparator.compare(ss1.getFirst(), ss2.getFirst()));
    private final NavigableSet<Candidate> candidates;
    private final Set<Candidate> filteredCandidates;
    private DynamicGPSFixTrack<Competitor, GPSFixMoving> track;
    private final Comparator<Candidate> candidateComparator;
    private final Candidate startProxyCandidate;
    private final Candidate endProxyCandidate;

    StationarySequenceBasedFilter(Comparator<Candidate> candidateComparator, DynamicGPSFixTrack<Competitor, GPSFixMoving> track, Candidate startProxyCandidate, Candidate endProxyCandidate) {
        this.candidateComparator = candidateComparator;
        this.candidates = new TreeSet<Candidate>(candidateComparator);
        this.filteredCandidates = new TreeSet<Candidate>(candidateComparator);
        this.track = track;
        this.startProxyCandidate = startProxyCandidate;
        this.endProxyCandidate = endProxyCandidate;
    }

    private StationarySequence createStationarySequence(Candidate firstCandidate) {
        assert (firstCandidate != this.startProxyCandidate && firstCandidate != this.endProxyCandidate);
        return new StationarySequence(firstCandidate, this.candidateComparator, this.track);
    }

    Util.Pair<Iterable<Candidate>, Iterable<Candidate>> updateCandidates(Iterable<Candidate> newCandidates, Iterable<Candidate> removedCandidates) {
        HashSet<Candidate> candidatesEffectivelyAdded = new HashSet<Candidate>();
        HashSet<Candidate> candidatesEffectivelyRemoved = new HashSet<Candidate>();
        for (Candidate newCandidate : newCandidates) {
            this.addCandidate(newCandidate, candidatesEffectivelyAdded, candidatesEffectivelyRemoved);
        }
        for (Candidate removedCandidate : removedCandidates) {
            this.removeCandidate(removedCandidate, candidatesEffectivelyAdded, candidatesEffectivelyRemoved);
        }
        this.updateFilteredCandidates(candidatesEffectivelyAdded, candidatesEffectivelyRemoved);
        assert (this.isCandidatesConsistent());
        return new Util.Pair(candidatesEffectivelyAdded, candidatesEffectivelyRemoved);
    }

    private void updateFilteredCandidates(Set<Candidate> candidatesEffectivelyAdded, Set<Candidate> candidatesEffectivelyRemoved) {
        assert (!new HashSet<Candidate>(this.filteredCandidates).removeAll(candidatesEffectivelyAdded));
        this.filteredCandidates.addAll(candidatesEffectivelyAdded);
        this.filteredCandidates.removeAll(candidatesEffectivelyRemoved);
        assert (!new HashSet<Candidate>(candidatesEffectivelyAdded).removeAll(candidatesEffectivelyRemoved) && !new HashSet<Candidate>(candidatesEffectivelyRemoved).removeAll(candidatesEffectivelyAdded));
    }

    private void addCandidate(Candidate newCandidate, Set<Candidate> candidatesEffectivelyAdded, Set<Candidate> candidatesEffectivelyRemoved) {
        boolean candidatesContainsNewCandidate = this.candidates.contains(newCandidate);
        if (candidatesContainsNewCandidate) {
            logger.severe("Candidates " + this.candidates + " already contain " + newCandidate + " which is to be added.");
        }
        assert (!candidatesContainsNewCandidate && this.isCandidatesConsistent());
        if (newCandidate == this.startProxyCandidate) {
            candidatesEffectivelyAdded.add(newCandidate);
            candidatesEffectivelyRemoved.remove(newCandidate);
        } else if (newCandidate == this.endProxyCandidate) {
            candidatesEffectivelyAdded.add(newCandidate);
            candidatesEffectivelyRemoved.remove(newCandidate);
        } else {
            this.candidates.add(newCandidate);
            if (!this.lookLeft(newCandidate, candidatesEffectivelyAdded, candidatesEffectivelyRemoved)) {
                this.lookRight(newCandidate, candidatesEffectivelyAdded, candidatesEffectivelyRemoved);
            }
        }
        assert (this.isCandidatesConsistent());
    }

    private boolean isCandidatesConsistent() {
        TreeSet<Candidate> union = new TreeSet<Candidate>(this.candidateComparator);
        Candidate lastCandidateInPreviousSequence = null;
        boolean overlappingTimePointFound = false;
        for (StationarySequence stationarySequence : this.stationarySequences) {
            if (lastCandidateInPreviousSequence != null && this.candidateComparator.compare(lastCandidateInPreviousSequence, stationarySequence.getFirst()) >= 0) {
                overlappingTimePointFound = true;
                logger.severe("Last candidate " + lastCandidateInPreviousSequence + " in sequence overlaps with first element in next sequence " + stationarySequence);
            }
            lastCandidateInPreviousSequence = stationarySequence.getLast();
            Util.addAll(stationarySequence.getAllCandidates(), union);
        }
        boolean allSequenceCandidatesInCandidates = this.candidates.containsAll(union);
        if (!allSequenceCandidatesInCandidates) {
            union.removeAll(this.candidates);
            logger.severe("Candidates " + union + " from sequences missing from full candidates collection");
        }
        return allSequenceCandidatesInCandidates && !overlappingTimePointFound;
    }

    private boolean lookLeft(Candidate newCandidate, Set<Candidate> candidatesEffectivelyAdded, Set<Candidate> candidatesEffectivelyRemoved) {
        boolean addedToSequence;
        boolean createNewSequenceFromLowerToNew;
        StationarySequence latestStationarySequenceStartingAtOrBeforeNewCandidate = this.stationarySequences.floor(this.createStationarySequence(newCandidate));
        if (latestStationarySequenceStartingAtOrBeforeNewCandidate != null) {
            if (this.candidateComparator.compare(latestStationarySequenceStartingAtOrBeforeNewCandidate.getLast(), newCandidate) < 0) {
                createNewSequenceFromLowerToNew = !latestStationarySequenceStartingAtOrBeforeNewCandidate.tryToExtendAfterLast(newCandidate, candidatesEffectivelyAdded, candidatesEffectivelyRemoved);
            } else {
                latestStationarySequenceStartingAtOrBeforeNewCandidate.addWithin(newCandidate, candidatesEffectivelyAdded, candidatesEffectivelyRemoved);
                createNewSequenceFromLowerToNew = false;
            }
        } else {
            createNewSequenceFromLowerToNew = true;
        }
        if (createNewSequenceFromLowerToNew) {
            candidatesEffectivelyAdded.add(newCandidate);
            candidatesEffectivelyRemoved.remove(newCandidate);
            Candidate lower = this.candidates.lower(newCandidate);
            if (lower != null && (latestStationarySequenceStartingAtOrBeforeNewCandidate == null || this.candidateComparator.compare(latestStationarySequenceStartingAtOrBeforeNewCandidate.getLast(), lower) < 0)) {
                StationarySequence newSequence = this.tryToConstructStationarySequence(lower, newCandidate);
                if (newSequence != null) {
                    addedToSequence = true;
                    this.stationarySequences.add(newSequence);
                } else {
                    addedToSequence = false;
                }
            } else {
                addedToSequence = false;
            }
        } else {
            addedToSequence = true;
        }
        assert (this.containsNoEmptyOrSingleCandidateStationarySequence() && this.isCandidatesConsistent());
        return addedToSequence;
    }

    private void lookRight(Candidate newCandidate, Set<Candidate> candidatesEffectivelyAdded, Set<Candidate> candidatesEffectivelyRemoved) {
        StationarySequence earliestStationarySequenceStartingAfterNewCandidate = this.stationarySequences.higher(this.createStationarySequence(newCandidate));
        if (earliestStationarySequenceStartingAfterNewCandidate == null || !earliestStationarySequenceStartingAfterNewCandidate.tryToExtendBeforeFirst(newCandidate, candidatesEffectivelyAdded, candidatesEffectivelyRemoved, this.stationarySequences)) {
            StationarySequence newSequence;
            candidatesEffectivelyAdded.add(newCandidate);
            candidatesEffectivelyRemoved.remove(newCandidate);
            Candidate higher = this.candidates.higher(newCandidate);
            if (higher != null && (earliestStationarySequenceStartingAfterNewCandidate == null || this.candidateComparator.compare(higher, earliestStationarySequenceStartingAfterNewCandidate.getFirst()) < 0) && (newSequence = this.tryToConstructStationarySequence(newCandidate, higher)) != null) {
                this.stationarySequences.add(newSequence);
            }
        }
        assert (this.containsNoEmptyOrSingleCandidateStationarySequence() && this.isCandidatesConsistent());
    }

    private StationarySequence tryToConstructStationarySequence(Candidate start, Candidate end) {
        StationarySequence result;
        assert (start != null && end != null);
        StationarySequence newSequence = this.createStationarySequence(start);
        StationarySequence stationarySequence = result = newSequence.tryToExtendAfterLast(end, new HashSet<Candidate>(), new HashSet<Candidate>()) ? newSequence : null;
        assert (result == null || Util.contains(result.getValidCandidates(), (Object)start) && Util.contains(result.getValidCandidates(), (Object)end));
        return result;
    }

    private void removeCandidate(Candidate removedCandidate, Set<Candidate> candidatesEffectivelyAdded, Set<Candidate> candidatesEffectivelyRemoved) {
        if (removedCandidate == this.startProxyCandidate) {
            candidatesEffectivelyRemoved.add(removedCandidate);
            candidatesEffectivelyAdded.remove(removedCandidate);
        } else if (removedCandidate == this.endProxyCandidate) {
            candidatesEffectivelyRemoved.add(removedCandidate);
            candidatesEffectivelyAdded.remove(removedCandidate);
        } else {
            boolean addToEffectivelyRemoved;
            if (!this.candidates.contains(removedCandidate)) {
                logger.severe("Candidates " + this.candidates + " does not contain " + removedCandidate + " which is to be removed.");
            }
            assert (this.candidates.contains(removedCandidate) && this.isCandidatesConsistent());
            this.candidates.remove(removedCandidate);
            StationarySequence searchDummySequence = this.createStationarySequence(removedCandidate);
            StationarySequence latestStationarySequenceStartingAtOrBeforeRemovedCandidate = this.stationarySequences.floor(searchDummySequence);
            if (latestStationarySequenceStartingAtOrBeforeRemovedCandidate != null) {
                StationarySequence previousSequence;
                if (this.candidateComparator.compare(removedCandidate, latestStationarySequenceStartingAtOrBeforeRemovedCandidate.getFirst()) == 0 && (previousSequence = this.stationarySequences.lower(searchDummySequence)) != null) assert (!previousSequence.contains(removedCandidate));
                if (this.candidateComparator.compare(latestStationarySequenceStartingAtOrBeforeRemovedCandidate.getLast(), removedCandidate) >= 0) {
                    latestStationarySequenceStartingAtOrBeforeRemovedCandidate.remove(removedCandidate, candidatesEffectivelyAdded, candidatesEffectivelyRemoved, this.stationarySequences);
                    assert (!this.stationarySequences.contains(latestStationarySequenceStartingAtOrBeforeRemovedCandidate) || latestStationarySequenceStartingAtOrBeforeRemovedCandidate.size() > 1);
                    assert (this.isCandidatesConsistent());
                    addToEffectivelyRemoved = false;
                } else {
                    addToEffectivelyRemoved = true;
                }
            } else {
                addToEffectivelyRemoved = true;
            }
            if (addToEffectivelyRemoved) {
                candidatesEffectivelyRemoved.add(removedCandidate);
                candidatesEffectivelyAdded.remove(removedCandidate);
            }
        }
        assert (this.containsNoEmptyOrSingleCandidateStationarySequence() && this.isCandidatesConsistent());
    }

    private boolean containsNoEmptyOrSingleCandidateStationarySequence() {
        for (StationarySequence ss : this.stationarySequences) {
            if (ss.size() >= 2) continue;
            logger.severe("Found stationary sequence " + ss + " with less than two candidates in it.");
            return false;
        }
        return true;
    }

    Util.Pair<Iterable<Candidate>, Iterable<Candidate>> updateFixes(Iterable<GPSFixMoving> newFixes, Iterable<GPSFixMoving> fixesReplacingExistingOnes) {
        assert (this.isCandidatesConsistent());
        HashSet<Candidate> candidatesEffectivelyAdded = new HashSet<Candidate>();
        HashSet<Candidate> candidatesEffectivelyRemoved = new HashSet<Candidate>();
        if (newFixes != null) {
            for (GPSFixMoving newFix : newFixes) {
                StationarySequence lastSequenceStartingAtOrBeforeFix = this.stationarySequences.floor(this.createStationarySequence(StationarySequence.createDummyCandidate(newFix.getTimePoint())));
                if (lastSequenceStartingAtOrBeforeFix == null || lastSequenceStartingAtOrBeforeFix.getLast().getTimePoint().before(newFix.getTimePoint())) continue;
                StationarySequence splitResult = lastSequenceStartingAtOrBeforeFix.tryToAddFix(newFix, candidatesEffectivelyAdded, candidatesEffectivelyRemoved, this.stationarySequences, fixesReplacingExistingOnes != null && Util.contains(fixesReplacingExistingOnes, (Object)newFix));
                assert (!this.stationarySequences.contains(lastSequenceStartingAtOrBeforeFix) || lastSequenceStartingAtOrBeforeFix.size() > 1);
                if (splitResult == null) continue;
                assert (splitResult.size() > 1);
                this.stationarySequences.add(splitResult);
            }
        }
        if (fixesReplacingExistingOnes != null) {
            HashSet newFixesHashedForQuickAssertionCheck = new HashSet();
            assert (Util.addAll(newFixes, newFixesHashedForQuickAssertionCheck) != null);
            for (GPSFixMoving fixReplacingExistingOne : fixesReplacingExistingOnes) {
                StationarySequence newSequence;
                boolean nextCandidateIsFirstInSequence;
                Candidate firstCandidateAfterReplacementFix;
                boolean fixIsInStationarySequence;
                assert (newFixesHashedForQuickAssertionCheck.contains(fixReplacingExistingOne));
                Candidate dummyCandidateForReplacementFix = StationarySequence.createDummyCandidate(fixReplacingExistingOne.getTimePoint());
                StationarySequence dummyStationarySequenceForFix = this.createStationarySequence(dummyCandidateForReplacementFix);
                StationarySequence lastSequenceStartingAtOrBeforeFix = this.stationarySequences.floor(dummyStationarySequenceForFix);
                boolean bl = fixIsInStationarySequence = lastSequenceStartingAtOrBeforeFix != null && !lastSequenceStartingAtOrBeforeFix.getLast().getTimePoint().before(fixReplacingExistingOne.getTimePoint());
                if (fixIsInStationarySequence) continue;
                StationarySequence lastSequenceEndingBeforeFix = lastSequenceStartingAtOrBeforeFix;
                Candidate lastCandidateBeforeReplacementFix = this.candidates.lower(dummyCandidateForReplacementFix);
                if (lastCandidateBeforeReplacementFix == null || (firstCandidateAfterReplacementFix = this.candidates.higher(dummyCandidateForReplacementFix)) == null) continue;
                StationarySequence firstSequenceStartingAfterFix = this.stationarySequences.higher(dummyStationarySequenceForFix);
                boolean previousCandidateIsLastInSequence = lastSequenceEndingBeforeFix != null && lastCandidateBeforeReplacementFix == lastSequenceEndingBeforeFix.getLast();
                boolean bl2 = nextCandidateIsFirstInSequence = firstSequenceStartingAfterFix != null && firstCandidateAfterReplacementFix == firstSequenceStartingAfterFix.getFirst();
                boolean lookRight = previousCandidateIsLastInSequence && !nextCandidateIsFirstInSequence ? !lastSequenceEndingBeforeFix.tryToExtendAfterLast(firstCandidateAfterReplacementFix, candidatesEffectivelyAdded, candidatesEffectivelyRemoved) : true;
                if (lookRight && nextCandidateIsFirstInSequence && !previousCandidateIsLastInSequence) {
                    firstSequenceStartingAfterFix.tryToExtendBeforeFirst(lastCandidateBeforeReplacementFix, candidatesEffectivelyAdded, candidatesEffectivelyRemoved, this.stationarySequences);
                    continue;
                }
                if (previousCandidateIsLastInSequence || nextCandidateIsFirstInSequence || !(newSequence = this.createStationarySequence(lastCandidateBeforeReplacementFix)).tryToExtendAfterLast(firstCandidateAfterReplacementFix, candidatesEffectivelyAdded, candidatesEffectivelyRemoved)) continue;
                this.stationarySequences.add(newSequence);
            }
        }
        this.updateFilteredCandidates(candidatesEffectivelyAdded, candidatesEffectivelyRemoved);
        assert (this.containsNoEmptyOrSingleCandidateStationarySequence() && this.isCandidatesConsistent());
        return new Util.Pair(candidatesEffectivelyAdded, candidatesEffectivelyRemoved);
    }

    Iterable<Candidate> getFilteredCandidates() {
        return this.filteredCandidates;
    }
}

