/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.maneuverhash.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.maneuverhash.ManeuverCache;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprint;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprintFactory;
import com.sap.sailing.domain.maneuverhash.ManeuverRaceFingerprintRegistry;
import com.sap.sailing.domain.maneuverhash.SerializableManeuverCache;
import com.sap.sailing.domain.maneuverhash.impl.ManeuversFromDatabase;
import com.sap.sailing.domain.maneuverhash.impl.ManeuversFromSmartFutureCache;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.RaceFingerprint;
import com.sap.sailing.domain.tracking.impl.DynamicTrackedRaceImpl;
import com.sap.sailing.domain.tracking.impl.TrackedRaceImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ManeuverCacheDelegate
implements SerializableManeuverCache {
    private static final long serialVersionUID = 19872309587435L;
    private final TrackedRaceImpl race;
    private static final Logger logger = Logger.getLogger(ManeuverCacheDelegate.class.getName());
    private transient ManeuverRaceFingerprintRegistry maneuverRaceFingerprintRegistry;
    private volatile transient ManeuverCache cacheToUse;

    public ManeuverCacheDelegate(TrackedRaceImpl race, ManeuverRaceFingerprintRegistry maneuverRaceFingerprintRegistry) {
        this.race = race;
        this.maneuverRaceFingerprintRegistry = maneuverRaceFingerprintRegistry;
        this.cacheToUse = this.createUpdatableManeuverCache();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.cacheToUse = (ManeuversFromDatabase)ois.readObject();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(new ManeuversFromDatabase(this.getAllKnownManeuvers()));
    }

    @Override
    public void ensureFilled() {
        if (this.cacheToUse.canBeUpdated()) {
            for (Competitor competitor : this.race.getShuffledCompetitors()) {
                this.cacheToUse.triggerUpdate(competitor);
            }
        }
    }

    @Override
    public void setManeuverRaceFingerprintRegistry(ManeuverRaceFingerprintRegistry maneuverRaceFingerprintRegistry) {
        this.maneuverRaceFingerprintRegistry = maneuverRaceFingerprintRegistry;
    }

    private Map<Competitor, List<Maneuver>> getAllKnownManeuvers() {
        HashMap<Competitor, List<Maneuver>> result = new HashMap<Competitor, List<Maneuver>>();
        for (Competitor competitor : this.race.getRace().getCompetitors()) {
            List<Maneuver> maneuversForCompetitor = this.get(competitor, false);
            if (maneuversForCompetitor == null) continue;
            result.put(competitor, maneuversForCompetitor);
        }
        return result;
    }

    @Override
    public void resume() {
        RaceFingerprint fingerprint;
        if (this.maneuverRaceFingerprintRegistry != null) {
            logger.info("Compare maneuver fingerprints for race " + this.race.getRaceIdentifier());
            this.race.waitForAllRaceLogsAttached();
            fingerprint = this.maneuverRaceFingerprintRegistry.getManeuverRaceFingerprint((RaceIdentifier)this.race.getRaceIdentifier());
        } else {
            fingerprint = null;
        }
        if (fingerprint != null && fingerprint.matches(this.race)) {
            logger.info("Maneuver fingerprints match for race " + this.race.getRaceIdentifier() + "; loading from DB instead of computing");
            this.cacheToUse = new ManeuversFromDatabase(this.maneuverRaceFingerprintRegistry.loadManeuvers(this.race, this.race.getRace().getCourse()));
        } else {
            new Thread(() -> {
                logger.info("Maneuver fingerprints do not match for race " + this.race.getRaceIdentifier() + "; NOT loading from DB");
                if (!this.cacheToUse.canBeUpdated()) {
                    this.cacheToUse = this.createUpdatableManeuverCache();
                }
                this.cacheToUse.resume();
                if (this.maneuverRaceFingerprintRegistry != null) {
                    HashMap<Competitor, List<Maneuver>> maneuvers = new HashMap<Competitor, List<Maneuver>>();
                    for (Competitor competitor : this.race.getRace().getCompetitors()) {
                        maneuvers.put(competitor, this.cacheToUse.get(competitor, true));
                    }
                    this.maneuverRaceFingerprintRegistry.storeManeuvers((RaceIdentifier)this.race.getRaceIdentifier(), (ManeuverRaceFingerprint)ManeuverRaceFingerprintFactory.INSTANCE.createFingerprint(this.race), maneuvers, this.race.getRace().getCourse());
                }
            }, "Waiting for mark passings for " + this.race.getName() + " after having resumed to store the results in registry").start();
        }
    }

    @Override
    public List<Maneuver> get(Competitor competitor, boolean waitForLatest) {
        return this.cacheToUse.get(competitor, waitForLatest);
    }

    @Override
    public void suspend() {
        this.cacheToUse.suspend();
    }

    @Override
    public void triggerUpdate(Competitor competitor) {
        if (!this.cacheToUse.canBeUpdated()) {
            this.cacheToUse = this.createUpdatableManeuverCache();
        }
        this.cacheToUse.triggerUpdate(competitor);
    }

    private ManeuverCache createUpdatableManeuverCache() {
        return new ManeuversFromSmartFutureCache((DynamicTrackedRaceImpl)this.race);
    }

    @Override
    public boolean canBeUpdated() {
        return true;
    }
}

