/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.maneuverhash;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.Serializable;

public class MarkPassingProxy
implements MarkPassing {
    private static final long serialVersionUID = -1038446741597082803L;
    private final int waypointIndex;
    private final Serializable competitorId;
    private final TrackedRace trackedRace;
    private MarkPassing markPassing;
    private final TimePoint timePoint;

    public MarkPassingProxy(TimePoint timePoint, int waypointIndex, Serializable competitorId, TrackedRace trackedRace) {
        this.timePoint = timePoint;
        this.waypointIndex = waypointIndex;
        this.competitorId = competitorId;
        this.trackedRace = trackedRace;
    }

    public TimePoint getTimePoint() {
        return this.timePoint;
    }

    @Override
    public Waypoint getWaypoint() {
        Iterable waypoints = this.trackedRace.getRace().getCourse().getWaypoints();
        return (Waypoint)Util.get((Iterable)waypoints, (int)this.waypointIndex);
    }

    @Override
    public Competitor getCompetitor() {
        return this.trackedRace.getRace().getCompetitorById(this.competitorId);
    }

    @Override
    public MarkPassing getOriginal() {
        this.isMarkPassing();
        return this.markPassing == null ? null : this.markPassing.getOriginal();
    }

    private void isMarkPassing() {
        if (this.markPassing == null) {
            this.markPassing = this.trackedRace.getMarkPassing(this.getCompetitor(), this.getWaypoint());
        }
    }
}

