/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;

public class ThresholdBasedResultDiscardingRuleImpl
implements ThresholdBasedResultDiscardingRule {
    private static final long serialVersionUID = 386341628517357988L;
    private final int[] discardIndexResultsStartingWithHowManyRaces;

    public ThresholdBasedResultDiscardingRuleImpl(int[] discardIndexResultsStartingWithHowManyRaces) {
        this.discardIndexResultsStartingWithHowManyRaces = new int[discardIndexResultsStartingWithHowManyRaces.length];
        System.arraycopy(discardIndexResultsStartingWithHowManyRaces, 0, this.discardIndexResultsStartingWithHowManyRaces, 0, discardIndexResultsStartingWithHowManyRaces.length);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.discardIndexResultsStartingWithHowManyRaces);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ThresholdBasedResultDiscardingRuleImpl other = (ThresholdBasedResultDiscardingRuleImpl)obj;
        return Arrays.equals(this.discardIndexResultsStartingWithHowManyRaces, other.discardIndexResultsStartingWithHowManyRaces);
    }

    @Override
    public Set<RaceColumn> getDiscardedRaceColumns(Competitor competitor, Leaderboard leaderboard, Iterable<RaceColumn> raceColumnsToConsider, TimePoint timePoint, ScoringScheme scoringScheme) {
        return this.getDiscardedRaceColumns(competitor, leaderboard, raceColumnsToConsider, timePoint, scoringScheme, new LeaderboardDTOCalculationReuseCache(timePoint));
    }

    @Override
    public Set<RaceColumn> getDiscardedRaceColumns(Competitor competitor, final Leaderboard leaderboard, Iterable<RaceColumn> raceColumnsToConsider, TimePoint timePoint, ScoringScheme scoringScheme, Function<RaceColumn, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Set<RaceColumn> result;
        int resultsToDiscard = this.getNumberOfResultsToDiscard(competitor, raceColumnsToConsider, leaderboard, timePoint);
        if (resultsToDiscard > 0) {
            final HashMap<RaceColumn, Double> totalPointsForCompetitorPerColumn = new HashMap<RaceColumn, Double>();
            ArrayList<RaceColumn> sortedRaces = new ArrayList<RaceColumn>();
            for (RaceColumn raceColumn : raceColumnsToConsider) {
                if (!raceColumn.isDiscardable()) continue;
                sortedRaces.add(raceColumn);
                Double totalPoints = totalPointsSupplier.apply(raceColumn);
                totalPointsForCompetitorPerColumn.put(raceColumn, totalPoints == null ? null : Double.valueOf(scoringScheme.getScoreScaledByFactor(raceColumn, totalPoints)));
            }
            result = new HashSet<RaceColumn>();
            Comparator<RaceColumn> comparator = new Comparator<RaceColumn>(){

                @Override
                public int compare(RaceColumn raceColumn1, RaceColumn raceColumn2) {
                    return -leaderboard.getScoringScheme().getScoreComparator(true).compare((Double)totalPointsForCompetitorPerColumn.get(raceColumn1), (Double)totalPointsForCompetitorPerColumn.get(raceColumn2));
                }
            };
            Collections.sort(sortedRaces, comparator);
            Iterator badRacesIter = sortedRaces.iterator();
            while (badRacesIter.hasNext() && result.size() < resultsToDiscard) {
                RaceColumn badRace = (RaceColumn)badRacesIter.next();
                MaxPointsReason maxPointsReason = leaderboard.getMaxPointsReason(competitor, badRace, timePoint);
                if (maxPointsReason != null && !maxPointsReason.isDiscardable()) continue;
                this.addDiscardIfWithinSeriesLimits(result, badRace);
            }
        } else {
            result = Collections.emptySet();
        }
        return result;
    }

    private void addDiscardIfWithinSeriesLimits(Set<RaceColumn> result, RaceColumn badRace) {
        Series series;
        if (!(badRace instanceof RaceColumnInSeries) || (series = ((RaceColumnInSeries)badRace).getSeries()).getMaximumNumberOfDiscards() == null || this.getRacesDiscardedFromSeries(result, series) < series.getMaximumNumberOfDiscards()) {
            result.add(badRace);
        }
    }

    private int getRacesDiscardedFromSeries(Set<RaceColumn> result, Series series) {
        int count = 0;
        for (RaceColumn rc : result) {
            if (!(rc instanceof RaceColumnInSeries) || ((RaceColumnInSeries)rc).getSeries() != series) continue;
            ++count;
        }
        return count;
    }

    private int getNumberOfResultsToDiscard(Competitor competitor, Iterable<RaceColumn> raceColumnsToConsider, Leaderboard leaderboard, TimePoint timePoint) {
        int numberOfStartedRaces = 0;
        for (RaceColumn raceInLeaderboard : raceColumnsToConsider) {
            if (!leaderboard.countRaceForComparisonWithDiscardingThresholds(competitor, raceInLeaderboard, timePoint)) continue;
            ++numberOfStartedRaces;
        }
        int numberOfResultsToDiscard = 0;
        while (numberOfResultsToDiscard < this.discardIndexResultsStartingWithHowManyRaces.length && this.discardIndexResultsStartingWithHowManyRaces[numberOfResultsToDiscard] <= numberOfStartedRaces) {
            ++numberOfResultsToDiscard;
        }
        return numberOfResultsToDiscard;
    }

    @Override
    public int[] getDiscardIndexResultsStartingWithHowManyRaces() {
        return this.discardIndexResultsStartingWithHowManyRaces;
    }
}

