/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.MetaLeaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.impl.HighPoint;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;

public abstract class AbstractHighPointExtremeSailingSeriesOverall
extends HighPoint {
    private static final long serialVersionUID = -2500858156511889174L;
    private final int maxPoints;
    private static final int MIN_RACES_REQUIRED_TO_BE_SCORED = 5;

    protected AbstractHighPointExtremeSailingSeriesOverall(int maxPoints) {
        this.maxPoints = maxPoints;
    }

    @Override
    public Double getScoreForRank(Leaderboard leaderboard, RaceColumn raceColumn, Competitor competitor, int rank, Callable<Integer> numberOfCompetitorsInRaceFetcher, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, TimePoint timePoint) {
        Double result = rank == 0 ? null : Double.valueOf(Math.max(1.0, (double)(this.maxPoints - rank + 1)));
        return result;
    }

    @Override
    public int compareByBetterScore(Competitor o1, List<Util.Pair<RaceColumn, Double>> o1Scores, Competitor o2, List<Util.Pair<RaceColumn, Double>> o2Scores, Iterable<RaceColumn> raceColumnsToConsider, boolean nullScoresAreBetter, TimePoint timePoint, Leaderboard leaderboard, Map<Competitor, Set<RaceColumn>> discardedRaceColumnsPerCompetitor, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        int o1Wins = this.getWins(o1Scores);
        int o2Wins = this.getWins(o2Scores);
        int result = o2Wins - o1Wins;
        if (result == 0 && o1Scores.size() >= 1 && o2Scores.size() >= 1) {
            result = -((Double)o1Scores.get(o1Scores.size() - 1).getB()).compareTo((Double)o2Scores.get(o2Scores.size() - 1).getB());
        }
        return result;
    }

    private int getWins(List<Util.Pair<RaceColumn, Double>> scores) {
        int wins = 0;
        for (Util.Pair<RaceColumn, Double> score : scores) {
            if (!(Math.abs((Double)score.getB() - this.getScoreScaledByFactor((RaceColumn)score.getA(), this.maxPoints)) < 1.0E-7)) continue;
            ++wins;
        }
        return wins;
    }

    @Override
    public int compareByNumberOfRacesScored(int competitor1NumberOfRacesScored, int competitor2NumberOfRacesScored) {
        int result = competitor1NumberOfRacesScored >= 5 ? (competitor2NumberOfRacesScored >= 5 ? 0 : -1) : (competitor2NumberOfRacesScored >= 5 ? 1 : 0);
        return result;
    }

    @Override
    public int compareByLatestRegattaInMetaLeaderboard(Leaderboard leaderboard, Competitor o1, Competitor o2, TimePoint timePoint) {
        int result;
        assert (leaderboard instanceof MetaLeaderboard);
        if (leaderboard instanceof MetaLeaderboard) {
            MetaLeaderboard overallLeaderboard = (MetaLeaderboard)leaderboard;
            ArrayList<Double> o1PointsInLeaderboardsOfTheGroup = new ArrayList<Double>();
            ArrayList<Double> o2PointsInLeaderboardsOfTheGroup = new ArrayList<Double>();
            ArrayList randomAccessLeaderboardList = new ArrayList(Util.size(overallLeaderboard.getLeaderboards()));
            Util.addAll(overallLeaderboard.getLeaderboards(), randomAccessLeaderboardList);
            for (Leaderboard leaderboardInOverall : overallLeaderboard.getLeaderboards()) {
                o1PointsInLeaderboardsOfTheGroup.add(leaderboardInOverall.getNetPoints(o1, timePoint));
                o2PointsInLeaderboardsOfTheGroup.add(leaderboardInOverall.getNetPoints(o2, timePoint));
            }
            int localResult = 0;
            ListIterator reverseLeaderbaordIterator = randomAccessLeaderboardList.listIterator(randomAccessLeaderboardList.size());
            while (reverseLeaderbaordIterator.hasPrevious()) {
                Leaderboard leaderboardInOverall = (Leaderboard)reverseLeaderbaordIterator.previous();
                Double o1PointsForLeaderboard = leaderboardInOverall.getNetPoints(o1, timePoint);
                Double o2PointsForLeaderboard = leaderboardInOverall.getNetPoints(o2, timePoint);
                if (o1PointsForLeaderboard == null || o2PointsForLeaderboard == null || !(o1PointsForLeaderboard > 0.0) || !(o2PointsForLeaderboard > 0.0)) continue;
                localResult = -o1PointsForLeaderboard.compareTo(o2PointsForLeaderboard);
                break;
            }
            result = localResult;
        } else {
            result = 0;
        }
        return result;
    }
}

