/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.impl.AllEventsOfTypeFinder;
import com.sap.sailing.domain.abstractlog.impl.LogEventAuthorImpl;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.LastPublishedCourseDesignFinder;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogUseCompetitorsFromRaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.analyzing.impl.RegisteredCompetitorsAnalyzer;
import com.sap.sailing.domain.abstractlog.race.tracking.analyzing.impl.RegisteredCompetitorsAndBoatsAnalyzer;
import com.sap.sailing.domain.abstractlog.race.tracking.impl.RaceLogRegisterCompetitorEventImpl;
import com.sap.sailing.domain.abstractlog.race.tracking.impl.RaceLogUseCompetitorsFromRaceLogEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogDefinedMarkAnalyzer;
import com.sap.sailing.domain.abstractlog.shared.events.RegisterCompetitorEvent;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.RaceColumnRaceLogReplicator;
import com.sap.sailing.domain.base.impl.SimpleAbstractRaceColumn;
import com.sap.sailing.domain.base.impl.TrackedRaces;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.abstractlog.NotRevokableException;
import com.sap.sailing.domain.common.racelog.tracking.CompetitorRegistrationOnRaceLogDisabledException;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.racelog.impl.RaceLogIdentifierImpl;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifier;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractRaceColumn
extends SimpleAbstractRaceColumn
implements RaceColumn {
    private static final long serialVersionUID = -7801617988982540470L;
    private static final Logger logger = Logger.getLogger(AbstractRaceColumn.class.getName());
    private final AbstractLogEventAuthor raceLogEventAuthorForRaceColumn = new LogEventAuthorImpl(AbstractRaceColumn.class.getName(), 0);
    private TrackedRaces trackedRaces = new TrackedRaces();
    private Map<Fleet, RaceIdentifier> raceIdentifiers = new HashMap<Fleet, RaceIdentifier>();
    private ConcurrentMap<Fleet, RaceLog> raceLogs = new ConcurrentHashMap<Fleet, RaceLog>();
    private transient RaceLogStore raceLogStore;
    private RegattaLikeIdentifier regattaLikeParent;

    @Override
    public synchronized void setRaceLogInformationAndLoad(RaceLogStore raceLogStore, RegattaLikeIdentifier regattaLikeParent) {
        this.setRaceLogInformation(raceLogStore, regattaLikeParent);
        for (Fleet fleet : this.getFleets()) {
            this.reloadRaceLog(fleet);
        }
    }

    @Override
    public synchronized void setRaceLogInformation(RaceLogStore raceLogStore, RegattaLikeIdentifier regattaLikeParent) {
        this.raceLogStore = raceLogStore;
        this.regattaLikeParent = regattaLikeParent;
    }

    @Override
    public RaceLog getRaceLog(Fleet fleet) {
        return (RaceLog)this.raceLogs.get(fleet);
    }

    @Override
    public RaceLogIdentifier getRaceLogIdentifier(Fleet fleet) {
        return new RaceLogIdentifierImpl(this.regattaLikeParent, this.getName(), fleet);
    }

    @Override
    public TrackedRace getTrackedRace(Fleet fleet) {
        return this.trackedRaces == null ? null : this.trackedRaces.get(fleet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTrackedRace(Fleet fleet, TrackedRace trackedRace) {
        TrackedRace previouslyLinkedRace = this.trackedRaces.get(fleet);
        if (trackedRace != previouslyLinkedRace) {
            this.releaseTrackedRace(fleet);
            AbstractRaceColumn abstractRaceColumn = this;
            synchronized (abstractRaceColumn) {
                if (trackedRace != null) {
                    this.trackedRaces.put(fleet, trackedRace);
                    this.setRaceIdentifier(fleet, (RaceIdentifier)trackedRace.getRaceIdentifier());
                    logger.info(String.format("Linked race column %s with tracked race %s.", this.getName(), trackedRace.getRace() == null ? "null" : trackedRace.getRace().getName()));
                }
            }
            if (trackedRace != null) {
                RaceLog raceLog;
                RegattaLog regattaLog = this.getRegattaLog();
                if (regattaLog != null) {
                    trackedRace.attachRegattaLog(regattaLog);
                }
                if ((raceLog = this.getRaceLog(fleet)) != null) {
                    trackedRace.attachRaceLog(raceLog);
                }
                trackedRace.attachRaceExecutionProvider(this.getRaceExecutionOrderProvider());
                this.getRaceColumnListeners().notifyListenersAboutTrackedRaceLinked(this, fleet, trackedRace);
            }
        }
    }

    @Override
    public RaceIdentifier getRaceIdentifier(Fleet fleet) {
        return this.raceIdentifiers.get(fleet);
    }

    @Override
    public void setRaceIdentifier(Fleet fleet, RaceIdentifier raceIdentifier) {
        if (raceIdentifier != null) {
            this.raceIdentifiers.put(fleet, raceIdentifier);
        }
    }

    @Override
    public synchronized void releaseTrackedRace(Fleet fleet) {
        TrackedRace previouslyLinkedRace = this.trackedRaces.remove(fleet);
        if (previouslyLinkedRace != null && this.regattaLikeParent != null) {
            RaceLogIdentifier identifier = this.getRaceLogIdentifier(fleet);
            previouslyLinkedRace.detachRaceLog((Serializable)identifier.getIdentifier());
            previouslyLinkedRace.detachRaceExecutionOrderProvider(this.getRaceExecutionOrderProvider());
            this.getRaceColumnListeners().notifyListenersAboutTrackedRaceUnlinked(this, fleet, previouslyLinkedRace);
        }
    }

    @Override
    public void removeRaceIdentifier(Fleet fleet) {
        this.releaseTrackedRace(fleet);
        this.raceIdentifiers.remove(fleet);
    }

    @Override
    public Fleet getFleetOfCompetitor(Competitor competitor) {
        for (Fleet fleet : this.getFleets()) {
            if (!Util.contains(this.getAllCompetitors(fleet), (Object)competitor)) continue;
            return fleet;
        }
        return null;
    }

    @Override
    public Fleet getFleetByName(String fleetName) {
        for (Fleet fleet : this.getFleets()) {
            if (!fleet.getName().equals(fleetName)) continue;
            return fleet;
        }
        return null;
    }

    @Override
    public boolean hasTrackedRaces() {
        return !this.trackedRaces.isEmpty();
    }

    @Override
    public TrackedRace getTrackedRace(Competitor competitor) {
        return this.trackedRaces.get(competitor);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void reloadRaceLog(Fleet fleet) {
        RaceLogIdentifier identifier = this.getRaceLogIdentifier(fleet);
        RaceLog newOrLoadedRaceLog = this.raceLogStore.getRaceLog(identifier, true);
        RaceLog raceLogAvailable = (RaceLog)this.raceLogs.get(fleet);
        if (raceLogAvailable == null) {
            RaceColumnRaceLogReplicator listener = new RaceColumnRaceLogReplicator(this, identifier);
            newOrLoadedRaceLog.addListener((Object)listener);
            this.raceLogs.put(fleet, newOrLoadedRaceLog);
            TrackedRace trackedRace = this.getTrackedRace(fleet);
            if (trackedRace != null) {
                trackedRace.attachRaceLog(newOrLoadedRaceLog);
            }
        } else {
            raceLogAvailable.merge((AbstractLog)newOrLoadedRaceLog);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        for (Map.Entry entry : this.raceLogs.entrySet()) {
            Fleet fleet = (Fleet)entry.getKey();
            RaceLog raceLog = (RaceLog)entry.getValue();
            raceLog.addListener((Object)new RaceColumnRaceLogReplicator(this, this.getRaceLogIdentifier(fleet)));
            ois.registerValidation(() -> {
                TrackedRace trackedRace = this.getTrackedRace(fleet);
                if (trackedRace != null) {
                    trackedRace.attachRaceLog(raceLog);
                    RegattaLog regattaLog = this.getRegattaLog();
                    if (regattaLog != null) {
                        trackedRace.attachRegattaLog(regattaLog);
                    }
                }
            }, 0);
        }
    }

    @Override
    public void setMasterDataExportOngoingThreadFlag(boolean flagValue) {
        this.trackedRaces.setMasterDataExportOngoingThreadFlag(flagValue);
    }

    @Override
    public Iterable<Competitor> getAllCompetitors() {
        return (Iterable)this.getAllCompetitorsWithRaceDefinitionsConsidered().getB();
    }

    @Override
    public Util.Pair<Iterable<RaceDefinition>, Iterable<Competitor>> getAllCompetitorsWithRaceDefinitionsConsidered() {
        HashSet competitors = new HashSet();
        HashSet<RaceDefinition> raceDefinitionsConsidered = new HashSet<RaceDefinition>();
        for (Fleet fleet : this.getFleets()) {
            Util.Pair<RaceDefinition, Iterable<Competitor>> allCompetitorsWithRaceDefinitionsConsidered = this.getAllCompetitorsWithRaceDefinitionsConsidered(fleet);
            Util.addAll((Iterable)((Iterable)allCompetitorsWithRaceDefinitionsConsidered.getB()), competitors);
            if (allCompetitorsWithRaceDefinitionsConsidered.getA() == null) continue;
            raceDefinitionsConsidered.add((RaceDefinition)allCompetitorsWithRaceDefinitionsConsidered.getA());
        }
        return new Util.Pair(raceDefinitionsConsidered, competitors);
    }

    private Util.Pair<RaceDefinition, Iterable<Competitor>> getAllCompetitorsWithRaceDefinitionsConsidered(Fleet fleet) {
        Set competitors;
        RaceDefinition raceDefinition;
        TrackedRace trackedRace = this.getTrackedRace(fleet);
        if (trackedRace != null) {
            raceDefinition = trackedRace.getRace();
            competitors = raceDefinition.getCompetitors();
        } else {
            Set viaRaceLog;
            raceDefinition = null;
            competitors = viaRaceLog = (Set)new RegisteredCompetitorsAnalyzer(this.getRaceLog(fleet), this.getRegattaLog()).analyze();
        }
        return new Util.Pair((Object)raceDefinition, competitors);
    }

    @Override
    public Iterable<Competitor> getAllCompetitors(Fleet fleet) {
        return (Iterable)this.getAllCompetitorsWithRaceDefinitionsConsidered(fleet).getB();
    }

    @Override
    public Map<Competitor, Boat> getAllCompetitorsAndTheirBoats() {
        HashMap<Competitor, Boat> result = new HashMap<Competitor, Boat>();
        for (Fleet fleet : this.getFleets()) {
            result.putAll(this.getAllCompetitorsAndTheirBoats(fleet));
        }
        return result;
    }

    @Override
    public Map<Competitor, Boat> getAllCompetitorsAndTheirBoats(Fleet fleet) {
        TrackedRace trackedRace = this.getTrackedRace(fleet);
        Map competitors = trackedRace != null ? trackedRace.getRace().getCompetitorsAndTheirBoats() : (Map)new RegisteredCompetitorsAndBoatsAnalyzer(this.getRaceLog(fleet), this.getRegattaLog()).analyze();
        return competitors;
    }

    @Override
    public void registerCompetitor(CompetitorWithBoat competitorWithBoat, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        HashMap<Competitor, Boat> competitorsAndBoats = new HashMap<Competitor, Boat>();
        competitorsAndBoats.put((Competitor)competitorWithBoat, competitorWithBoat.getBoat());
        this.registerCompetitorsInternal(competitorsAndBoats, fleet);
    }

    @Override
    public void registerCompetitors(Iterable<CompetitorWithBoat> competitorWithBoats, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        HashMap<Competitor, Boat> competitorsAndBoats = new HashMap<Competitor, Boat>();
        for (CompetitorWithBoat competitorWithBoat : competitorWithBoats) {
            competitorsAndBoats.put((Competitor)competitorWithBoat, competitorWithBoat.getBoat());
        }
        this.registerCompetitorsInternal(competitorsAndBoats, fleet);
    }

    @Override
    public void registerCompetitor(Competitor competitor, Boat boat, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        HashMap<Competitor, Boat> competitorsAndBoats = new HashMap<Competitor, Boat>();
        competitorsAndBoats.put(competitor, boat);
        this.registerCompetitorsInternal(competitorsAndBoats, fleet);
    }

    @Override
    public void registerCompetitors(Map<Competitor, Boat> competitorsAndBoats, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        this.registerCompetitorsInternal(competitorsAndBoats, fleet);
    }

    private void registerCompetitorsInternal(Map<Competitor, Boat> competitorsAndBoats, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        if (!this.isCompetitorRegistrationInRacelogEnabled(fleet)) {
            throw new CompetitorRegistrationOnRaceLogDisabledException("Competitor registration not allowed for fleet " + fleet + " in column " + this);
        }
        TimePoint now = MillisecondsTimePoint.now();
        RaceLog raceLog = this.getRaceLog(fleet);
        int passId = raceLog.getCurrentPassId();
        for (Map.Entry<Competitor, Boat> competitorAndBoat : competitorsAndBoats.entrySet()) {
            raceLog.add((AbstractLogEvent)new RaceLogRegisterCompetitorEventImpl(now, now, this.raceLogEventAuthorForRaceColumn, (Serializable)UUID.randomUUID(), passId, competitorAndBoat.getKey(), competitorAndBoat.getValue()));
        }
    }

    @Override
    public void deregisterCompetitor(Competitor competitor, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        this.deregisterCompetitors(Collections.singleton(competitor), fleet);
    }

    @Override
    public void deregisterCompetitors(Iterable<? extends Competitor> competitors, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        if (!this.isCompetitorRegistrationInRacelogEnabled(fleet)) {
            throw new CompetitorRegistrationOnRaceLogDisabledException("Competitor registration not allowed for fleet " + fleet + " in column " + this);
        }
        HashSet competitorSet = new HashSet();
        Util.addAll(competitors, competitorSet);
        RaceLog raceLog = this.getRaceLog(fleet);
        HashSet<RaceLogEvent> competitorRegistrationEventsToRevoke = new HashSet<RaceLogEvent>();
        raceLog.lockForRead();
        try {
            for (RaceLogEvent event : raceLog.getUnrevokedEventsDescending()) {
                RegisterCompetitorEvent registerEvent;
                if (!(event instanceof RegisterCompetitorEvent) || !competitorSet.contains((registerEvent = (RegisterCompetitorEvent)event).getCompetitor())) continue;
                competitorRegistrationEventsToRevoke.add(event);
            }
        }
        finally {
            raceLog.unlockAfterRead();
        }
        for (RaceLogEvent eventToRevoke : competitorRegistrationEventsToRevoke) {
            try {
                raceLog.revokeEvent(this.raceLogEventAuthorForRaceColumn, (AbstractLogEvent)eventToRevoke, "unregistering competitor because no longer selected for registration");
            }
            catch (NotRevokableException e) {
                logger.log(Level.WARNING, "could not unregister competitor by adding RevokeEvent", e);
            }
        }
    }

    @Override
    public Iterable<Mark> getCourseMarks() {
        HashSet<Mark> result = new HashSet<Mark>();
        for (Fleet fleet : this.getFleets()) {
            Util.addAll(this.getCourseMarks(fleet), result);
        }
        return result;
    }

    @Override
    public Iterable<Mark> getCourseMarks(Fleet fleet) {
        HashSet<Mark> result = new HashSet<Mark>();
        TrackedRace trackedRace = this.getTrackedRace(fleet);
        if (trackedRace != null) {
            for (Waypoint waypoint2 : trackedRace.getRace().getCourse().getWaypoints()) {
                Util.addAll((Iterable)waypoint2.getMarks(), result);
            }
        } else {
            LastPublishedCourseDesignFinder courseDesginFinder = new LastPublishedCourseDesignFinder(this.getRaceLog(fleet), true);
            CourseBase courseBase = (CourseBase)courseDesginFinder.analyze();
            if (courseBase != null) {
                courseBase.getWaypoints().forEach(waypoint -> {
                    Collection collection = Util.addAll((Iterable)waypoint.getMarks(), (Collection)result);
                });
            }
        }
        return result;
    }

    @Override
    public Iterable<Mark> getAvailableMarks() {
        HashSet<Mark> result = new HashSet<Mark>();
        RegattaLog regattaLog = this.getRegattaLog();
        Collection viaRegattaLog = (Collection)new RegattaLogDefinedMarkAnalyzer(regattaLog).analyze();
        result.addAll(viaRegattaLog);
        for (Fleet fleet : this.getFleets()) {
            TrackedRace trackedRace = this.getTrackedRace(fleet);
            if (trackedRace == null) continue;
            Util.addAll(trackedRace.getMarks(), result);
        }
        return result;
    }

    @Override
    public Iterable<Mark> getAvailableMarks(Fleet fleet) {
        HashSet<Mark> result = new HashSet<Mark>();
        RegattaLog regattaLog = this.getRegattaLog();
        Collection viaRegattaLog = (Collection)new RegattaLogDefinedMarkAnalyzer(regattaLog).analyze();
        result.addAll(viaRegattaLog);
        TrackedRace trackedRace = this.getTrackedRace(fleet);
        if (trackedRace != null) {
            Util.addAll(trackedRace.getMarks(), result);
        }
        return result;
    }

    @Override
    public void enableCompetitorRegistrationOnRaceLog(Fleet fleet) {
        TimePoint now = MillisecondsTimePoint.now();
        RaceLog raceLog = this.getRaceLog(fleet);
        int passId = raceLog.getCurrentPassId();
        raceLog.add((AbstractLogEvent)new RaceLogUseCompetitorsFromRaceLogEventImpl(now, this.raceLogEventAuthorForRaceColumn, now, (Serializable)UUID.randomUUID(), passId));
    }

    @Override
    public void disableCompetitorRegistrationOnRaceLog(Fleet fleet) throws NotRevokableException {
        RaceLog raceLog = this.getRaceLog(fleet);
        List events = (List)new AllEventsOfTypeFinder((AbstractLog)raceLog, true, RaceLogUseCompetitorsFromRaceLogEvent.class).analyze();
        for (RaceLogEvent event : events) {
            raceLog.lockForRead();
            try {
                event = (RaceLogEvent)raceLog.getEventById(event.getId());
            }
            finally {
                raceLog.unlockAfterRead();
            }
            if (event == null) continue;
            raceLog.revokeEvent(this.raceLogEventAuthorForRaceColumn, (AbstractLogEvent)event, "revoke triggered by GWT user action");
        }
    }
}

