/*
 * Decompiled with CFR 0.152.
 */
package difflib.myers;

import difflib.ChangeDelta;
import difflib.Chunk;
import difflib.DeleteDelta;
import difflib.Delta;
import difflib.DiffAlgorithm;
import difflib.InsertDelta;
import difflib.Patch;
import difflib.myers.DiffNode;
import difflib.myers.DifferentiationFailedException;
import difflib.myers.PathNode;
import difflib.myers.Snake;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class MyersDiff<T>
implements DiffAlgorithm<T> {
    @Override
    public Patch<T> diff(Iterable<T> original, Iterable<T> revised) {
        ArrayList<T> originalList = new ArrayList<T>();
        for (T o : original) {
            originalList.add(o);
        }
        Object[] originalArray = originalList.toArray();
        ArrayList<T> revisedList = new ArrayList<T>();
        for (T o : revised) {
            revisedList.add(o);
        }
        Object[] revisedArray = revisedList.toArray();
        return this.diff(originalArray, revisedArray);
    }

    @Override
    public Patch<T> diff(T[] orig, T[] rev) {
        try {
            PathNode path = MyersDiff.buildPath(orig, rev);
            return MyersDiff.buildRevision(path, orig, rev);
        }
        catch (DifferentiationFailedException e) {
            e.printStackTrace();
            return new Patch();
        }
    }

    public static PathNode buildPath(Object[] orig, Object[] rev) throws DifferentiationFailedException {
        if (orig == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (rev == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        int N = orig.length;
        int M = rev.length;
        int MAX = N + M + 1;
        int size = 1 + 2 * MAX;
        int middle = size / 2;
        PathNode[] diagonal = new PathNode[size];
        diagonal[middle + 1] = new Snake(0, -1, null);
        int d = 0;
        while (d < MAX) {
            int k = -d;
            while (k <= d) {
                int i;
                int kmiddle = middle + k;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                PathNode prev = null;
                if (k == -d || k != d && diagonal[kminus].i < diagonal[kplus].i) {
                    i = diagonal[kplus].i;
                    prev = diagonal[kplus];
                } else {
                    i = diagonal[kminus].i + 1;
                    prev = diagonal[kminus];
                }
                diagonal[kminus] = null;
                int j = i - k;
                PathNode node = new DiffNode(i, j, prev);
                while (i < N && j < M && orig[i].equals(rev[j])) {
                    ++i;
                    ++j;
                }
                if (i > node.i) {
                    node = new Snake(i, j, node);
                }
                diagonal[kmiddle] = node;
                if (i >= N && j >= M) {
                    return diagonal[kmiddle];
                }
                k += 2;
            }
            diagonal[middle + d - 1] = null;
            ++d;
        }
        throw new DifferentiationFailedException("could not find a diff path");
    }

    public static <T> Patch<T> buildRevision(PathNode path, T[] orig, T[] rev) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (orig == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (rev == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        Patch<T> patch = new Patch<T>();
        if (path.isSnake()) {
            path = path.prev;
        }
        while (path != null && path.prev != null && path.prev.j >= 0) {
            if (path.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int i = path.i;
            int j = path.j;
            path = path.prev;
            int ianchor = path.i;
            int janchor = path.j;
            Chunk<T> original = new Chunk<T>(ianchor, MyersDiff.copyOfRange(orig, ianchor, i));
            Chunk<T> revised = new Chunk<T>(janchor, MyersDiff.copyOfRange(rev, janchor, j));
            Delta delta = null;
            delta = original.size() == 0 && revised.size() != 0 ? new InsertDelta<T>(original, revised) : (original.size() > 0 && revised.size() == 0 ? new DeleteDelta<T>(original, revised) : new ChangeDelta<T>(original, revised));
            patch.addDelta(delta);
            if (!path.isSnake()) continue;
            path = path.prev;
        }
        return patch;
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return MyersDiff.copyOfRange(original, from, to, original.getClass());
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(String.valueOf(from) + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }
}

