/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.server.util.actions.startlineadvantage;

import com.google.gwt.core.shared.GwtIncompatible;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Distance;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.Iterator;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtIncompatible
public final class StartlineAdvantageByGeometryCalculator {
    public static Double calculateStartlineAdvantageByGeometry(TrackedRace trackedRace) {
        Double result = null;
        Course course = trackedRace.getRace().getCourse();
        if (course != null) {
            Waypoint startlineWayPoint = course.getFirstLeg().getFrom();
            Waypoint firstmarkWayPoint = course.getFirstLeg().getTo();
            if (startlineWayPoint != null && firstmarkWayPoint != null) {
                Util.Pair startlineMarkPositions = StartlineAdvantageByGeometryCalculator.retrieveStartlineMarkPositionsFromStartLineWayPoint((TrackedRace)trackedRace, (Waypoint)startlineWayPoint);
                Position firstMarkPosition = StartlineAdvantageByGeometryCalculator.retrieveFirstMarkPositionFromFirstMarkWayPoint((TrackedRace)trackedRace, (Waypoint)firstmarkWayPoint);
                if (startlineMarkPositions != null && firstMarkPosition != null) {
                    Distance rcToMark = firstMarkPosition.getDistance((Position)startlineMarkPositions.getA());
                    Distance pinToMark = firstMarkPosition.getDistance((Position)startlineMarkPositions.getB());
                    double startlineadvantage = rcToMark.getMeters() - pinToMark.getMeters();
                    result = startlineadvantage;
                }
            }
        }
        return result;
    }

    private static Util.Pair<Position, Position> retrieveStartlineMarkPositionsFromStartLineWayPoint(TrackedRace trackedRace, Waypoint startLineWayPoint) {
        Util.Pair result = null;
        Iterator markIterator = startLineWayPoint.getMarks().iterator();
        if (markIterator.hasNext()) {
            Mark startboat = (Mark)markIterator.next();
            if (markIterator.hasNext()) {
                Mark pinEnd = (Mark)markIterator.next();
                TimePoint now = MillisecondsTimePoint.now();
                Position startBoatPosition = StartlineAdvantageByGeometryCalculator.getPositionFromMarkAtTimePoint((TrackedRace)trackedRace, (Mark)startboat, (TimePoint)now);
                Position pinEndPosition = StartlineAdvantageByGeometryCalculator.getPositionFromMarkAtTimePoint((TrackedRace)trackedRace, (Mark)pinEnd, (TimePoint)now);
                if (startBoatPosition != null && pinEndPosition != null) {
                    result = new Util.Pair((Object)startBoatPosition, (Object)pinEndPosition);
                }
            }
        }
        return result;
    }

    private static Position getPositionFromMarkAtTimePoint(TrackedRace trackedRace, Mark mark, TimePoint timePoint) {
        GPSFixTrack fixTrack = trackedRace.getTrack(mark);
        return fixTrack.getEstimatedPosition(timePoint, true);
    }

    private static Position retrieveFirstMarkPositionFromFirstMarkWayPoint(TrackedRace trackedRace, Waypoint firstMarkWayPoint) {
        Position firstMarkPosition = null;
        if (firstMarkWayPoint.getMarks().iterator().hasNext()) {
            Mark firstMark = (Mark)firstMarkWayPoint.getMarks().iterator().next();
            TimePoint now = MillisecondsTimePoint.now();
            firstMarkPosition = StartlineAdvantageByGeometryCalculator.getPositionFromMarkAtTimePoint((TrackedRace)trackedRace, (Mark)firstMark, (TimePoint)now);
        }
        return firstMarkPosition;
    }
}

