/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.shared.subscription.chargebee;

import com.sap.sse.common.TimePoint;
import com.sap.sse.security.ui.shared.subscription.SubscriptionDTO;

public class ChargebeeSubscriptionDTO
extends SubscriptionDTO {
    private static final String SUBSCRIPTION_STATUS_TRIAL = "in_trial";
    private static final String SUBSCRIPTION_STATUS_ACTIVE = "active";
    private static final String SUBSCRIPTION_STATUS_NON_RENEWING = "non_renewing";
    private static final String SUBSCRIPTION_STATUS_PAUSED = "paused";
    private static final String SUBSCRIPTION_STATUS_CANCELLED = "cancelled";
    private static final String TRANSACTION_TYPE_REFUND = "refund";

    protected ChargebeeSubscriptionDTO() {
    }

    public ChargebeeSubscriptionDTO(String planId, String subscriptionId, String subscriptionStatus, String paymentStatus, String transactionType, Integer reoccuringPaymentValue, String currencyCode, TimePoint createdAt, TimePoint trialEnd, TimePoint currentTermEnd, TimePoint cancelledAt, TimePoint nextBillingAt) {
        super(planId, subscriptionId, subscriptionStatus, paymentStatus, transactionType, reoccuringPaymentValue, currencyCode, createdAt, trialEnd, currentTermEnd, cancelledAt, nextBillingAt, "chargebee");
    }

    public boolean isInTrial() {
        return SUBSCRIPTION_STATUS_TRIAL.equals(this.getSubscriptionStatus());
    }

    public boolean isActive() {
        return SUBSCRIPTION_STATUS_ACTIVE.equals(this.getSubscriptionStatus()) || SUBSCRIPTION_STATUS_NON_RENEWING.equals(this.getSubscriptionStatus());
    }

    public boolean isPaused() {
        return SUBSCRIPTION_STATUS_PAUSED.equals(this.getSubscriptionStatus());
    }

    public boolean isCancelled() {
        return SUBSCRIPTION_STATUS_CANCELLED.equals(this.getSubscriptionStatus());
    }

    public boolean isRefunded() {
        return TRANSACTION_TYPE_REFUND.equals(this.getTransactionType());
    }
}

