/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.ui.client.component.usergroup.roles;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.MultiSelectionModel;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.celltable.AbstractSortableTextColumn;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.celltable.TableWrapper;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.shared.dto.StrippedRoleDefinitionDTO;
import com.sap.sse.security.shared.dto.UserGroupDTO;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.usergroup.roles.RoleDefinitionImagesBarCell;

public class RoleDefinitionTableWrapper
extends TableWrapper<Util.Pair<StrippedRoleDefinitionDTO, Boolean>, RefreshableSingleSelectionModel<Util.Pair<StrippedRoleDefinitionDTO, Boolean>>, com.sap.sse.security.ui.client.i18n.StringMessages, CellTableWithCheckboxResources> {
    private final LabeledAbstractFilterablePanel<Util.Pair<StrippedRoleDefinitionDTO, Boolean>> filterField;
    private final MultiSelectionModel<UserGroupDTO> userGroupSelectionModel;

    public RoleDefinitionTableWrapper(UserService userService, com.sap.sse.security.ui.client.i18n.StringMessages stringMessages, ErrorReporter errorReporter, boolean enablePager, CellTableWithCheckboxResources tableResources, Runnable refresher, MultiSelectionModel<UserGroupDTO> userGroupSelectionModel) {
        super((StringMessages)stringMessages, errorReporter, false, enablePager, (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, tableResources);
        this.userGroupSelectionModel = userGroupSelectionModel;
        this.userGroupSelectionModel.addSelectionChangeHandler(e -> this.refreshRoleList());
        ColumnSortEvent.ListHandler roleColumnListHandler = this.getColumnSortHandler();
        AbstractSortableTextColumn roleDefinitionWithSecurityDTONameColumn = new AbstractSortableTextColumn(dto -> ((StrippedRoleDefinitionDTO)dto.getA()).getName(), roleColumnListHandler);
        AccessControlledActionsColumn actionsColumn = AccessControlledActionsColumn.create((ImagesBarCell)new RoleDefinitionImagesBarCell(stringMessages), (UserService)userService, role -> (SecuredDTO)TableWrapper.getSingleSelectedObjectOrNull((MultiSelectionModel)userGroupSelectionModel));
        actionsColumn.addAction(RoleDefinitionImagesBarCell.ACTION_UPDATE, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, rolePair -> {
            boolean value;
            UserGroupDTO selectedObject = (UserGroupDTO)TableWrapper.getSingleSelectedObjectOrNull((MultiSelectionModel)userGroupSelectionModel);
            boolean bl = value = (Boolean)rolePair.getB() == false;
            if (selectedObject != null) {
                userService.getUserManagementWriteService().putRoleDefintionToUserGroup(selectedObject.getId().toString(), ((StrippedRoleDefinitionDTO)rolePair.getA()).getId().toString(), value, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        });
        actionsColumn.addAction(RoleDefinitionImagesBarCell.ACTION_DELETE, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE, rolePair -> {
            UserGroupDTO selectedObject = (UserGroupDTO)TableWrapper.getSingleSelectedObjectOrNull((MultiSelectionModel)userGroupSelectionModel);
            if (selectedObject != null) {
                if (Window.confirm((String)stringMessages.doYouReallyWantToRemoveRole(((StrippedRoleDefinitionDTO)rolePair.getA()).getName()))) {
                    userService.getUserManagementWriteService().removeRoleDefinitionFromUserGroup(selectedObject.getId().toString(), ((StrippedRoleDefinitionDTO)rolePair.getA()).getId().toString(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
                }
            } else {
                Window.alert((String)stringMessages.pleaseSelect());
            }
        });
        this.filterField = new /* Unavailable Anonymous Inner Class!! */;
        this.registerSelectionModelOnNewDataProvider(this.filterField.getAllListDataProvider());
        this.mainPanel.insert((Widget)this.filterField, 0);
        this.table.addColumn((Column)roleDefinitionWithSecurityDTONameColumn, stringMessages.roleName());
        AbstractSortableTextColumn forAllUsersColumn = new AbstractSortableTextColumn(rolePair -> (Boolean)rolePair.getB() != false ? stringMessages.yes() : stringMessages.no(), roleColumnListHandler);
        this.table.addColumn((Column)forAllUsersColumn, stringMessages.enabledForAllUsers());
        this.table.addColumn((Column)actionsColumn);
        this.table.ensureDebugId("GroupRoleDefinitionDTOTable");
    }

    public LabeledAbstractFilterablePanel<Util.Pair<StrippedRoleDefinitionDTO, Boolean>> getFilterField() {
        return this.filterField;
    }

    public void refreshRoleList() {
        UserGroupDTO selectedObject = (UserGroupDTO)TableWrapper.getSingleSelectedObjectOrNull((MultiSelectionModel)this.userGroupSelectionModel);
        if (selectedObject != null) {
            this.filterField.updateAll(selectedObject.getRoleDefinitions());
        }
    }

    static /* synthetic */ FlushableCellTable access$0(RoleDefinitionTableWrapper roleDefinitionTableWrapper) {
        return roleDefinitionTableWrapper.table;
    }
}

