/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.ui.client.selection;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.builder.shared.HtmlBuilderFactory;
import com.google.gwt.dom.builder.shared.HtmlUListBuilder;
import com.google.gwt.dom.builder.shared.LIBuilder;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.ValueListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.SerializableSettings;
import com.sap.sse.datamining.shared.DataMiningSession;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.data.ReportParameterToDimensionFilterBindings;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.GenericGroupKey;
import com.sap.sse.datamining.shared.impl.dto.AggregationProcessorDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverChainDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.DataRetrieverLevelDTO;
import com.sap.sse.datamining.shared.impl.dto.FunctionDTO;
import com.sap.sse.datamining.shared.impl.dto.ModifiableStatisticQueryDefinitionDTO;
import com.sap.sse.datamining.ui.client.DataMiningComponentProvider;
import com.sap.sse.datamining.ui.client.DataMiningServiceAsync;
import com.sap.sse.datamining.ui.client.DataMiningSettingsControl;
import com.sap.sse.datamining.ui.client.DataMiningSettingsInfoManager;
import com.sap.sse.datamining.ui.client.DataRetrieverChainDefinitionProvider;
import com.sap.sse.datamining.ui.client.FilterSelectionChangedListener;
import com.sap.sse.datamining.ui.client.FilterSelectionProvider;
import com.sap.sse.datamining.ui.client.GroupingChangedListener;
import com.sap.sse.datamining.ui.client.GroupingProvider;
import com.sap.sse.datamining.ui.client.ReportProvider;
import com.sap.sse.datamining.ui.client.StatisticChangedListener;
import com.sap.sse.datamining.ui.client.StatisticProvider;
import com.sap.sse.datamining.ui.client.StringMessages;
import com.sap.sse.datamining.ui.client.WithControls;
import com.sap.sse.datamining.ui.client.developer.PredefinedQueryRunner;
import com.sap.sse.datamining.ui.client.developer.QueryDefinitionViewer;
import com.sap.sse.datamining.ui.client.selection.AbstractQueryDefinitionProvider;
import com.sap.sse.datamining.ui.client.selection.HierarchicalDimensionListFilterSelectionProvider;
import com.sap.sse.datamining.ui.client.selection.MultiDimensionalGroupingProvider;
import com.sap.sse.datamining.ui.client.selection.statistic.SuggestBoxStatisticProvider;
import com.sap.sse.datamining.ui.client.settings.AdvancedDataMiningSettings;
import com.sap.sse.datamining.ui.client.settings.AdvancedDataMiningSettingsDialogComponent;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class QueryDefinitionProviderWithControls
extends AbstractQueryDefinitionProvider<AdvancedDataMiningSettings>
implements WithControls {
    private static final double HeaderPanelHeight = 41.0;
    private static final double InitialQueryDefinitionViewerWidth = 600.0;
    private static final double InitialStatisticProviderWidth = 500.0;
    private static final double FooterPanelHeight = 60.0;
    private static final int SplitterSize = 10;
    private final Panel mainPanel;
    private final FlowPanel controlsPanel;
    private final DataMiningSettingsControl settingsControl;
    private final AdvancedDataMiningSettings settings;
    private final Button reloadComponentsButton;
    private final ToggleButton queryDefinitionViewerToggleButton;
    private final QueryDefinitionViewer queryDefinitionViewer;
    private final PredefinedQueryRunner predefinedQueryRunner;
    private final ProviderListener providerListener;
    private final Collection<DataMiningComponentProvider<?>> providers;
    private final StatisticProvider statisticProvider;
    private final GroupingProvider groupingProvider;
    private final SplitLayoutPanel filterSplitPanel;
    private final FilterSelectionProvider filterSelectionProvider;
    private final Panel applyQueryBusyIndicator;
    private boolean queryDefinitionChanged;
    private final ReportParameterToDimensionFilterBindings reportParameterBindings;
    private final ReportProvider reportProvider;

    public QueryDefinitionProviderWithControls(Component<?> parent, ComponentContext<?> context, DataMiningSession session, DataMiningServiceAsync dataMiningService, ReportProvider reportProvider, ErrorReporter errorReporter, DataMiningSettingsControl settingsControl, DataMiningSettingsInfoManager settingsManager, Consumer<Util.Pair<ModifiableStatisticQueryDefinitionDTO, ReportParameterToDimensionFilterBindings>> queryRunner) {
        super(parent, context, dataMiningService, errorReporter);
        this.reportProvider = reportProvider;
        this.reportParameterBindings = new ReportParameterToDimensionFilterBindings();
        this.providerListener = new ProviderListener();
        this.mainPanel = new LayoutPanel();
        this.controlsPanel = new FlowPanel();
        this.controlsPanel.addStyleName("dataMiningMarginBase");
        this.controlsPanel.getElement().getStyle().setOverflow(Style.Overflow.HIDDEN);
        this.controlsPanel.getElement().getStyle().setWhiteSpace(Style.WhiteSpace.NOWRAP);
        this.settingsControl = settingsControl;
        this.addControl(this.settingsControl.getEntryWidget());
        this.settings = new AdvancedDataMiningSettings();
        this.settingsControl.addSettingsComponent(this);
        this.queryDefinitionViewerToggleButton = new ToggleButton(this.getDataMiningStringMessages().viewQueryDefinition(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                boolean active = QueryDefinitionProviderWithControls.this.queryDefinitionViewerToggleButton.isDown();
                QueryDefinitionProviderWithControls.this.filterSplitPanel.setWidgetHidden(QueryDefinitionProviderWithControls.this.queryDefinitionViewer.getEntryWidget(), !active);
                QueryDefinitionProviderWithControls.this.queryDefinitionViewer.setActive(active);
            }
        });
        this.queryDefinitionViewer = new QueryDefinitionViewer(parent, context, this.getDataMiningStringMessages());
        this.queryDefinitionViewer.getEntryWidget().addStyleName("dataMiningMarginRight");
        this.queryDefinitionViewer.setActive(false);
        this.addQueryDefinitionChangedListener(this.queryDefinitionViewer);
        this.predefinedQueryRunner = new PredefinedQueryRunner(parent, context, this.getDataMiningStringMessages(), dataMiningService, errorReporter, this, queryRunner);
        this.reloadComponentsButton = new Button(this.getDataMiningStringMessages().reloadComponents());
        this.reloadComponentsButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                QueryDefinitionProviderWithControls.this.reloadComponents();
            }
        });
        if (this.settings.isDeveloperOptions()) {
            this.addControl((Widget)this.reloadComponentsButton);
            this.addControl((Widget)this.queryDefinitionViewerToggleButton);
            this.addControl(this.predefinedQueryRunner.getEntryWidget());
        }
        this.statisticProvider = new SuggestBoxStatisticProvider(parent, context, dataMiningService, errorReporter, settingsControl, settingsManager);
        Widget statisticProviderWidget = this.statisticProvider.getEntryWidget();
        statisticProviderWidget.addStyleName("dataMiningMarginBase");
        this.statisticProvider.addStatisticChangedListener(this.providerListener);
        this.groupingProvider = new MultiDimensionalGroupingProvider(parent, context, dataMiningService, errorReporter, this.statisticProvider);
        this.groupingProvider.addGroupingChangedListener(this.providerListener);
        this.groupingProvider.getEntryWidget().addStyleName("dataMiningMarginBase");
        this.filterSelectionProvider = new HierarchicalDimensionListFilterSelectionProvider(parent, context, session, dataMiningService, errorReporter, this.statisticProvider, reportProvider, this.reportParameterBindings);
        this.filterSelectionProvider.addSelectionChangedListener(this.providerListener);
        this.filterSelectionProvider.getEntryWidget().addStyleName("dataMiningBorderTop");
        this.filterSplitPanel = new SplitLayoutPanel(10);
        this.filterSplitPanel.addSouth(this.groupingProvider.getEntryWidget(), 60.0);
        this.filterSplitPanel.addEast(this.queryDefinitionViewer.getEntryWidget(), 600.0);
        this.filterSplitPanel.setWidgetHidden(this.queryDefinitionViewer.getEntryWidget(), true);
        this.filterSplitPanel.add(this.filterSelectionProvider.getEntryWidget());
        SimplePanel glass = new SimplePanel();
        glass.addStyleName("whiteGlass");
        HTML labeledBusyIndicator = new HTML(SafeHtmlUtils.fromString((String)this.getDataMiningStringMessages().applyingQuery()));
        labeledBusyIndicator.setStyleName("applyQueryBusyMessage");
        this.applyQueryBusyIndicator = new LayoutPanel();
        this.applyQueryBusyIndicator.add((Widget)glass);
        this.applyQueryBusyIndicator.add((Widget)labeledBusyIndicator);
        SplitLayoutPanel headerPanel = new SplitLayoutPanel(10);
        headerPanel.addWest(statisticProviderWidget, 500.0);
        headerPanel.add((Widget)this.controlsPanel);
        DockLayoutPanel contentPanel = new DockLayoutPanel(Style.Unit.PX);
        contentPanel.addNorth((Widget)headerPanel, 41.0);
        contentPanel.add((Widget)this.filterSplitPanel);
        this.mainPanel.add((Widget)contentPanel);
        this.providers = new ArrayList();
        this.providers.add(this.statisticProvider);
        this.providers.add(this.groupingProvider);
        this.providers.add(this.filterSelectionProvider);
        this.reloadComponents();
    }

    private DialogBox createConfirmChangeLossDialog(StatisticQueryDefinitionDTO queryDefinition) {
        StringMessages stringMessages = this.getDataMiningStringMessages();
        DialogBox dialog = new DialogBox(false, true);
        dialog.setAnimationEnabled(true);
        dialog.setText(stringMessages.changesWillBeLost());
        dialog.setGlassEnabled(true);
        VerticalPanel contentPanel = new VerticalPanel();
        contentPanel.setSpacing(5);
        contentPanel.add((Widget)new HTML(new SafeHtmlBuilder().appendEscapedLines(stringMessages.confirmQueryDefinitionChangeLoss()).toSafeHtml()));
        CheckBox rememberDecisionCheckBox = new CheckBox(stringMessages.rememberDecisionCanBeChangedInSettings());
        contentPanel.add((Widget)rememberDecisionCheckBox);
        FlowPanel buttonPanel = new FlowPanel();
        buttonPanel.addStyleName("floatRight");
        contentPanel.add((Widget)buttonPanel);
        Button discardChanges = new Button(stringMessages.discardChanges());
        discardChanges.addClickHandler(e -> {
            dialog.hide();
            this.setQueryDefinition(queryDefinition);
            if (rememberDecisionCheckBox.getValue().booleanValue()) {
                this.settings.setChangeLossStrategy(AdvancedDataMiningSettings.ChangeLossStrategy.DISCARD_CHANGES);
                rememberDecisionCheckBox.setValue(Boolean.valueOf(false));
            }
        });
        discardChanges.addStyleName("dataMiningMarginLeft");
        buttonPanel.add((Widget)discardChanges);
        Button keepChanges = new Button(stringMessages.keepChanges());
        keepChanges.addClickHandler(e -> {
            dialog.hide();
            if (rememberDecisionCheckBox.getValue().booleanValue()) {
                this.settings.setChangeLossStrategy(AdvancedDataMiningSettings.ChangeLossStrategy.KEEP_CHANGES);
                rememberDecisionCheckBox.setValue(Boolean.valueOf(false));
            }
        });
        keepChanges.addStyleName("dataMiningMarginLeft");
        buttonPanel.add((Widget)keepChanges);
        dialog.setWidget((Widget)contentPanel);
        return dialog;
    }

    public DataRetrieverChainDefinitionProvider getRetrieverChainProvider() {
        return this.statisticProvider;
    }

    public void drillDown(GroupKey groupKey, Runnable onSuccessCallback) {
        assert (groupKey instanceof GenericGroupKey);
        Serializable filterValue = (Serializable)((GenericGroupKey)groupKey).getValue();
        Collection<FunctionDTO> dimensionsToGroupBy = this.groupingProvider.getDimensionsToGroupBy();
        if (!dimensionsToGroupBy.isEmpty()) {
            FunctionDTO firstDimension = (FunctionDTO)Util.first(dimensionsToGroupBy);
            if (dimensionsToGroupBy.size() == 1) {
                this.showSelectNewFirstDimensionDialog(() -> this.filterSelectionProvider.setFilterSelectionForUnreducedDimension(firstDimension, filterValue, onSuccessCallback));
            } else {
                this.groupingProvider.removeDimensionToGroupBy(firstDimension);
                this.filterSelectionProvider.setFilterSelectionForUnreducedDimension(firstDimension, filterValue, onSuccessCallback);
            }
        }
    }

    private void showSelectNewFirstDimensionDialog(final Runnable onSuccessCallback) {
        FirstDimensionSelectionDialog dialog = new FirstDimensionSelectionDialog(new DataEntryDialog.DialogCallback<FunctionDTO>(){

            public void ok(FunctionDTO dimensionToGroupBy) {
                QueryDefinitionProviderWithControls.this.groupingProvider.setDimensionToGroupBy(0, dimensionToGroupBy);
                onSuccessCallback.run();
            }

            public void cancel() {
            }
        });
        dialog.show();
    }

    public boolean providersAwaitingReload() {
        for (DataMiningComponentProvider<?> provider : this.providers) {
            if (!provider.isAwaitingReload()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reloadComponents() {
        this.providers.forEach(provider -> provider.awaitReloadComponents());
        this.statisticProvider.reloadComponents();
    }

    public ModifiableStatisticQueryDefinitionDTO getQueryDefinition() {
        ModifiableStatisticQueryDefinitionDTO queryDTO = new ModifiableStatisticQueryDefinitionDTO(LocaleInfo.getCurrentLocale().getLocaleName(), this.statisticProvider.getExtractionFunction(), this.statisticProvider.getAggregatorDefinition(), this.statisticProvider.getDataRetrieverChainDefinition());
        for (FunctionDTO functionDTO : this.groupingProvider.getDimensionsToGroupBy()) {
            queryDTO.appendDimensionToGroupBy(functionDTO);
        }
        for (Map.Entry entry : this.statisticProvider.getRetrieverSettings().entrySet()) {
            queryDTO.setRetrieverSettings((DataRetrieverLevelDTO)entry.getKey(), (SerializableSettings)entry.getValue());
        }
        for (Map.Entry entry : this.filterSelectionProvider.getSelection().entrySet()) {
            queryDTO.setFilterSelectionFor((DataRetrieverLevelDTO)entry.getKey(), (HashMap)entry.getValue());
        }
        return queryDTO;
    }

    @Override
    public Util.Pair<ModifiableStatisticQueryDefinitionDTO, ReportParameterToDimensionFilterBindings> getQueryDefinitionAndReportParameterBinding() {
        return new Util.Pair((Object)this.getQueryDefinition(), (Object)new ReportParameterToDimensionFilterBindings(this.reportParameterBindings));
    }

    @Override
    public void applyQueryDefinition(StatisticQueryDefinitionDTO queryDefinition) {
        this.applyQueryDefinition(queryDefinition, this.settings.getChangeLossStrategy());
    }

    public void applyQueryDefinition(StatisticQueryDefinitionDTO queryDefinition, AdvancedDataMiningSettings.ChangeLossStrategy strategy) {
        if (this.queryDefinitionChanged) {
            switch (strategy) {
                case ASK: {
                    this.createConfirmChangeLossDialog(queryDefinition).center();
                    break;
                }
                case DISCARD_CHANGES: {
                    this.setQueryDefinition(queryDefinition);
                    break;
                }
            }
        } else {
            this.setQueryDefinition(queryDefinition);
        }
    }

    private void setQueryDefinition(StatisticQueryDefinitionDTO queryDefinition) {
        ReportParameterToDimensionFilterBindings parameterUsages = this.reportProvider.getCurrentReport().getReport().getParameterUsages(queryDefinition);
        this.reportParameterBindings.set(parameterUsages);
        if (parameterUsages == null) {
            GWT.log((String)"No parameter usages found for query");
        } else {
            GWT.log((String)("Found parameter usages " + parameterUsages + " for query"));
        }
        HashSet<ApplyCallback> callbacks = new HashSet<ApplyCallback>();
        ArrayList<String> errorMessages = new ArrayList<String>();
        String retrieverChainName = queryDefinition.getDataRetrieverChainDefinition().getName();
        this.setBlockChangeNotification(true);
        ApplyCallback statisticCallback = new ApplyCallback(errorMessages, callbacks, retrieverChainName);
        callbacks.add(statisticCallback);
        this.statisticProvider.applyQueryDefinition(queryDefinition, statisticCallback);
        if (!callbacks.isEmpty() || errorMessages.isEmpty()) {
            ApplyCallback groupingCallback = new ApplyCallback(errorMessages, callbacks, retrieverChainName);
            callbacks.add(groupingCallback);
            this.groupingProvider.applyQueryDefinition(queryDefinition, groupingCallback);
            ApplyCallback filterCallback = new ApplyCallback(errorMessages, callbacks, retrieverChainName);
            callbacks.add(filterCallback);
            this.filterSelectionProvider.applyQueryDefinition(queryDefinition, filterCallback);
        }
        if (!callbacks.isEmpty()) {
            for (ApplyCallback callback : callbacks) {
                callback.isArmed = true;
            }
            if (this.applyQueryBusyIndicator.getParent() == null) {
                this.mainPanel.add((Widget)this.applyQueryBusyIndicator);
            }
        } else {
            this.applyQueryDefinitionCompleted(errorMessages, retrieverChainName);
        }
    }

    private void applyQueryDefinitionCompleted(Collection<String> errorMessages, String retrieverChainName) {
        if (!errorMessages.isEmpty()) {
            this.showErrorWhileApplyingQueryDialog(errorMessages, retrieverChainName);
        }
        this.applyQueryBusyIndicator.removeFromParent();
        this.setBlockChangeNotification(false);
        this.queryDefinitionChanged = false;
        this.notifyQueryDefinitionChanged();
    }

    private void showErrorWhileApplyingQueryDialog(Iterable<String> errorMessages, String retrieverChainName) {
        StringMessages stringMessages = this.getDataMiningStringMessages();
        DialogBox dialog = new DialogBox(false, true);
        dialog.setText(stringMessages.anErrorOccurredWhileApplyingTheQuery());
        dialog.setAnimationEnabled(true);
        dialog.setGlassEnabled(true);
        VerticalPanel contentPanel = new VerticalPanel();
        contentPanel.add((Widget)new HTML(SafeHtmlUtils.fromString((String)stringMessages.queryBasedOnRetrieverChainCanNotBeApplied(retrieverChainName))));
        HtmlUListBuilder messagesBuilder = HtmlBuilderFactory.get().createUListBuilder();
        for (String errorMessage : errorMessages) {
            ((LIBuilder)messagesBuilder.startLI().text(errorMessage)).end();
        }
        contentPanel.add((Widget)new HTML(messagesBuilder.asSafeHtml()));
        FlowPanel buttonPanel = new FlowPanel();
        buttonPanel.addStyleName("floatRight");
        contentPanel.add((Widget)buttonPanel);
        Button okButton = new Button(stringMessages.ok());
        okButton.addClickHandler(e -> dialog.hide());
        buttonPanel.add((Widget)okButton);
        dialog.setWidget((Widget)contentPanel);
        dialog.center();
    }

    @Override
    public void queryDefinitionChangesHaveBeenStored() {
        this.queryDefinitionChanged = false;
    }

    @Override
    public void addControl(Widget controlWidget) {
        controlWidget.addStyleName("definitionProviderControlsElements");
        this.controlsPanel.add(controlWidget);
    }

    @Override
    public void removeControl(Widget controlWidget) {
        this.controlsPanel.remove(controlWidget);
    }

    public Widget getEntryWidget() {
        return this.mainPanel;
    }

    public String getLocalizedShortName() {
        return this.getDataMiningStringMessages().queryDefinitionProvider();
    }

    public boolean isVisible() {
        return this.mainPanel.isVisible();
    }

    public void setVisible(boolean visibility) {
        this.mainPanel.setVisible(visibility);
    }

    public boolean hasSettings() {
        return true;
    }

    public AdvancedDataMiningSettings getSettings() {
        return this.settings;
    }

    public SettingsDialogComponent<AdvancedDataMiningSettings> getSettingsDialogComponent(AdvancedDataMiningSettings settings) {
        return new AdvancedDataMiningSettingsDialogComponent(settings, this.getDataMiningStringMessages());
    }

    public void updateSettings(AdvancedDataMiningSettings newSettings) {
        if (this.settings.isDeveloperOptions() != newSettings.isDeveloperOptions()) {
            this.settings.setDeveloperOptions(newSettings.isDeveloperOptions());
            if (this.settings.isDeveloperOptions()) {
                this.addControl((Widget)this.reloadComponentsButton);
                this.addControl((Widget)this.queryDefinitionViewerToggleButton);
                boolean queryDefinitionViewerActive = this.queryDefinitionViewerToggleButton.isDown();
                this.filterSplitPanel.setWidgetHidden(this.queryDefinitionViewer.getEntryWidget(), !queryDefinitionViewerActive);
                this.queryDefinitionViewer.setActive(queryDefinitionViewerActive);
                this.addControl(this.predefinedQueryRunner.getEntryWidget());
            } else {
                this.removeControl((Widget)this.reloadComponentsButton);
                this.removeControl((Widget)this.queryDefinitionViewerToggleButton);
                this.filterSplitPanel.setWidgetHidden(this.queryDefinitionViewer.getEntryWidget(), true);
                this.queryDefinitionViewer.setActive(false);
                this.removeControl(this.predefinedQueryRunner.getEntryWidget());
            }
        }
        this.settings.setChangeLossStrategy(newSettings.getChangeLossStrategy());
    }

    public String getDependentCssClassName() {
        return "queryDefinitionProviderWithControls";
    }

    public String getId() {
        return "QueryDefinitionProviderWithControls";
    }

    private class ApplyCallback
    implements Consumer<Iterable<String>> {
        private final Collection<String> allMessages;
        private final Set<ApplyCallback> callbacks;
        private final String retrieverChainName;
        private boolean isArmed;

        public ApplyCallback(Collection<String> allMessages, Set<ApplyCallback> callbacks, String retrieverChainName) {
            this.allMessages = allMessages;
            this.callbacks = callbacks;
            this.retrieverChainName = retrieverChainName;
        }

        @Override
        public void accept(Iterable<String> messages) {
            Util.addAll(messages, this.allMessages);
            this.callbacks.remove(this);
            if (this.isArmed && this.callbacks.isEmpty()) {
                QueryDefinitionProviderWithControls.this.applyQueryDefinitionCompleted(this.allMessages, this.retrieverChainName);
            }
        }
    }

    private class FirstDimensionSelectionDialog
    extends DataEntryDialog<FunctionDTO> {
        private ValueListBox<FunctionDTO> dimensionChooser;

        public FirstDimensionSelectionDialog(DataEntryDialog.DialogCallback<FunctionDTO> callback) {
            super(QueryDefinitionProviderWithControls.this.getDataMiningStringMessages().chooseDifferentDimensionTitle(), QueryDefinitionProviderWithControls.this.getDataMiningStringMessages().chooseDifferentDimensionMessage(), QueryDefinitionProviderWithControls.this.getDataMiningStringMessages().ok(), QueryDefinitionProviderWithControls.this.getDataMiningStringMessages().cancel(), (DataEntryDialog.Validator)new DataEntryDialog.Validator<FunctionDTO>(){

                public String getErrorMessage(FunctionDTO valueToValidate) {
                    if (valueToValidate == null) {
                        return QueryDefinitionProviderWithControls.this.getDataMiningStringMessages().pleaseSelectADimension();
                    }
                    return null;
                }
            }, callback);
            this.dimensionChooser = QueryDefinitionProviderWithControls.this.groupingProvider.createDimensionToGroupByBoxWithoutEventHandler();
            ArrayList<Object> acceptableValues = new ArrayList<Object>();
            Util.addAll(QueryDefinitionProviderWithControls.this.groupingProvider.getAvailableDimensions(), acceptableValues);
            acceptableValues.add(null);
            this.dimensionChooser.setAcceptableValues(acceptableValues);
            this.dimensionChooser.addValueChangeHandler(e -> this.validateAndUpdate());
        }

        protected Widget getAdditionalWidget() {
            return this.dimensionChooser;
        }

        protected FunctionDTO getResult() {
            return (FunctionDTO)this.dimensionChooser.getValue();
        }
    }

    private class ProviderListener
    implements StatisticChangedListener,
    FilterSelectionChangedListener,
    GroupingChangedListener {
        private ProviderListener() {
        }

        @Override
        public void dataRetrieverChainDefinitionChanged(DataRetrieverChainDefinitionDTO newDataRetrieverChainDefinition) {
            if (QueryDefinitionProviderWithControls.this.providersAwaitingReload()) {
                QueryDefinitionProviderWithControls.this.groupingProvider.dataRetrieverChainDefinitionChanged(newDataRetrieverChainDefinition);
                QueryDefinitionProviderWithControls.this.groupingProvider.reloadComponents();
                QueryDefinitionProviderWithControls.this.filterSelectionProvider.dataRetrieverChainDefinitionChanged(newDataRetrieverChainDefinition);
                QueryDefinitionProviderWithControls.this.filterSelectionProvider.reloadComponents();
            } else {
                this.queryDefinitionChanged();
            }
        }

        @Override
        public void aggregatorDefinitionChanged(AggregationProcessorDefinitionDTO newAggregatorDefinition) {
            this.queryDefinitionChanged();
        }

        @Override
        public void extractionFunctionChanged(FunctionDTO extractionFunction) {
            this.queryDefinitionChanged();
        }

        @Override
        public void groupingChanged() {
            this.queryDefinitionChanged();
        }

        @Override
        public void selectionChanged() {
            this.queryDefinitionChanged();
        }

        private void queryDefinitionChanged() {
            if (!QueryDefinitionProviderWithControls.this.providersAwaitingReload()) {
                QueryDefinitionProviderWithControls.this.queryDefinitionChanged = true;
                QueryDefinitionProviderWithControls.this.notifyQueryDefinitionChanged();
            }
        }
    }
}

