/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.media;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.sap.sse.common.media.MimeType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbstractMediaDTO
implements IsSerializable,
Comparable<AbstractMediaDTO> {
    protected String title;
    protected String subtitle;
    protected Date createdAtDate;
    protected String copyright;
    protected MimeType mimeType;
    protected List<String> tags = new ArrayList<String>();
    protected String sourceRef;
    protected String locale;

    @Deprecated
    protected AbstractMediaDTO() {
    }

    public AbstractMediaDTO(String sourceRef, MimeType mimeType, Date createdAtDate) {
        this.sourceRef = sourceRef;
        this.mimeType = mimeType;
        this.createdAtDate = createdAtDate;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public Date getCreatedAtDate() {
        return this.createdAtDate;
    }

    public void setCreatedAtDate(Date createdAtDate) {
        this.createdAtDate = createdAtDate;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public boolean hasTag(String tagName) {
        return this.tags.contains(tagName);
    }

    public void setTags(Iterable<String> tags) {
        for (String tag : tags) {
            this.tags.add(tag);
        }
    }

    public String getSourceRef() {
        return this.sourceRef;
    }

    public void setSourceRef(String sourceRef) {
        this.sourceRef = sourceRef;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    protected int compareToByCreatedAtDate(AbstractMediaDTO o) {
        if (this.getCreatedAtDate() == o.getCreatedAtDate()) {
            return 0;
        }
        if (this.getCreatedAtDate() == null) {
            return 1;
        }
        if (o.getCreatedAtDate() == null) {
            return -1;
        }
        return -this.getCreatedAtDate().compareTo(o.getCreatedAtDate());
    }

    @Override
    public int compareTo(AbstractMediaDTO o) {
        return this.compareToByCreatedAtDate(o);
    }
}

