/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.impl.LockingAndBanning;

public class LockingAndBanningImpl
implements LockingAndBanning {
    private static final long serialVersionUID = 3547356744366236677L;
    public static final Duration DEFAULT_INITIAL_LOCKING_DELAY = Duration.ONE_SECOND;
    private TimePoint lockedUntil;
    private Duration nextLockingDelay;

    public LockingAndBanningImpl() {
        this(TimePoint.BeginningOfTime, DEFAULT_INITIAL_LOCKING_DELAY);
    }

    public LockingAndBanningImpl(TimePoint lockedUntil, Duration nextLockingDelay) {
        this.lockedUntil = lockedUntil;
        this.nextLockingDelay = nextLockingDelay;
    }

    @Override
    public void failedPasswordAuthentication() {
        this.lockedUntil = TimePoint.now().plus(this.nextLockingDelay);
        this.nextLockingDelay = this.nextLockingDelay.times(2L);
    }

    @Override
    public boolean successfulPasswordAuthentication() {
        Duration oldLockingDelay = this.nextLockingDelay;
        this.nextLockingDelay = DEFAULT_INITIAL_LOCKING_DELAY;
        TimePoint oldLockedUntil = this.lockedUntil;
        this.lockedUntil = TimePoint.BeginningOfTime;
        return !Util.equalsWithNull((Object)oldLockingDelay, (Object)this.nextLockingDelay) || !Util.equalsWithNull((Object)oldLockedUntil, (Object)this.lockedUntil);
    }

    @Override
    public boolean isAuthenticationLocked() {
        return TimePoint.now().before(this.lockedUntil);
    }

    @Override
    public TimePoint getLockedUntil() {
        return this.lockedUntil;
    }

    public Duration getNextLockingDelay() {
        return this.nextLockingDelay;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isAuthenticationLocked()) {
            result.append("locked until ");
            result.append(this.getLockedUntil());
        } else {
            result.append("unlocked");
        }
        result.append(", next locking duration: ");
        result.append(this.getNextLockingDelay());
        return result.toString();
    }
}

