/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication;

import com.sap.sse.ServerInfo;
import com.sap.sse.common.WithID;
import com.sap.sse.replication.OperationWithResult;
import java.io.Serializable;
import java.util.UUID;

public class OperationWithResultWithIdWrapper<S, R>
implements OperationWithResult<S, R>,
WithID {
    private static final long serialVersionUID = -5435955633510008283L;
    private final Serializable id;
    private final OperationWithResult<S, R> delegate;
    private final String originServerName;

    public OperationWithResultWithIdWrapper(OperationWithResult<S, R> delegate) {
        this(delegate, UUID.randomUUID());
    }

    protected OperationWithResultWithIdWrapper(OperationWithResult<S, R> delegate, Serializable id) {
        this.id = id;
        this.delegate = delegate;
        this.originServerName = delegate.getOriginServerName() == null ? ServerInfo.getName() : delegate.getOriginServerName();
    }

    @Override
    public Class<?> getClassForLogging() {
        return this.delegate.getClassForLogging();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperationWithResultWithIdWrapper other = (OperationWithResultWithIdWrapper)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public boolean isRequiresExplicitTransitiveReplication() {
        return this.delegate.isRequiresExplicitTransitiveReplication();
    }

    public boolean requiresSynchronousExecution() {
        return this.delegate.requiresSynchronousExecution();
    }

    @Override
    public S applyTo(S toState) {
        return this.delegate.applyTo(toState);
    }

    @Override
    public R internalApplyTo(S toState) throws Exception {
        return this.delegate.internalApplyTo(toState);
    }

    public Serializable getId() {
        return this.id;
    }

    @Override
    public String getOriginServerName() {
        return this.originServerName;
    }

    public String toString() {
        return this.delegate + " with ID " + this.getId() + (this.originServerName == null ? "" : " from server \"" + this.getOriginServerName() + "\"");
    }
}

