/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.model;

import com.sap.sailing.windestimation.model.ModelContext;
import com.sap.sailing.windestimation.model.ModelFactory;
import com.sap.sailing.windestimation.model.TrainableModel;
import com.sap.sailing.windestimation.model.exception.ModelLoadingException;
import com.sap.sailing.windestimation.model.exception.ModelNotFoundException;
import com.sap.sailing.windestimation.model.exception.ModelPersistenceException;
import com.sap.sailing.windestimation.model.store.ModelStore;
import com.sap.sailing.windestimation.model.store.PersistableModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModelLoader<InstanceType, MC extends ModelContext<InstanceType>, ModelType extends TrainableModel<InstanceType, MC>> {
    private final ModelStore modelStore;
    private final ModelFactory<InstanceType, MC, ModelType> modelFactory;
    private final ReadableModelCache<InstanceType, MC, ModelType> modelCache;

    public ModelLoader(ReadableModelCache<InstanceType, MC, ModelType> modelCache, ModelStore modelStore, ModelFactory<InstanceType, MC, ModelType> modelFactory) {
        this.modelCache = modelCache;
        this.modelStore = modelStore;
        this.modelFactory = modelFactory;
    }

    public ModelType loadBestModel(MC modelContextWithMaxFeatures) {
        return this.loadBestModel(modelContextWithMaxFeatures, this.modelCache);
    }

    protected ModelType loadBestModel(MC modelContextWithMaxFeatures, ReadableModelCache<InstanceType, MC, ModelType> modelCache) {
        List<MC> modelContextCandidates = this.modelFactory.getAllCompatibleModelContexts(modelContextWithMaxFeatures);
        ArrayList<ModelType> loadedModels = new ArrayList<ModelType>();
        for (ModelContext modelContext : modelContextCandidates) {
            ModelType loadedModel = this.loadModel(modelContext, modelCache);
            if (loadedModel == null || !loadedModel.isModelReady()) continue;
            loadedModels.add(loadedModel);
        }
        if (loadedModels.isEmpty()) {
            return null;
        }
        Iterator loadedModelsIterator = loadedModels.iterator();
        TrainableModel bestModel = (TrainableModel)loadedModelsIterator.next();
        while (loadedModelsIterator.hasNext()) {
            TrainableModel otherModel = (TrainableModel)loadedModelsIterator.next();
            if (!(bestModel.getTestScore() < otherModel.getTestScore())) continue;
            bestModel = otherModel;
        }
        return (ModelType)bestModel;
    }

    public ModelType loadModel(MC modelContext, ReadableModelCache<InstanceType, MC, ModelType> modelCache) {
        ModelType loadedModel;
        ModelType model = this.modelFactory.getNewModel(modelContext);
        ModelType ModelType = loadedModel = modelCache == null ? null : (ModelType)modelCache.getModelFromCache(modelContext);
        if (loadedModel == null && this.modelStore != null) {
            try {
                loadedModel = this.modelStore.loadModel(model);
            }
            catch (ModelNotFoundException modelNotFoundException) {
            }
            catch (ModelPersistenceException e) {
                throw new ModelLoadingException(e);
            }
        }
        return loadedModel;
    }

    public Map<MC, ModelType> loadBestModelsForAllContexts() {
        List<PersistableModel<?, ?>> loadedModels = this.modelStore.loadAllPersistedModels(this.modelFactory.getModelDomainType());
        HashMap modelsMap = new HashMap(loadedModels.size());
        for (PersistableModel<?, ?> model : loadedModels) {
            modelsMap.put(model.getModelContext(), (TrainableModel)model);
        }
        ReadableModelCache modelCache = modelContext -> (TrainableModel)modelsMap.get(modelContext);
        HashMap<ModelContext, TrainableModel> result = new HashMap<ModelContext, TrainableModel>(modelsMap.size());
        for (ModelContext modelContext2 : modelsMap.keySet()) {
            TrainableModel bestModel = this.loadBestModel(modelContext2, modelCache);
            result.put(modelContext2, bestModel);
        }
        return result;
    }

    public static interface ReadableModelCache<InstanceType, MC extends ModelContext<InstanceType>, ModelType extends TrainableModel<InstanceType, MC>> {
        public ModelType getModelFromCache(MC var1);
    }
}

