/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.windestimation.aggregator.msthmm;

import com.sap.sailing.windestimation.aggregator.hmm.AbstractBestPathsPerLevel;
import com.sap.sailing.windestimation.aggregator.hmm.BestNodeInfo;
import com.sap.sailing.windestimation.aggregator.hmm.GraphNode;
import com.sap.sailing.windestimation.aggregator.hmm.IntersectedWindRange;
import com.sap.sailing.windestimation.aggregator.msthmm.MstBestManeuverNodeInfo;
import com.sap.sailing.windestimation.aggregator.msthmm.MstGraphLevel;
import com.sap.sailing.windestimation.data.ManeuverTypeForClassification;
import com.sap.sse.common.Util;
import java.util.List;

public class MstBestPathsPerLevel
extends AbstractBestPathsPerLevel<MstGraphLevel> {
    private final MstBestManeuverNodeInfo[] bestPreviousNodeInfosPerManeuverNode;
    private final MstGraphLevel currentLevel;

    public MstBestPathsPerLevel(MstGraphLevel currentLevel) {
        this.currentLevel = currentLevel;
        this.bestPreviousNodeInfosPerManeuverNode = new MstBestManeuverNodeInfo[currentLevel.getLevelNodes().size()];
    }

    public MstBestManeuverNodeInfo getBestPreviousNodeInfo(GraphNode<MstGraphLevel> currentNode) {
        return this.bestPreviousNodeInfosPerManeuverNode[currentNode.getIndexInLevel()];
    }

    public MstBestManeuverNodeInfo addBestPreviousNodeInfo(GraphNode<MstGraphLevel> currentNode, List<Util.Pair<MstGraphLevel, GraphNode<MstGraphLevel>>> previousGraphLevelsWithBestPreviousNodes, double probabilityFromStart, IntersectedWindRange intersectedWindRange) {
        MstBestManeuverNodeInfo bestManeuverNodeInfo;
        this.bestPreviousNodeInfosPerManeuverNode[currentNode.getIndexInLevel()] = bestManeuverNodeInfo = new MstBestManeuverNodeInfo(previousGraphLevelsWithBestPreviousNodes, probabilityFromStart, intersectedWindRange);
        return bestManeuverNodeInfo;
    }

    @Override
    public MstGraphLevel getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    protected BestNodeInfo[] getPreviousNodeInfosPerManeuverNode() {
        return this.bestPreviousNodeInfosPerManeuverNode;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        ManeuverTypeForClassification[] maneuverTypeForClassificationArray = ManeuverTypeForClassification.values();
        int n = maneuverTypeForClassificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ManeuverTypeForClassification maneuverType = maneuverTypeForClassificationArray[n2];
            result.append((Object)maneuverType);
            result.append(": ");
            result.append(this.getPreviousNodeInfosPerManeuverNode()[maneuverType.ordinal()]);
            result.append(", ");
            ++n2;
        }
        return result.substring(0, result.length() - 2);
    }
}

