/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.Venue;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class VenueJsonSerializer
implements JsonSerializer<Venue> {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_COURSE_AREAS = "courseAreas";
    private final JsonSerializer<CourseArea> areaSerializer;

    public VenueJsonSerializer(JsonSerializer<CourseArea> areaSerializer) {
        this.areaSerializer = areaSerializer;
    }

    public JSONObject serialize(Venue venue) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_NAME, (Object)venue.getName());
        JSONArray areas = new JSONArray();
        for (CourseArea area : venue.getCourseAreas()) {
            areas.add((Object)this.areaSerializer.serialize((Object)area));
        }
        result.put((Object)FIELD_COURSE_AREAS, (Object)areas);
        return result;
    }
}

