/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.statistics.Statistics;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorJsonSerializer;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.shared.json.JsonSerializer;
import org.json.simple.JSONObject;

public class StatisticsJsonSerializer
implements JsonSerializer<Statistics> {
    public static final String FIELD_NUMBER_OF_COMPETITORS = "numberOfCompetitors";
    public static final String FIELD_NUMBER_OF_REGATTAS = "numberOfRegattas";
    public static final String FIELD_NUMBER_OF_RACES = "numberOfRaces";
    public static final String FIELD_NUMBER_OF_TRACKED_RACES = "numberOfTrackedRaces";
    public static final String FIELD_NUMBER_OF_GPS_FIXES = "numberOfGPSFixes";
    public static final String FIELD_NUMBER_OF_WIND_FIXES = "numberOfWindFixes";
    public static final String FIELD_DISTANCE_TRAVELED_IN_METERS = "distanceTraveledInMeters";
    public static final String FIELD_MAX_SPEED = "maxSpeed";
    public static final String FIELD_FASTEST_COMPETITOR = "fastestCompetitor";
    public static final String FIELD_FASTEST_COMPETITOR_SPEED_IN_KNOTS = "fastestCompetitorSpeedInKnots";
    public static final String FIELD_TIMEPOINT_MILLIS = "timepointMillis";
    private final CompetitorJsonSerializer competitorJsonSerializer = CompetitorJsonSerializer.create();

    public JSONObject serialize(Statistics object) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_NUMBER_OF_COMPETITORS, (Object)object.getNumberOfCompetitors());
        result.put((Object)FIELD_NUMBER_OF_REGATTAS, (Object)object.getNumberOfRegattas());
        result.put((Object)FIELD_NUMBER_OF_RACES, (Object)object.getNumberOfRaces());
        result.put((Object)FIELD_NUMBER_OF_TRACKED_RACES, (Object)object.getNumberOfTrackedRaces());
        result.put((Object)FIELD_NUMBER_OF_GPS_FIXES, (Object)object.getNumberOfGPSFixes());
        result.put((Object)FIELD_NUMBER_OF_WIND_FIXES, (Object)object.getNumberOfWindFixes());
        result.put((Object)FIELD_DISTANCE_TRAVELED_IN_METERS, (Object)object.getDistanceTraveled().getMeters());
        Util.Triple maxSpeed = object.getMaxSpeed();
        if (maxSpeed != null) {
            JSONObject maxSpeedObject = new JSONObject();
            maxSpeedObject.put((Object)FIELD_FASTEST_COMPETITOR, (Object)this.competitorJsonSerializer.serialize((Competitor)maxSpeed.getA()));
            maxSpeedObject.put((Object)FIELD_FASTEST_COMPETITOR_SPEED_IN_KNOTS, (Object)((Speed)maxSpeed.getB()).getKnots());
            maxSpeedObject.put((Object)FIELD_TIMEPOINT_MILLIS, (Object)((TimePoint)maxSpeed.getC()).asMillis());
            result.put((Object)FIELD_MAX_SPEED, (Object)maxSpeedObject);
        }
        return result;
    }
}

