/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.DeviceIdentifierJsonHandler;
import com.sap.sailing.server.gateway.serialization.racelog.tracking.impl.PlaceHolderDeviceIdentifierJsonHandler;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.SingleTypeBasedServiceFinderImpl;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;

public class DeviceIdentifierJsonSerializer
implements JsonSerializer<DeviceIdentifier> {
    private static final Logger logger = Logger.getLogger(DeviceIdentifierJsonSerializer.class.getName());
    private final TypeBasedServiceFinder<DeviceIdentifierJsonHandler> serviceFinder;

    public static DeviceIdentifierJsonSerializer create(DeviceIdentifierJsonHandler singleHandler, String type) {
        return new DeviceIdentifierJsonSerializer((TypeBasedServiceFinder<DeviceIdentifierJsonHandler>)new SingleTypeBasedServiceFinderImpl((Object)singleHandler, (Object)new PlaceHolderDeviceIdentifierJsonHandler(), type));
    }

    public DeviceIdentifierJsonSerializer(TypeBasedServiceFinder<DeviceIdentifierJsonHandler> serviceFinder) {
        this.serviceFinder = serviceFinder;
    }

    public JSONObject serialize(DeviceIdentifier object) {
        JSONObject result;
        if (object == null) {
            result = null;
        } else {
            result = new JSONObject();
            DeviceIdentifierJsonHandler handler = (DeviceIdentifierJsonHandler)this.serviceFinder.findService(object.getIdentifierType());
            try {
                Util.Pair pair = handler.serialize(object);
                result.put((Object)"type", pair.getA());
                result.put((Object)"id", pair.getB());
                result.put((Object)"stringRepresentation", (Object)object.getStringRepresentation());
                return result;
            }
            catch (TransformationException e) {
                logger.log(Level.WARNING, "Could not serialize device identifier, consider adding a fallback serialization handler", e);
                result = null;
            }
        }
        return result;
    }
}

