/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.dto;

import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.LegEntryDTO;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import java.io.Serializable;
import java.util.List;

public class LeaderboardEntryDTO
implements Serializable {
    private static final long serialVersionUID = -4678693781217869837L;
    public RaceIdentifier race;
    public BoatDTO boat;
    public MaxPointsReason reasonForMaxPoints;
    public Double totalPoints;
    public Double totalPointsUncorrected;
    public Double incrementalScoreCorrectionInPoints;
    public boolean totalPointsCorrected;
    public Double netPoints;
    public boolean discarded;
    public Double windwardDistanceToCompetitorFarthestAheadInMeters;
    public Double averageAbsoluteCrossTrackErrorInMeters;
    public Double averageSignedCrossTrackErrorInMeters;
    public Double distanceToStartLineFiveSecondsBeforeStartInMeters;
    public Double speedOverGroundFiveSecondsBeforeStartInKnots;
    public Double distanceToStartLineAtStartOfRaceInMeters;
    public Double speedOverGroundAtStartOfRaceInKnots;
    public Double speedOverGroundAtPassingStartWaypointInKnots;
    public Double timeBetweenRaceStartAndCompetitorStartInSeconds;
    public Double distanceToStarboardSideOfStartLineInMeters;
    public Tack startTack;
    public Double timeSinceLastPositionFixInSeconds;
    public Duration averageSamplingInterval;
    public Double averageRideHeightInMeters;
    public Duration gapToLeaderInOwnTime;
    public Duration timeSailedSinceRaceStart;
    public Duration calculatedTime;
    public Speed impliedWind;
    public Duration calculatedTimeAtEstimatedArrivalAtCompetitorFarthestAhead;
    public SpeedWithBearing currentSpeedAndCourseOverGround;
    public List<LegEntryDTO> legDetails;
    public FleetDTO fleet;
    public ExpeditionDataHolder expeditionDataHolder;
    public Bearing heel;
    public Bearing pitch;
    public Double percentTargetBoatSpeed;

    public boolean hasScoreCorrection() {
        return this.totalPointsCorrected || this.reasonForMaxPoints != null && this.reasonForMaxPoints != MaxPointsReason.NONE;
    }

    public Duration getTimeSailed() {
        MillisecondsDurationImpl result;
        if (this.legDetails != null) {
            long timeInMilliseconds = 0L;
            for (LegEntryDTO legDetail : this.legDetails) {
                if (legDetail == null) continue;
                if (legDetail.distanceTraveledInMeters != null && legDetail.timeInMilliseconds != null) {
                    timeInMilliseconds += legDetail.timeInMilliseconds.longValue();
                    continue;
                }
                timeInMilliseconds = 0L;
                break;
            }
            result = new MillisecondsDurationImpl(timeInMilliseconds);
        } else {
            result = null;
        }
        return result;
    }

    public Distance getDistanceTraveled() {
        Distance.NullDistance result = null;
        if (this.legDetails != null) {
            for (LegEntryDTO legDetail : this.legDetails) {
                if (legDetail == null || legDetail.distanceTraveledInMeters == null) continue;
                if (result == null) {
                    result = Distance.NULL;
                }
                result = result.add((Distance)new MeterDistance(legDetail.distanceTraveledInMeters));
            }
        }
        return result;
    }

    public Duration getDurationFoiled() {
        MillisecondsDurationImpl result;
        if (this.legDetails != null) {
            Double acc = null;
            for (LegEntryDTO legDetail : this.legDetails) {
                if (legDetail == null) continue;
                if (legDetail.currentDurationFoiledInSeconds != null) {
                    if (acc == null) {
                        acc = 0.0;
                    }
                    acc = acc + legDetail.currentDurationFoiledInSeconds;
                    continue;
                }
                acc = null;
                break;
            }
            result = acc == null ? null : new MillisecondsDurationImpl((long)(acc * 1000.0));
        } else {
            result = null;
        }
        return result;
    }

    public Distance getDistanceFoiled() {
        Distance.NullDistance result = null;
        if (this.legDetails != null) {
            for (LegEntryDTO legDetail : this.legDetails) {
                if (legDetail == null || legDetail.currentDistanceFoiledInMeters == null) continue;
                if (result == null) {
                    result = Distance.NULL;
                }
                result = result.add((Distance)new MeterDistance(legDetail.currentDistanceFoiledInMeters));
            }
        }
        return result;
    }

    public int getOneBasedCurrentLegNumber() {
        int result = 0;
        if (this.legDetails != null && !this.legDetails.isEmpty()) {
            for (LegEntryDTO legDetail : this.legDetails) {
                if (legDetail == null || !legDetail.started) break;
                ++result;
            }
        }
        return result;
    }

    private void ensureExpeditionHolder() {
        if (this.expeditionDataHolder == null) {
            this.expeditionDataHolder = new ExpeditionDataHolder();
        }
    }

    public void setExpeditionAWA(Double expeditionAWA) {
        if (expeditionAWA != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionAWA = expeditionAWA;
        }
    }

    public void setExpeditionAWS(Double expeditionAWS) {
        if (expeditionAWS != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionAWS = expeditionAWS;
        }
    }

    public void setExpeditionTWA(Double expeditionTWA) {
        if (expeditionTWA != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionTWA = expeditionTWA;
        }
    }

    public void setExpeditionTWS(Double expeditionTWS) {
        if (expeditionTWS != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionTWS = expeditionTWS;
        }
    }

    public void setExpeditionTWD(Double expeditionTWD) {
        if (expeditionTWD != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionTWD = expeditionTWD;
        }
    }

    public void setExpeditionBoatSpeed(Double expeditionBSP) {
        if (expeditionBSP != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionBoatSpeed = expeditionBSP;
        }
    }

    public void setExpeditionTargBoatSpeed(Double expeditionBSP_TR) {
        if (expeditionBSP_TR != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionTargBoatSpeed = expeditionBSP_TR;
        }
    }

    public void setExpeditionSOG(Double expeditionSOG) {
        if (expeditionSOG != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionSOG = expeditionSOG;
        }
    }

    public void setExpeditionCOG(Double expeditionCOG) {
        if (expeditionCOG != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionCOG = expeditionCOG;
        }
    }

    public void setExpeditionForestayLoad(Double expeditionForestayLoad) {
        if (expeditionForestayLoad != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionForestayLoad = expeditionForestayLoad;
        }
    }

    public void setExpeditionRake(Double expeditionRake) {
        if (expeditionRake != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionRake = expeditionRake;
        }
    }

    public void setExpeditionHeading(Double expeditionHDG) {
        if (expeditionHDG != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionHeading = expeditionHDG;
        }
    }

    public void setExpeditionHeel(Double expeditionHeel) {
        if (expeditionHeel != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionHeel = expeditionHeel;
        }
    }

    public void setExpeditionTargetHeel(Double expeditionTG_Heell) {
        if (expeditionTG_Heell != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionTargetHeel = expeditionTG_Heell;
        }
    }

    public void setExpeditionTimeToGunInSeconds(Double expeditionTmToGunInSeconds) {
        if (expeditionTmToGunInSeconds != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionTimeToGunInSeconds = expeditionTmToGunInSeconds;
        }
    }

    public void setExpeditionTimeToBurnToLineInSeconds(Double expeditionTmToBurnInSeconds) {
        if (expeditionTmToBurnInSeconds != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionTimeToBurnToLineInSeconds = expeditionTmToBurnInSeconds;
        }
    }

    public void setExpeditionDistanceBelowLineInMeters(Double expeditionBelowLnInMeters) {
        if (expeditionBelowLnInMeters != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionDistanceBelowLine = expeditionBelowLnInMeters;
        }
    }

    public void setExpeditionCourseDetail(Double expeditionCourse) {
        if (expeditionCourse != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionCourseDetail = expeditionCourse;
        }
    }

    public void setExpeditionBaro(Double expeditionBARO) {
        if (expeditionBARO != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionBARO = expeditionBARO;
        }
    }

    public void setExpeditionLoadP(Double expeditionLoadP) {
        if (expeditionLoadP != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionLoadP = expeditionLoadP;
        }
    }

    public void setExpeditionLoadS(Double expeditionLoadS) {
        if (expeditionLoadS != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionLoadS = expeditionLoadS;
        }
    }

    public void setExpeditionJibCarPort(Double expeditionJibCarPort) {
        if (expeditionJibCarPort != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionJibCarPort = expeditionJibCarPort;
        }
    }

    public void setExpeditionJibCarStbd(Double expeditionJibCarStbd) {
        if (expeditionJibCarStbd != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionJibCarStbd = expeditionJibCarStbd;
        }
    }

    public void setExpeditionMastButt(Double expeditionMastButt) {
        if (expeditionMastButt != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionMastButt = expeditionMastButt;
        }
    }

    public void setExpeditionRateOfTurn(Double expeditionRateOfTurn) {
        if (expeditionRateOfTurn != null) {
            this.ensureExpeditionHolder();
            this.expeditionDataHolder.expeditionRateOfTurn = expeditionRateOfTurn;
        }
    }

    public Double getExpeditionAWA() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionAWA;
    }

    public Double getExpeditionAWS() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionAWS;
    }

    public Double getExpeditionBoatSpeed() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionBoatSpeed;
    }

    public Double getExpeditionCOG() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionCOG;
    }

    public Double getExpeditionDistanceBelowLine() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionDistanceBelowLine;
    }

    public Double getExpeditionDistanceToCommitteeBoat() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionDistanceToCommitteeBoat;
    }

    public Double getExpeditionDistToPortLayline() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionDistToPortLayline;
    }

    public Double getExpeditionDistToStbLayline() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionDistToStbLayline;
    }

    public Double getExpeditionVMG() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionVMG;
    }

    public Double getExpeditionTWS() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionTWS;
    }

    public Double getExpeditionTWD() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionTWD;
    }

    public Double getExpeditionTWA() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionTWA;
    }

    public Double getExpeditionTimeToStbLayline() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionTimeToStbLayline;
    }

    public Double getExpeditionTimeToPortLayline() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionTimeToPortLayline;
    }

    public Double getExpeditionTimeToPin() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionTimeToPin;
    }

    public Double getExpeditionTimeToGun() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionTimeToGunInSeconds;
    }

    public Double getExpeditionTimeToCommitteeBoat() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionTimeToCommitteeBoat;
    }

    public Double getExpeditionTimeToBurnToPin() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionTimeToBurnToPin;
    }

    public Double getExpeditionTargTWA() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionTargTWA;
    }

    public Double getExpeditionTimeToBurnToCommitteeBoat() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionTimeToBurnToCommitteeBoat;
    }

    public Double getExpeditionTimeToBurnToLine() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionTimeToBurnToLineInSeconds;
    }

    public Double getExpeditionTargetHeel() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionTargetHeel;
    }

    public Double getExpeditionTargBoatSpeed() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionTargBoatSpeed;
    }

    public Double getExpeditionSOG() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionSOG;
    }

    public Double getExpeditionRudderAngle() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionRudderAngle;
    }

    public Double getExpeditionRateOfTurn() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionRateOfTurn;
    }

    public Double getExpeditionRake() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionRake;
    }

    public Double getExpeditionLineSquareForWindDirection() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionLineSquareForWindDirection;
    }

    public Double getExpeditionHeading() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionHeading;
    }

    public Double getExpeditionForestayLoad() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionForestayLoad;
    }

    public Double getExpeditionHeel() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionHeel;
    }

    public Double getExpeditionCourseDetail() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionCourseDetail;
    }

    public Double getExpeditionDistanceToPinDetail() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionDistanceToPinDetail;
    }

    public Double getExpeditionVMGTargVMGDelta() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionVMGTargVMGDelta;
    }

    public Double getExpeditionBaro() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionBARO;
    }

    public Double getExpeditionLoadP() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionLoadP;
    }

    public Double getExpeditionLoadS() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionLoadS;
    }

    public Double getExpeditionJibCarPort() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionJibCarPort;
    }

    public Double getExpeditionJibCarStbd() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionJibCarStbd;
    }

    public Double getExpeditionMastButt() {
        return this.expeditionDataHolder == null ? null : this.expeditionDataHolder.expeditionMastButt;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.averageAbsoluteCrossTrackErrorInMeters == null ? 0 : this.averageAbsoluteCrossTrackErrorInMeters.hashCode());
        result = 31 * result + (this.averageRideHeightInMeters == null ? 0 : this.averageRideHeightInMeters.hashCode());
        result = 31 * result + (this.averageSamplingInterval == null ? 0 : this.averageSamplingInterval.hashCode());
        result = 31 * result + (this.averageSignedCrossTrackErrorInMeters == null ? 0 : this.averageSignedCrossTrackErrorInMeters.hashCode());
        result = 31 * result + (this.boat == null ? 0 : this.boat.hashCode());
        result = 31 * result + (this.timeSailedSinceRaceStart == null ? 0 : this.timeSailedSinceRaceStart.hashCode());
        result = 31 * result + (this.calculatedTime == null ? 0 : this.calculatedTime.hashCode());
        result = 31 * result + (this.calculatedTimeAtEstimatedArrivalAtCompetitorFarthestAhead == null ? 0 : this.calculatedTimeAtEstimatedArrivalAtCompetitorFarthestAhead.hashCode());
        result = 31 * result + (this.currentSpeedAndCourseOverGround == null ? 0 : this.currentSpeedAndCourseOverGround.hashCode());
        result = 31 * result + (this.discarded ? 1231 : 1237);
        result = 31 * result + (this.distanceToStarboardSideOfStartLineInMeters == null ? 0 : this.distanceToStarboardSideOfStartLineInMeters.hashCode());
        result = 31 * result + (this.distanceToStartLineAtStartOfRaceInMeters == null ? 0 : this.distanceToStartLineAtStartOfRaceInMeters.hashCode());
        result = 31 * result + (this.distanceToStartLineFiveSecondsBeforeStartInMeters == null ? 0 : this.distanceToStartLineFiveSecondsBeforeStartInMeters.hashCode());
        result = 31 * result + (this.expeditionDataHolder == null ? 0 : this.expeditionDataHolder.hashCode());
        result = 31 * result + (this.fleet == null ? 0 : this.fleet.hashCode());
        result = 31 * result + (this.gapToLeaderInOwnTime == null ? 0 : this.gapToLeaderInOwnTime.hashCode());
        result = 31 * result + (this.heel == null ? 0 : this.heel.hashCode());
        result = 31 * result + (this.legDetails == null ? 0 : this.legDetails.hashCode());
        result = 31 * result + (this.netPoints == null ? 0 : this.netPoints.hashCode());
        result = 31 * result + (this.pitch == null ? 0 : this.pitch.hashCode());
        result = 31 * result + (this.percentTargetBoatSpeed == null ? 0 : this.percentTargetBoatSpeed.hashCode());
        result = 31 * result + (this.race == null ? 0 : this.race.hashCode());
        result = 31 * result + (this.reasonForMaxPoints == null ? 0 : this.reasonForMaxPoints.hashCode());
        result = 31 * result + (this.speedOverGroundAtPassingStartWaypointInKnots == null ? 0 : this.speedOverGroundAtPassingStartWaypointInKnots.hashCode());
        result = 31 * result + (this.speedOverGroundAtStartOfRaceInKnots == null ? 0 : this.speedOverGroundAtStartOfRaceInKnots.hashCode());
        result = 31 * result + (this.speedOverGroundFiveSecondsBeforeStartInKnots == null ? 0 : this.speedOverGroundFiveSecondsBeforeStartInKnots.hashCode());
        result = 31 * result + (this.startTack == null ? 0 : this.startTack.hashCode());
        result = 31 * result + (this.timeBetweenRaceStartAndCompetitorStartInSeconds == null ? 0 : this.timeBetweenRaceStartAndCompetitorStartInSeconds.hashCode());
        result = 31 * result + (this.timeSinceLastPositionFixInSeconds == null ? 0 : this.timeSinceLastPositionFixInSeconds.hashCode());
        result = 31 * result + (this.totalPoints == null ? 0 : this.totalPoints.hashCode());
        result = 31 * result + (this.totalPointsCorrected ? 1231 : 1237);
        result = 31 * result + (this.totalPointsUncorrected == null ? 0 : this.totalPointsUncorrected.hashCode());
        result = 31 * result + (this.incrementalScoreCorrectionInPoints == null ? 0 : this.incrementalScoreCorrectionInPoints.hashCode());
        result = 31 * result + (this.windwardDistanceToCompetitorFarthestAheadInMeters == null ? 0 : this.windwardDistanceToCompetitorFarthestAheadInMeters.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeaderboardEntryDTO other = (LeaderboardEntryDTO)obj;
        if (this.averageAbsoluteCrossTrackErrorInMeters == null ? other.averageAbsoluteCrossTrackErrorInMeters != null : !this.averageAbsoluteCrossTrackErrorInMeters.equals(other.averageAbsoluteCrossTrackErrorInMeters)) {
            return false;
        }
        if (this.averageRideHeightInMeters == null ? other.averageRideHeightInMeters != null : !this.averageRideHeightInMeters.equals(other.averageRideHeightInMeters)) {
            return false;
        }
        if (this.averageSamplingInterval == null ? other.averageSamplingInterval != null : !this.averageSamplingInterval.equals(other.averageSamplingInterval)) {
            return false;
        }
        if (this.averageSignedCrossTrackErrorInMeters == null ? other.averageSignedCrossTrackErrorInMeters != null : !this.averageSignedCrossTrackErrorInMeters.equals(other.averageSignedCrossTrackErrorInMeters)) {
            return false;
        }
        if (this.boat == null ? other.boat != null : !this.boat.equals(other.boat)) {
            return false;
        }
        if (this.timeSailedSinceRaceStart == null ? other.timeSailedSinceRaceStart != null : !this.timeSailedSinceRaceStart.equals(other.timeSailedSinceRaceStart)) {
            return false;
        }
        if (this.calculatedTime == null ? other.calculatedTime != null : !this.calculatedTime.equals(other.calculatedTime)) {
            return false;
        }
        if (this.calculatedTimeAtEstimatedArrivalAtCompetitorFarthestAhead == null ? other.calculatedTimeAtEstimatedArrivalAtCompetitorFarthestAhead != null : !this.calculatedTimeAtEstimatedArrivalAtCompetitorFarthestAhead.equals(other.calculatedTimeAtEstimatedArrivalAtCompetitorFarthestAhead)) {
            return false;
        }
        if (this.currentSpeedAndCourseOverGround == null ? other.currentSpeedAndCourseOverGround != null : !this.currentSpeedAndCourseOverGround.equals(other.currentSpeedAndCourseOverGround)) {
            return false;
        }
        if (this.discarded != other.discarded) {
            return false;
        }
        if (this.distanceToStarboardSideOfStartLineInMeters == null ? other.distanceToStarboardSideOfStartLineInMeters != null : !this.distanceToStarboardSideOfStartLineInMeters.equals(other.distanceToStarboardSideOfStartLineInMeters)) {
            return false;
        }
        if (this.distanceToStartLineAtStartOfRaceInMeters == null ? other.distanceToStartLineAtStartOfRaceInMeters != null : !this.distanceToStartLineAtStartOfRaceInMeters.equals(other.distanceToStartLineAtStartOfRaceInMeters)) {
            return false;
        }
        if (this.distanceToStartLineFiveSecondsBeforeStartInMeters == null ? other.distanceToStartLineFiveSecondsBeforeStartInMeters != null : !this.distanceToStartLineFiveSecondsBeforeStartInMeters.equals(other.distanceToStartLineFiveSecondsBeforeStartInMeters)) {
            return false;
        }
        if (this.expeditionDataHolder == null ? other.expeditionDataHolder != null : !this.expeditionDataHolder.equals(other.expeditionDataHolder)) {
            return false;
        }
        if (this.fleet == null ? other.fleet != null : !this.fleet.equals((Object)other.fleet)) {
            return false;
        }
        if (this.gapToLeaderInOwnTime == null ? other.gapToLeaderInOwnTime != null : !this.gapToLeaderInOwnTime.equals(other.gapToLeaderInOwnTime)) {
            return false;
        }
        if (this.heel == null ? other.heel != null : !this.heel.equals(other.heel)) {
            return false;
        }
        if (this.legDetails == null ? other.legDetails != null : !this.legDetails.equals(other.legDetails)) {
            return false;
        }
        if (this.netPoints == null ? other.netPoints != null : !this.netPoints.equals(other.netPoints)) {
            return false;
        }
        if (this.pitch == null ? other.pitch != null : !this.pitch.equals(other.pitch)) {
            return false;
        }
        if (this.percentTargetBoatSpeed == null ? other.percentTargetBoatSpeed != null : !this.percentTargetBoatSpeed.equals(other.percentTargetBoatSpeed)) {
            return false;
        }
        if (this.race == null ? other.race != null : !this.race.equals(other.race)) {
            return false;
        }
        if (this.reasonForMaxPoints != other.reasonForMaxPoints) {
            return false;
        }
        if (this.speedOverGroundAtPassingStartWaypointInKnots == null ? other.speedOverGroundAtPassingStartWaypointInKnots != null : !this.speedOverGroundAtPassingStartWaypointInKnots.equals(other.speedOverGroundAtPassingStartWaypointInKnots)) {
            return false;
        }
        if (this.speedOverGroundAtStartOfRaceInKnots == null ? other.speedOverGroundAtStartOfRaceInKnots != null : !this.speedOverGroundAtStartOfRaceInKnots.equals(other.speedOverGroundAtStartOfRaceInKnots)) {
            return false;
        }
        if (this.speedOverGroundFiveSecondsBeforeStartInKnots == null ? other.speedOverGroundFiveSecondsBeforeStartInKnots != null : !this.speedOverGroundFiveSecondsBeforeStartInKnots.equals(other.speedOverGroundFiveSecondsBeforeStartInKnots)) {
            return false;
        }
        if (this.startTack != other.startTack) {
            return false;
        }
        if (this.timeBetweenRaceStartAndCompetitorStartInSeconds == null ? other.timeBetweenRaceStartAndCompetitorStartInSeconds != null : !this.timeBetweenRaceStartAndCompetitorStartInSeconds.equals(other.timeBetweenRaceStartAndCompetitorStartInSeconds)) {
            return false;
        }
        if (this.timeSinceLastPositionFixInSeconds == null ? other.timeSinceLastPositionFixInSeconds != null : !this.timeSinceLastPositionFixInSeconds.equals(other.timeSinceLastPositionFixInSeconds)) {
            return false;
        }
        if (this.totalPoints == null ? other.totalPoints != null : !this.totalPoints.equals(other.totalPoints)) {
            return false;
        }
        if (this.incrementalScoreCorrectionInPoints == null ? other.incrementalScoreCorrectionInPoints != null : !this.incrementalScoreCorrectionInPoints.equals(other.incrementalScoreCorrectionInPoints)) {
            return false;
        }
        if (this.totalPointsCorrected != other.totalPointsCorrected) {
            return false;
        }
        if (this.totalPointsUncorrected == null ? other.totalPointsUncorrected != null : !this.totalPointsUncorrected.equals(other.totalPointsUncorrected)) {
            return false;
        }
        return !(this.windwardDistanceToCompetitorFarthestAheadInMeters == null ? other.windwardDistanceToCompetitorFarthestAheadInMeters != null : !this.windwardDistanceToCompetitorFarthestAheadInMeters.equals(other.windwardDistanceToCompetitorFarthestAheadInMeters));
    }

    public static class ExpeditionDataHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public Double expeditionMastButt;
        public Double expeditionJibCarStbd;
        public Double expeditionJibCarPort;
        public Double expeditionLoadS;
        public Double expeditionLoadP;
        public Double expeditionBARO;
        public Double expeditionAWA;
        public Double expeditionAWS;
        public Double expeditionBoatSpeed;
        public Double expeditionCOG;
        public Double expeditionDistanceBelowLine;
        public Double expeditionDistanceToCommitteeBoat;
        public Double expeditionDistToPortLayline;
        public Double expeditionDistToStbLayline;
        public Double expeditionVMG;
        public Double expeditionTWS;
        public Double expeditionTWD;
        public Double expeditionTWA;
        public Double expeditionTimeToStbLayline;
        public Double expeditionTimeToPortLayline;
        public Double expeditionTimeToPin;
        public Double expeditionTimeToGunInSeconds;
        public Double expeditionTimeToCommitteeBoat;
        public Double expeditionTimeToBurnToPin;
        public Double expeditionTargTWA;
        public Double expeditionTimeToBurnToCommitteeBoat;
        public Double expeditionTimeToBurnToLineInSeconds;
        public Double expeditionTargetHeel;
        public Double expeditionTargBoatSpeed;
        public Double expeditionSOG;
        public Double expeditionRudderAngle;
        public Double expeditionRateOfTurn;
        public Double expeditionRake;
        public Double expeditionLineSquareForWindDirection;
        public Double expeditionHeading;
        public Double expeditionForestayLoad;
        public Double expeditionHeel;
        public Double expeditionCourseDetail;
        public Double expeditionDistanceToPinDetail;
        public Double expeditionVMGTargVMGDelta;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.expeditionAWA == null ? 0 : this.expeditionAWA.hashCode());
            result = 31 * result + (this.expeditionAWS == null ? 0 : this.expeditionAWS.hashCode());
            result = 31 * result + (this.expeditionBARO == null ? 0 : this.expeditionBARO.hashCode());
            result = 31 * result + (this.expeditionBoatSpeed == null ? 0 : this.expeditionBoatSpeed.hashCode());
            result = 31 * result + (this.expeditionCOG == null ? 0 : this.expeditionCOG.hashCode());
            result = 31 * result + (this.expeditionCourseDetail == null ? 0 : this.expeditionCourseDetail.hashCode());
            result = 31 * result + (this.expeditionDistToPortLayline == null ? 0 : this.expeditionDistToPortLayline.hashCode());
            result = 31 * result + (this.expeditionDistToStbLayline == null ? 0 : this.expeditionDistToStbLayline.hashCode());
            result = 31 * result + (this.expeditionDistanceBelowLine == null ? 0 : this.expeditionDistanceBelowLine.hashCode());
            result = 31 * result + (this.expeditionDistanceToCommitteeBoat == null ? 0 : this.expeditionDistanceToCommitteeBoat.hashCode());
            result = 31 * result + (this.expeditionDistanceToPinDetail == null ? 0 : this.expeditionDistanceToPinDetail.hashCode());
            result = 31 * result + (this.expeditionForestayLoad == null ? 0 : this.expeditionForestayLoad.hashCode());
            result = 31 * result + (this.expeditionHeading == null ? 0 : this.expeditionHeading.hashCode());
            result = 31 * result + (this.expeditionHeel == null ? 0 : this.expeditionHeel.hashCode());
            result = 31 * result + (this.expeditionJibCarPort == null ? 0 : this.expeditionJibCarPort.hashCode());
            result = 31 * result + (this.expeditionJibCarStbd == null ? 0 : this.expeditionJibCarStbd.hashCode());
            result = 31 * result + (this.expeditionLineSquareForWindDirection == null ? 0 : this.expeditionLineSquareForWindDirection.hashCode());
            result = 31 * result + (this.expeditionLoadP == null ? 0 : this.expeditionLoadP.hashCode());
            result = 31 * result + (this.expeditionLoadS == null ? 0 : this.expeditionLoadS.hashCode());
            result = 31 * result + (this.expeditionMastButt == null ? 0 : this.expeditionMastButt.hashCode());
            result = 31 * result + (this.expeditionRake == null ? 0 : this.expeditionRake.hashCode());
            result = 31 * result + (this.expeditionRateOfTurn == null ? 0 : this.expeditionRateOfTurn.hashCode());
            result = 31 * result + (this.expeditionRudderAngle == null ? 0 : this.expeditionRudderAngle.hashCode());
            result = 31 * result + (this.expeditionSOG == null ? 0 : this.expeditionSOG.hashCode());
            result = 31 * result + (this.expeditionTWA == null ? 0 : this.expeditionTWA.hashCode());
            result = 31 * result + (this.expeditionTWD == null ? 0 : this.expeditionTWD.hashCode());
            result = 31 * result + (this.expeditionTWS == null ? 0 : this.expeditionTWS.hashCode());
            result = 31 * result + (this.expeditionTargBoatSpeed == null ? 0 : this.expeditionTargBoatSpeed.hashCode());
            result = 31 * result + (this.expeditionTargTWA == null ? 0 : this.expeditionTargTWA.hashCode());
            result = 31 * result + (this.expeditionTargetHeel == null ? 0 : this.expeditionTargetHeel.hashCode());
            result = 31 * result + (this.expeditionTimeToBurnToCommitteeBoat == null ? 0 : this.expeditionTimeToBurnToCommitteeBoat.hashCode());
            result = 31 * result + (this.expeditionTimeToBurnToLineInSeconds == null ? 0 : this.expeditionTimeToBurnToLineInSeconds.hashCode());
            result = 31 * result + (this.expeditionTimeToBurnToPin == null ? 0 : this.expeditionTimeToBurnToPin.hashCode());
            result = 31 * result + (this.expeditionTimeToCommitteeBoat == null ? 0 : this.expeditionTimeToCommitteeBoat.hashCode());
            result = 31 * result + (this.expeditionTimeToGunInSeconds == null ? 0 : this.expeditionTimeToGunInSeconds.hashCode());
            result = 31 * result + (this.expeditionTimeToPin == null ? 0 : this.expeditionTimeToPin.hashCode());
            result = 31 * result + (this.expeditionTimeToPortLayline == null ? 0 : this.expeditionTimeToPortLayline.hashCode());
            result = 31 * result + (this.expeditionTimeToStbLayline == null ? 0 : this.expeditionTimeToStbLayline.hashCode());
            result = 31 * result + (this.expeditionVMG == null ? 0 : this.expeditionVMG.hashCode());
            result = 31 * result + (this.expeditionVMGTargVMGDelta == null ? 0 : this.expeditionVMGTargVMGDelta.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpeditionDataHolder other = (ExpeditionDataHolder)obj;
            if (this.expeditionAWA == null ? other.expeditionAWA != null : !this.expeditionAWA.equals(other.expeditionAWA)) {
                return false;
            }
            if (this.expeditionAWS == null ? other.expeditionAWS != null : !this.expeditionAWS.equals(other.expeditionAWS)) {
                return false;
            }
            if (this.expeditionBARO == null ? other.expeditionBARO != null : !this.expeditionBARO.equals(other.expeditionBARO)) {
                return false;
            }
            if (this.expeditionBoatSpeed == null ? other.expeditionBoatSpeed != null : !this.expeditionBoatSpeed.equals(other.expeditionBoatSpeed)) {
                return false;
            }
            if (this.expeditionCOG == null ? other.expeditionCOG != null : !this.expeditionCOG.equals(other.expeditionCOG)) {
                return false;
            }
            if (this.expeditionCourseDetail == null ? other.expeditionCourseDetail != null : !this.expeditionCourseDetail.equals(other.expeditionCourseDetail)) {
                return false;
            }
            if (this.expeditionDistToPortLayline == null ? other.expeditionDistToPortLayline != null : !this.expeditionDistToPortLayline.equals(other.expeditionDistToPortLayline)) {
                return false;
            }
            if (this.expeditionDistToStbLayline == null ? other.expeditionDistToStbLayline != null : !this.expeditionDistToStbLayline.equals(other.expeditionDistToStbLayline)) {
                return false;
            }
            if (this.expeditionDistanceBelowLine == null ? other.expeditionDistanceBelowLine != null : !this.expeditionDistanceBelowLine.equals(other.expeditionDistanceBelowLine)) {
                return false;
            }
            if (this.expeditionDistanceToCommitteeBoat == null ? other.expeditionDistanceToCommitteeBoat != null : !this.expeditionDistanceToCommitteeBoat.equals(other.expeditionDistanceToCommitteeBoat)) {
                return false;
            }
            if (this.expeditionDistanceToPinDetail == null ? other.expeditionDistanceToPinDetail != null : !this.expeditionDistanceToPinDetail.equals(other.expeditionDistanceToPinDetail)) {
                return false;
            }
            if (this.expeditionForestayLoad == null ? other.expeditionForestayLoad != null : !this.expeditionForestayLoad.equals(other.expeditionForestayLoad)) {
                return false;
            }
            if (this.expeditionHeading == null ? other.expeditionHeading != null : !this.expeditionHeading.equals(other.expeditionHeading)) {
                return false;
            }
            if (this.expeditionHeel == null ? other.expeditionHeel != null : !this.expeditionHeel.equals(other.expeditionHeel)) {
                return false;
            }
            if (this.expeditionJibCarPort == null ? other.expeditionJibCarPort != null : !this.expeditionJibCarPort.equals(other.expeditionJibCarPort)) {
                return false;
            }
            if (this.expeditionJibCarStbd == null ? other.expeditionJibCarStbd != null : !this.expeditionJibCarStbd.equals(other.expeditionJibCarStbd)) {
                return false;
            }
            if (this.expeditionLineSquareForWindDirection == null ? other.expeditionLineSquareForWindDirection != null : !this.expeditionLineSquareForWindDirection.equals(other.expeditionLineSquareForWindDirection)) {
                return false;
            }
            if (this.expeditionLoadP == null ? other.expeditionLoadP != null : !this.expeditionLoadP.equals(other.expeditionLoadP)) {
                return false;
            }
            if (this.expeditionLoadS == null ? other.expeditionLoadS != null : !this.expeditionLoadS.equals(other.expeditionLoadS)) {
                return false;
            }
            if (this.expeditionMastButt == null ? other.expeditionMastButt != null : !this.expeditionMastButt.equals(other.expeditionMastButt)) {
                return false;
            }
            if (this.expeditionRake == null ? other.expeditionRake != null : !this.expeditionRake.equals(other.expeditionRake)) {
                return false;
            }
            if (this.expeditionRateOfTurn == null ? other.expeditionRateOfTurn != null : !this.expeditionRateOfTurn.equals(other.expeditionRateOfTurn)) {
                return false;
            }
            if (this.expeditionRudderAngle == null ? other.expeditionRudderAngle != null : !this.expeditionRudderAngle.equals(other.expeditionRudderAngle)) {
                return false;
            }
            if (this.expeditionSOG == null ? other.expeditionSOG != null : !this.expeditionSOG.equals(other.expeditionSOG)) {
                return false;
            }
            if (this.expeditionTWA == null ? other.expeditionTWA != null : !this.expeditionTWA.equals(other.expeditionTWA)) {
                return false;
            }
            if (this.expeditionTWD == null ? other.expeditionTWD != null : !this.expeditionTWD.equals(other.expeditionTWD)) {
                return false;
            }
            if (this.expeditionTWS == null ? other.expeditionTWS != null : !this.expeditionTWS.equals(other.expeditionTWS)) {
                return false;
            }
            if (this.expeditionTargBoatSpeed == null ? other.expeditionTargBoatSpeed != null : !this.expeditionTargBoatSpeed.equals(other.expeditionTargBoatSpeed)) {
                return false;
            }
            if (this.expeditionTargTWA == null ? other.expeditionTargTWA != null : !this.expeditionTargTWA.equals(other.expeditionTargTWA)) {
                return false;
            }
            if (this.expeditionTargetHeel == null ? other.expeditionTargetHeel != null : !this.expeditionTargetHeel.equals(other.expeditionTargetHeel)) {
                return false;
            }
            if (this.expeditionTimeToBurnToCommitteeBoat == null ? other.expeditionTimeToBurnToCommitteeBoat != null : !this.expeditionTimeToBurnToCommitteeBoat.equals(other.expeditionTimeToBurnToCommitteeBoat)) {
                return false;
            }
            if (this.expeditionTimeToBurnToLineInSeconds == null ? other.expeditionTimeToBurnToLineInSeconds != null : !this.expeditionTimeToBurnToLineInSeconds.equals(other.expeditionTimeToBurnToLineInSeconds)) {
                return false;
            }
            if (this.expeditionTimeToBurnToPin == null ? other.expeditionTimeToBurnToPin != null : !this.expeditionTimeToBurnToPin.equals(other.expeditionTimeToBurnToPin)) {
                return false;
            }
            if (this.expeditionTimeToCommitteeBoat == null ? other.expeditionTimeToCommitteeBoat != null : !this.expeditionTimeToCommitteeBoat.equals(other.expeditionTimeToCommitteeBoat)) {
                return false;
            }
            if (this.expeditionTimeToGunInSeconds == null ? other.expeditionTimeToGunInSeconds != null : !this.expeditionTimeToGunInSeconds.equals(other.expeditionTimeToGunInSeconds)) {
                return false;
            }
            if (this.expeditionTimeToPin == null ? other.expeditionTimeToPin != null : !this.expeditionTimeToPin.equals(other.expeditionTimeToPin)) {
                return false;
            }
            if (this.expeditionTimeToPortLayline == null ? other.expeditionTimeToPortLayline != null : !this.expeditionTimeToPortLayline.equals(other.expeditionTimeToPortLayline)) {
                return false;
            }
            if (this.expeditionTimeToStbLayline == null ? other.expeditionTimeToStbLayline != null : !this.expeditionTimeToStbLayline.equals(other.expeditionTimeToStbLayline)) {
                return false;
            }
            if (this.expeditionVMG == null ? other.expeditionVMG != null : !this.expeditionVMG.equals(other.expeditionVMG)) {
                return false;
            }
            return !(this.expeditionVMGTargVMGDelta == null ? other.expeditionVMGTargVMGDelta != null : !this.expeditionVMGTargVMGDelta.equals(other.expeditionVMGTargVMGDelta));
        }
    }
}

