/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import com.sap.sse.common.Duration;

public class DurationFormatter {
    private final boolean shortMode;
    private final boolean nonNegativeDuration;

    public static DurationFormatter getInstance(boolean shortMode, boolean nonNegativeDuration) {
        return new DurationFormatter(shortMode, nonNegativeDuration);
    }

    public DurationFormatter(boolean shortMode, boolean nonNegativeDuration) {
        this.shortMode = shortMode;
        this.nonNegativeDuration = nonNegativeDuration;
    }

    public String format(Duration instance) {
        StringBuffer result = new StringBuffer();
        double asDays = instance.asDays();
        double asHours = instance.asHours();
        double asMinutes = instance.asMinutes();
        if (asDays >= 1.0 || asDays <= -1.0) {
            result.append(String.valueOf((int)this.ensureDisplay(asDays, this.nonNegativeDuration)) + (this.shortMode ? "d" : " day"));
            if ((asDays >= 2.0 || asDays <= -2.0) && !this.shortMode) {
                result.append("s");
            }
        } else if (asHours >= 1.0 || asHours <= -1.0) {
            result.append(String.valueOf((int)this.ensureDisplay(asHours, this.nonNegativeDuration)) + (this.shortMode ? "h" : " hour"));
            if ((asHours >= 2.0 || asHours <= -2.0) && !this.shortMode) {
                result.append("s");
            }
        } else if (asMinutes >= 1.0 || asMinutes <= -1.0) {
            int minutesToSee = (int)this.ensureDisplay(asMinutes, this.nonNegativeDuration);
            int secondsToSee = (int)this.ensureDisplay(instance.minus(Duration.ONE_MINUTE.times((long)Math.abs(asMinutes))).asSeconds(), this.nonNegativeDuration);
            if (secondsToSee < 10 && secondsToSee > 0) {
                result.append(String.valueOf(minutesToSee) + ":0" + secondsToSee + (this.shortMode ? "" : " min"));
            } else {
                if (secondsToSee < 0) {
                    secondsToSee = Math.abs(secondsToSee);
                }
                result.append(String.valueOf(minutesToSee) + ":" + secondsToSee + (this.shortMode ? "" : " min"));
            }
        } else {
            result.append((int)this.ensureDisplay(instance.asSeconds(), this.nonNegativeDuration));
            if (!this.shortMode) {
                result.append(" s");
            }
        }
        return result.toString();
    }

    private double ensureDisplay(double input, boolean nonNegativeDurationDisplay) {
        return nonNegativeDurationDisplay && input < 0.0 ? Math.abs(input) : input;
    }
}

