/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.userstore.mongodb.impl;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.security.interfaces.Social;
import com.sap.sse.security.interfaces.UserImpl;
import com.sap.sse.security.interfaces.UserStore;
import com.sap.sse.security.shared.AccessControlListAnnotation;
import com.sap.sse.security.shared.Account;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.RoleDefinitionImpl;
import com.sap.sse.security.shared.SocialUserAccount;
import com.sap.sse.security.shared.UserGroupProvider;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.UsernamePasswordAccount;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.LockingAndBanning;
import com.sap.sse.security.shared.impl.LockingAndBanningImpl;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.QualifiedObjectIdentifierImpl;
import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.shared.impl.UserGroupImpl;
import com.sap.sse.security.shared.subscription.Subscription;
import com.sap.sse.security.subscription.SubscriptionData;
import com.sap.sse.security.subscription.SubscriptionDataHandler;
import com.sap.sse.security.userstore.mongodb.DomainObjectFactory;
import com.sap.sse.security.userstore.mongodb.impl.Activator;
import com.sap.sse.security.userstore.mongodb.impl.CollectionNames;
import com.sap.sse.security.userstore.mongodb.impl.FieldNames;
import com.sap.sse.security.userstore.mongodb.impl.MongoObjectFactoryImpl;
import com.sap.sse.security.userstore.mongodb.impl.UserProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;

public class DomainObjectFactoryImpl
implements DomainObjectFactory {
    private static final Logger logger = Logger.getLogger(DomainObjectFactoryImpl.class.getName());
    private final MongoDatabase db;

    public DomainObjectFactoryImpl(MongoDatabase db) {
        this.db = db;
    }

    @Override
    public Iterable<AccessControlListAnnotation> loadAllAccessControlLists(UserStore userStore) {
        ArrayList<AccessControlListAnnotation> result = new ArrayList<AccessControlListAnnotation>();
        MongoCollection aclCollection = this.db.getCollection(CollectionNames.ACCESS_CONTROL_LISTS.name());
        try {
            for (Document o : aclCollection.find()) {
                result.add(this.loadAccessControlList(o, userStore));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load ACLs.");
            logger.log(Level.SEVERE, "loadAllAccessControlLists", e);
        }
        return result;
    }

    private AccessControlListAnnotation loadAccessControlList(Document aclDBObject, UserStore userStore) {
        QualifiedObjectIdentifier id = QualifiedObjectIdentifierImpl.fromDBWithoutEscaping((String)((String)aclDBObject.get((Object)FieldNames.AccessControlList.OBJECT_ID.name())));
        String displayName = (String)aclDBObject.get((Object)FieldNames.AccessControlList.OBJECT_DISPLAY_NAME.name());
        List dbPermissionMap = (List)aclDBObject.get((Object)FieldNames.AccessControlList.PERMISSION_MAP.name());
        HashMap permissionMap = new HashMap();
        for (Object dbPermissionMapEntryO : dbPermissionMap) {
            Document dbPermissionMapEntry = (Document)dbPermissionMapEntryO;
            UUID userGroupKey = (UUID)dbPermissionMapEntry.get((Object)FieldNames.AccessControlList.PERMISSION_MAP_USER_GROUP_ID.name());
            UserGroup userGroup = userStore.getUserGroup(userGroupKey);
            HashSet<String> actions = new HashSet<String>();
            for (Object o : (List)dbPermissionMapEntry.get((Object)FieldNames.AccessControlList.PERMISSION_MAP_ACTIONS.name())) {
                actions.add(o.toString());
            }
            permissionMap.put(userGroup, actions);
        }
        AccessControlListAnnotation result = new AccessControlListAnnotation(new AccessControlList(permissionMap), id, displayName);
        return result;
    }

    @Override
    public Iterable<OwnershipAnnotation> loadAllOwnerships(UserStore userStore) {
        ArrayList<OwnershipAnnotation> result = new ArrayList<OwnershipAnnotation>();
        MongoCollection ownershipCollection = this.db.getCollection(CollectionNames.OWNERSHIPS.name());
        try {
            for (Document o : ownershipCollection.find()) {
                result.add(this.loadOwnership(o, userStore));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load ownerships.");
            logger.log(Level.SEVERE, "loadAllOwnerships", e);
        }
        return result;
    }

    private OwnershipAnnotation loadOwnership(Document ownershipDBObject, UserStore userStore) {
        String escapedId = (String)ownershipDBObject.get((Object)FieldNames.Ownership.OBJECT_ID.name());
        QualifiedObjectIdentifier idOfOwnedObject = QualifiedObjectIdentifierImpl.fromDBWithoutEscaping((String)escapedId);
        String displayNameOfOwnedObject = (String)ownershipDBObject.get((Object)FieldNames.Ownership.OBJECT_DISPLAY_NAME.name());
        String userOwnerName = (String)ownershipDBObject.get((Object)FieldNames.Ownership.OWNER_USERNAME.name());
        UUID tenantOwnerId = (UUID)ownershipDBObject.get((Object)FieldNames.Ownership.TENANT_OWNER_ID.name());
        User userOwner = userStore.getUserByName(userOwnerName);
        UserGroup tenantOwner = userStore.getUserGroup(tenantOwnerId);
        return new OwnershipAnnotation(new Ownership(userOwner, tenantOwner), idOfOwnedObject, displayNameOfOwnedObject);
    }

    @Override
    public Iterable<RoleDefinition> loadAllRoleDefinitions() {
        ArrayList<RoleDefinition> result = new ArrayList<RoleDefinition>();
        MongoCollection roleCollection = this.db.getCollection(CollectionNames.ROLES.name());
        try {
            for (Document o : roleCollection.find()) {
                result.add(this.loadRoleDefinition(o));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load role definitions.");
            logger.log(Level.SEVERE, "loadAllRoleDefinitions", e);
        }
        return result;
    }

    private RoleDefinition loadRoleDefinition(Document roleDefinitionDBObject) {
        String id = (String)roleDefinitionDBObject.get((Object)FieldNames.Role.ID.name());
        String displayName = (String)roleDefinitionDBObject.get((Object)FieldNames.Role.NAME.name());
        HashSet<WildcardPermission> permissions = new HashSet<WildcardPermission>();
        for (Object o : (List)roleDefinitionDBObject.get((Object)FieldNames.Role.PERMISSIONS.name())) {
            permissions.add(new WildcardPermission(o.toString()));
        }
        return new RoleDefinitionImpl(UUID.fromString(id), displayName, permissions);
    }

    @Override
    public Iterable<UserGroup> loadAllUserGroupsAndTenantsWithProxyUsers(Map<UUID, RoleDefinition> roleDefinitionsById) {
        HashSet<UserGroup> userGroups = new HashSet<UserGroup>();
        MongoCollection userGroupCollection = this.db.getCollection(CollectionNames.USER_GROUPS.name());
        try {
            for (Document o : userGroupCollection.find()) {
                UserGroup userGroup = this.loadUserGroupWithProxyUsers(o, roleDefinitionsById);
                userGroups.add(userGroup);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load user groups.");
            logger.log(Level.SEVERE, "loadAllUserGroups", e);
        }
        return userGroups;
    }

    private UserGroup loadUserGroupWithProxyUsers(Document groupDBObject, Map<UUID, RoleDefinition> roleDefinitionsById) {
        UUID id = (UUID)groupDBObject.get((Object)FieldNames.UserGroup.ID.name());
        String name = (String)groupDBObject.get((Object)FieldNames.UserGroup.NAME.name());
        HashSet<UserProxy> users = new HashSet<UserProxy>();
        List usersO = (List)groupDBObject.get((Object)FieldNames.UserGroup.USERNAMES.name());
        if (usersO != null) {
            for (Object o : usersO) {
                users.add(new UserProxy((String)o));
            }
        }
        HashMap<RoleDefinition, Boolean> roleDefinitionMap = new HashMap<RoleDefinition, Boolean>();
        List dbRoleDefinitionMap = (List)groupDBObject.get((Object)FieldNames.UserGroup.ROLE_DEFINITION_MAP.name());
        if (dbRoleDefinitionMap != null) {
            for (Object roleDefO : dbRoleDefinitionMap) {
                Document roleDefEntry = (Document)roleDefO;
                UUID roleDefId = (UUID)roleDefEntry.get((Object)FieldNames.UserGroup.ROLE_DEFINITION_MAP_ROLE_ID.name(), UUID.class);
                Boolean forAll = roleDefEntry.getBoolean((Object)FieldNames.UserGroup.ROLE_DEFINITION_MAP_FOR_ALL.name());
                RoleDefinition roleDefinition = roleDefinitionsById.get(roleDefId);
                if (roleDefinition != null) {
                    roleDefinitionMap.put(roleDefinition, forAll);
                    continue;
                }
                logger.severe("RoleDefinition with ID " + roleDefId + " which the user group " + name + " with ID " + id + " grants cannot be found");
            }
        }
        return new UserGroupImpl(id, name, users, roleDefinitionMap);
    }

    @Override
    public Iterable<User> loadAllUsers(Map<UUID, RoleDefinition> roleDefinitionsById, DomainObjectFactory.RoleMigrationConverter roleMigrationConverter, Map<UUID, UserGroup> userGroups, UserGroupProvider userGroupProvider) throws UserManagementException {
        HashMap<String, User> result = new HashMap<String, User>();
        MongoCollection userCollection = this.db.getCollection(CollectionNames.USERS.name());
        try {
            for (Document o : userCollection.find()) {
                User userWithProxyRoleUserQualifier = this.loadUserWithProxyRoleUserQualifiers(o, roleDefinitionsById, roleMigrationConverter, userGroups, userGroupProvider);
                result.put(userWithProxyRoleUserQualifier.getName(), userWithProxyRoleUserQualifier);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load users.");
            logger.log(Level.SEVERE, "loadAllUsers", e);
        }
        this.resolveRoleUserQualifiers(result);
        return result.values();
    }

    private void resolveRoleUserQualifiers(Map<String, User> users) throws UserManagementException {
        for (User user : users.values()) {
            HashSet userRoles = new HashSet();
            Util.addAll((Iterable)user.getRoles(), userRoles);
            for (Role roleWithUserQualifierProxy : userRoles) {
                User userQualifierProxy = (User)roleWithUserQualifierProxy.getQualifiedForUser();
                if (userQualifierProxy == null) continue;
                User resolvedUserQualifier = users.get(userQualifierProxy.getName());
                user.removeRole(roleWithUserQualifierProxy);
                if (resolvedUserQualifier == null) {
                    logger.severe("Unable to resolve user named " + userQualifierProxy.getName() + " which serves as a role qualifier for role " + roleWithUserQualifierProxy.getName() + " for user " + user.getName() + ". Removing role.");
                    continue;
                }
                user.addRole(new Role(roleWithUserQualifierProxy.getRoleDefinition(), (UserGroup)roleWithUserQualifierProxy.getQualifiedForTenant(), resolvedUserQualifier, roleWithUserQualifierProxy.isTransitive()));
            }
        }
    }

    private User loadUserWithProxyRoleUserQualifiers(Document userDBObject, Map<UUID, RoleDefinition> roleDefinitionsById, DomainObjectFactory.RoleMigrationConverter roleMigrationConverter, Map<UUID, UserGroup> tenants, UserGroupProvider userGroupProvider) {
        String username = (String)userDBObject.get((Object)FieldNames.User.NAME.name());
        String email = (String)userDBObject.get((Object)FieldNames.User.EMAIL.name());
        String fullName = (String)userDBObject.get((Object)FieldNames.User.FULLNAME.name());
        String company = (String)userDBObject.get((Object)FieldNames.User.COMPANY.name());
        String localeRaw = (String)userDBObject.get((Object)FieldNames.User.LOCALE.name());
        Locale locale = localeRaw != null ? Locale.forLanguageTag(localeRaw) : null;
        Boolean emailValidated = (Boolean)userDBObject.get((Object)FieldNames.User.EMAIL_VALIDATED.name());
        String passwordResetSecret = (String)userDBObject.get((Object)FieldNames.User.PASSWORD_RESET_SECRET.name());
        String validationSecret = (String)userDBObject.get((Object)FieldNames.User.VALIDATION_SECRET.name());
        Long lockedUntilMillis = userDBObject.getLong((Object)FieldNames.User.LOCKED_UNTIL_MILLIS.name());
        Long nextLockingDurationMillis = userDBObject.getLong((Object)FieldNames.User.NEXT_LOCKING_DURATION_MILLIS.name());
        LockingAndBanningImpl lockingAndBanning = new LockingAndBanningImpl(lockedUntilMillis == null ? TimePoint.BeginningOfTime : TimePoint.of((Long)lockedUntilMillis), nextLockingDurationMillis == null ? LockingAndBanningImpl.DEFAULT_INITIAL_LOCKING_DELAY : Duration.ofMillis((long)nextLockingDurationMillis));
        HashSet<Object> roles = new HashSet<Object>();
        HashSet<String> permissions = new HashSet<String>();
        List rolesO = (List)userDBObject.get((Object)FieldNames.User.ROLE_IDS.name());
        boolean rolesMigrated = false;
        if (rolesO != null) {
            for (Object o : rolesO) {
                Role role = this.loadRoleWithProxyUserQualifier((Document)o, roleDefinitionsById, tenants);
                if (role != null) {
                    roles.add(role);
                    continue;
                }
                logger.warning("Role with ID " + o + " that used to be assigned to user " + username + " not found");
            }
        } else {
            logger.info("Migrating roles of user " + username);
            List roleNames = (List)userDBObject.get((Object)"ROLES");
            if (roleNames != null) {
                logger.info("Found old roles " + roleNames + " for user " + username);
                for (Object o : roleNames) {
                    Role convertedRole = roleMigrationConverter.convert(o.toString(), username);
                    if (convertedRole != null) {
                        logger.info("Found role " + convertedRole.getRoleDefinition() + " for old role " + o.toString() + " for user " + username);
                        roles.add(convertedRole);
                        rolesMigrated = true;
                        continue;
                    }
                    logger.warning("Role " + o.toString() + " for user " + username + " not found during migration. User will no longer be in this role.");
                }
            }
        }
        Iterable permissionsO = (Iterable)userDBObject.get((Object)FieldNames.User.PERMISSIONS.name());
        if (permissionsO != null) {
            for (Object o : permissionsO) {
                permissions.add((String)o);
            }
        }
        ConcurrentHashMap<String, UserGroup> defaultTenant = new ConcurrentHashMap<String, UserGroup>();
        List defaultTenantIds = (List)userDBObject.get((Object)FieldNames.User.DEFAULT_TENANT_IDS.name());
        if (defaultTenantIds != null) {
            for (Object singleDefaultTenant : defaultTenantIds) {
                Document singleDefaultTenantObj = (Document)singleDefaultTenant;
                String string = singleDefaultTenantObj.getString((Object)FieldNames.User.DEFAULT_TENANT_SERVER.name());
                UUID groupId = (UUID)singleDefaultTenantObj.get((Object)FieldNames.User.DEFAULT_TENANT_GROUP.name());
                UserGroup tenantOfGroup = tenants.get(groupId);
                if (tenantOfGroup == null) {
                    logger.warning("Couldn't find tenant for user " + username + ". The tenant was identified by ID " + groupId + " but no tenant with that ID was found");
                    continue;
                }
                defaultTenant.put(string, tenantOfGroup);
            }
        }
        Document accountsMap = (Document)userDBObject.get((Object)FieldNames.User.ACCOUNTS.name());
        Map<Account.AccountType, Account> accounts = this.createAccountMapFromdDBObject(accountsMap);
        UserImpl result = new UserImpl(username, email, fullName, company, locale, Boolean.valueOf(emailValidated == null ? false : emailValidated), passwordResetSecret, validationSecret, defaultTenant, accounts.values(), userGroupProvider, (LockingAndBanning)lockingAndBanning);
        for (Role role : roles) {
            result.addRole(role);
        }
        for (String string : permissions) {
            result.addPermission(new WildcardPermission(string));
        }
        if (rolesMigrated) {
            new MongoObjectFactoryImpl(this.db).storeUser((User)result);
        }
        List list = (List)userDBObject.get((Object)FieldNames.User.SUBSCRIPTIONS.name());
        result.setSubscriptions(this.loadSubscriptions(list));
        return result;
    }

    private Role loadRoleWithProxyUserQualifier(Document rolesO, Map<UUID, RoleDefinition> roleDefinitionsById, Map<UUID, UserGroup> userGroups) {
        Role result;
        RoleDefinition roleDefinition = roleDefinitionsById.get(rolesO.get((Object)FieldNames.Role.ID.name()));
        if (roleDefinition == null) {
            result = null;
        } else {
            UUID qualifyingTenantId = (UUID)rolesO.get((Object)FieldNames.Role.QUALIFYING_TENANT_ID.name());
            UserGroup qualifyingGroup = null;
            if (qualifyingTenantId != null && (qualifyingGroup = userGroups.get(qualifyingTenantId)) == null) {
                logger.severe("Unable to resolve tenant with ID " + qualifyingTenantId + " which serves as a role qualifier for role " + roleDefinition.getName() + "; dropping role");
                result = null;
            } else {
                UserProxy proxyQualifyingUser = rolesO.get((Object)FieldNames.Role.QUALIFYING_USERNAME.name()) == null ? null : new UserProxy((String)rolesO.get((Object)FieldNames.Role.QUALIFYING_USERNAME.name()));
                boolean transitive = rolesO.getBoolean((Object)FieldNames.Role.TRANSITIVE.name(), true);
                result = new Role(roleDefinition, qualifyingGroup, (User)proxyQualifyingUser, Boolean.valueOf(transitive));
            }
        }
        return result;
    }

    private Map<Account.AccountType, Account> createAccountMapFromdDBObject(Document accountsMap) {
        HashMap<Account.AccountType, Account> accounts = new HashMap<Account.AccountType, Account>();
        for (Map.Entry e : accountsMap.entrySet()) {
            Account.AccountType type = Account.AccountType.valueOf((String)((String)e.getKey()));
            Account account = this.createAccountFromDBObject((Document)e.getValue(), type);
            accounts.put(type, account);
        }
        return accounts;
    }

    private Account createAccountFromDBObject(Document dbAccount, Account.AccountType type) {
        switch (type) {
            case USERNAME_PASSWORD: {
                String name = (String)dbAccount.get((Object)FieldNames.UsernamePassword.NAME.name());
                String saltedPassword = (String)dbAccount.get((Object)FieldNames.UsernamePassword.SALTED_PW.name());
                Binary salt = (Binary)dbAccount.get((Object)FieldNames.UsernamePassword.SALT.name());
                return new UsernamePasswordAccount(name, saltedPassword, salt.getData());
            }
            case SOCIAL_USER: {
                SocialUserAccount socialUserAccount = new SocialUserAccount();
                Social[] socialArray = Social.values();
                int n = socialArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Social s = socialArray[n2];
                    socialUserAccount.setProperty(s.name(), (String)dbAccount.get((Object)s.name()));
                    ++n2;
                }
                return socialUserAccount;
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> loadSettings() {
        Map<String, Object> result = new HashMap<String, Object>();
        MongoCollection settingsCollection = this.db.getCollection(CollectionNames.SETTINGS.name());
        try {
            Document query = new Document();
            query.put(FieldNames.Settings.NAME.name(), (Object)FieldNames.Settings.VALUES.name());
            Document settingDBObject = (Document)settingsCollection.find((Bson)query).first();
            if (settingDBObject != null) {
                result = this.loadSettingMap(settingDBObject);
            } else {
                logger.info("No stored settings found!");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load settings.");
            logger.log(Level.SEVERE, "loadSettings", e);
        }
        return result;
    }

    @Override
    public Map<String, Map<String, String>> loadPreferences() {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        MongoCollection settingsCollection = this.db.getCollection(CollectionNames.PREFERENCES.name());
        try {
            for (Object o : settingsCollection.find()) {
                Document usernameAndPreferencesMap = (Document)o;
                Map<String, String> userMap = this.loadPreferencesMap((Iterable)usernameAndPreferencesMap.get((Object)FieldNames.Preferences.KEYS_AND_VALUES.name()));
                String username = (String)usernameAndPreferencesMap.get((Object)FieldNames.Preferences.USERNAME.name());
                result.put(username, userMap);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load settings.");
            logger.log(Level.SEVERE, "loadSettings", e);
        }
        return result;
    }

    private Map<String, String> loadPreferencesMap(Iterable<?> preferencesDBObject) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Object o : preferencesDBObject) {
            Document keyValue = (Document)o;
            String key = (String)keyValue.get((Object)FieldNames.Preferences.KEY.name());
            String value = (String)keyValue.get((Object)FieldNames.Preferences.VALUE.name());
            result.put(key, value);
        }
        return result;
    }

    private Map<String, Object> loadSettingMap(Document settingDBObject) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Document map = (Document)settingDBObject.get((Object)FieldNames.Settings.MAP.name());
        for (Map.Entry e : map.entrySet()) {
            String key = (String)e.getKey();
            Object value = e.getValue();
            result.put(key, value);
        }
        return result;
    }

    @Override
    public Map<String, Class<?>> loadSettingTypes() {
        Map<String, Class<?>> result = new HashMap();
        MongoCollection settingsCollection = this.db.getCollection(CollectionNames.SETTINGS.name());
        try {
            Document query = new Document();
            query.put(FieldNames.Settings.NAME.name(), (Object)FieldNames.Settings.TYPES.name());
            Document settingTypesDBObject = (Document)settingsCollection.find((Bson)query).first();
            if (settingTypesDBObject != null) {
                result = this.loadSettingTypesMap(settingTypesDBObject);
            } else {
                logger.info("No stored setting types found!");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error connecting to MongoDB, unable to load setting types.");
            logger.log(Level.SEVERE, "loadSettingTypes", e);
        }
        return result;
    }

    private Map<String, Class<?>> loadSettingTypesMap(Document settingTypesDBObject) {
        HashMap result = new HashMap();
        Document map = (Document)settingTypesDBObject.get((Object)FieldNames.Settings.MAP.name());
        for (Map.Entry e : map.entrySet()) {
            String key = (String)e.getKey();
            Class<?> value = null;
            try {
                value = Class.forName((String)e.getValue());
            }
            catch (ClassNotFoundException e1) {
                logger.log(Level.WARNING, "Exception trying to load settings types map", e);
            }
            result.put(key, value);
        }
        return result;
    }

    private Subscription[] loadSubscriptions(List<?> subscriptionsDoc) {
        Subscription[] subscriptions;
        if (subscriptionsDoc != null) {
            subscriptions = new Subscription[subscriptionsDoc.size()];
            int i = 0;
            for (Object o : subscriptionsDoc) {
                Document doc = (Document)o;
                HashMap data = new HashMap();
                for (Map.Entry entry : doc.entrySet()) {
                    data.put((String)entry.getKey(), entry.getValue());
                }
                SubscriptionData subscriptionData = new SubscriptionData(data);
                SubscriptionDataHandler subscriptionDataHandler = Activator.getSubscriptionDataHandler(subscriptionData.getProviderName());
                subscriptions[i++] = subscriptionDataHandler.toSubscription(subscriptionData);
            }
        } else {
            subscriptions = null;
        }
        return subscriptions;
    }
}

