/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.news;

import com.sap.sailing.news.EventNewsProvider;
import com.sap.sailing.news.EventNewsService;
import com.sap.sailing.news.impl.EventNewsProviderRegistryImpl;
import com.sap.sailing.news.impl.EventNewsServiceImpl;
import com.sap.sailing.news.impl.LeaderboardUpdateEventNewsProvider;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private ServiceTracker<EventNewsProvider, EventNewsProvider> newsProviderTracker;

    public void start(final BundleContext context) throws Exception {
        final EventNewsProviderRegistryImpl providerRegistry = new EventNewsProviderRegistryImpl();
        EventNewsServiceImpl newsService = new EventNewsServiceImpl(providerRegistry);
        context.registerService(EventNewsService.class, (Object)newsService, null);
        this.newsProviderTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, EventNewsProvider.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<EventNewsProvider, EventNewsProvider>(){

            public EventNewsProvider addingService(ServiceReference<EventNewsProvider> reference) {
                EventNewsProvider eventNewsProvider = (EventNewsProvider)context.getService(reference);
                logger.info("Registering event news provider " + eventNewsProvider);
                providerRegistry.registerNewsProvider(eventNewsProvider);
                return eventNewsProvider;
            }

            public void modifiedService(ServiceReference<EventNewsProvider> reference, EventNewsProvider service) {
            }

            public void removedService(ServiceReference<EventNewsProvider> reference, EventNewsProvider service) {
                EventNewsProvider eventNewsProvider = (EventNewsProvider)context.getService(reference);
                logger.info("De-registering event news provider " + eventNewsProvider);
                providerRegistry.deregisterNewsProvider(eventNewsProvider);
            }
        });
        logger.fine("News provider tracker created: " + this.newsProviderTracker);
        context.registerService(EventNewsProvider.class, (Object)new LeaderboardUpdateEventNewsProvider(), null);
        logger.info("EventNews Service registered.");
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

