/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.xrr.structureimport.buildstructure;

import com.sap.sailing.xrr.schema.Race;
import com.sap.sailing.xrr.structureimport.buildstructure.Fleet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Series {
    private String series = "";
    private int maxRaces = 0;
    private int maxRacesIndex = -1;
    private List<String> raceNames = new ArrayList<String>();
    private List<Fleet> fleets = new ArrayList<Fleet>();

    public Series(String raceType) {
        this.series = raceType;
    }

    public void addRace(Race race, int[] numberOfRaces) {
        boolean fleetEx = false;
        int raceNumber = race.getRaceNumber().intValue();
        String[] raceName = race.getRaceName().split(" ");
        String fleetColor = "";
        if (raceName.length > 1) {
            fleetColor = raceName[raceName.length - 1];
            for (Fleet fleet : this.fleets) {
                if (!fleetColor.equals(fleet.getColor())) continue;
                fleetEx = true;
            }
        }
        if (numberOfRaces[raceNumber - 1] <= 1 && !fleetEx) {
            fleetColor = "";
        }
        boolean added = false;
        int counter = 0;
        for (Fleet fleet : this.fleets) {
            if (fleet.getColor().equals(fleetColor)) {
                fleet.addRace(race);
                added = true;
            }
            if (fleet.getNumRaces() > this.maxRaces) {
                this.maxRaces = fleet.getNumRaces();
                this.maxRacesIndex = counter;
            }
            ++counter;
        }
        if (!added) {
            Fleet newFleet = new Fleet(fleetColor);
            newFleet.addRace(race);
            if (newFleet.getNumRaces() > this.maxRaces) {
                this.maxRaces = newFleet.getNumRaces();
                this.maxRacesIndex = this.fleets.size();
            }
            this.fleets.add(newFleet);
            Collections.sort(this.fleets);
        }
    }

    public char getFirstChar() {
        return this.series.charAt(0);
    }

    public String getSeries() {
        return this.series;
    }

    public void setSeries(String series) {
        this.series = series;
    }

    public List<Fleet> getFleets() {
        return this.fleets;
    }

    public int getMaxRaces() {
        return this.maxRaces;
    }

    public int getMaxIndex() {
        return this.maxRacesIndex;
    }

    public boolean isMedal() {
        return this.series.equals("Medal");
    }

    public List<String> getRaceNames() {
        return this.raceNames;
    }

    public void setRaceNames(List<String> raceNames) {
        this.raceNames = raceNames;
    }
}

