/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.orchestration;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.orchestration.AbstractAwsProcedureImpl;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public abstract class ProcedureWithTargetGroup<ShardingKey>
extends AbstractAwsProcedureImpl<ShardingKey> {
    private static final String MASTER_TARGET_GROUP_SUFFIX = "-m";
    private final ApplicationLoadBalancer<ShardingKey> loadBalancerUsed;
    private final String targetGroupNamePrefix;
    private final String serverName;

    protected ProcedureWithTargetGroup(BuilderImpl<?, ?, ShardingKey> builder) throws Exception {
        super(builder);
        this.loadBalancerUsed = builder.getLoadBalancerUsed();
        this.targetGroupNamePrefix = builder.getTargetGroupNamePrefix();
        this.serverName = builder.getServerName();
    }

    protected <ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>, MetricsT extends ApplicationProcessMetrics> TargetGroup<ShardingKey> createTargetGroup(Region region, String targetGroupName, ProcessT process) {
        return this.getLandscape().createTargetGroup(this.getLoadBalancerUsed().getRegion(), targetGroupName, process.getPort(), process.getHealthCheckPath(), process.getPort(), this.getLoadBalancerUsed().getArn(), this.getLoadBalancerUsed().getVpcId());
    }

    @Override
    public AwsLandscape<ShardingKey> getLandscape() {
        return super.getLandscape();
    }

    public String getMasterTargetGroupName() {
        return String.valueOf(this.getPublicTargetGroupName()) + MASTER_TARGET_GROUP_SUFFIX;
    }

    public TargetGroup<ShardingKey> getMasterTargetGroup() throws JSchException, IOException, InterruptedException, SftpException {
        return this.getLandscape().getTargetGroup(this.loadBalancerUsed.getRegion(), this.getMasterTargetGroupName(), this.getLoadBalancerUsed().getArn());
    }

    public String getPublicTargetGroupName() {
        return String.valueOf(this.targetGroupNamePrefix) + this.serverName.replaceAll("_", "-");
    }

    public TargetGroup<ShardingKey> getPublicTargetGroup() throws JSchException, IOException, InterruptedException, SftpException {
        return this.getLandscape().getTargetGroup(this.loadBalancerUsed.getRegion(), this.getPublicTargetGroupName(), this.getLoadBalancerUsed().getArn());
    }

    public ApplicationLoadBalancer<ShardingKey> getLoadBalancerUsed() {
        return this.loadBalancerUsed;
    }

    public static interface Builder<BuilderT extends Builder<BuilderT, T, ShardingKey>, T extends ProcedureWithTargetGroup<ShardingKey>, ShardingKey>
    extends AbstractAwsProcedureImpl.Builder<BuilderT, T, ShardingKey> {
        public BuilderT setLoadBalancerUsed(ApplicationLoadBalancer<ShardingKey> var1);

        public BuilderT setTargetGroupNamePrefix(String var1);

        public BuilderT setServerName(String var1);
    }

    protected static abstract class BuilderImpl<BuilderT extends Builder<BuilderT, T, ShardingKey>, T extends ProcedureWithTargetGroup<ShardingKey>, ShardingKey>
    extends AbstractAwsProcedureImpl.BuilderImpl<BuilderT, T, ShardingKey>
    implements Builder<BuilderT, T, ShardingKey> {
        private ApplicationLoadBalancer<ShardingKey> loadBalancerUsed;
        private String targetGroupNamePrefix;
        private String serverName;

        protected BuilderImpl() {
        }

        @Override
        public BuilderT setLoadBalancerUsed(ApplicationLoadBalancer<ShardingKey> loadBalancerUsed) {
            this.loadBalancerUsed = loadBalancerUsed;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setTargetGroupNamePrefix(String targetGroupNamePrefix) {
            this.targetGroupNamePrefix = targetGroupNamePrefix;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setServerName(String serverName) {
            this.serverName = serverName;
            return (BuilderT)((Builder)this.self());
        }

        protected ApplicationLoadBalancer<ShardingKey> getLoadBalancerUsed() throws InterruptedException, ExecutionException {
            return this.loadBalancerUsed;
        }

        protected String getTargetGroupNamePrefix() {
            return this.targetGroupNamePrefix;
        }

        protected String getServerName() throws Exception {
            return this.serverName;
        }

        @Override
        protected AwsLandscape<ShardingKey> getLandscape() {
            return super.getLandscape();
        }
    }
}

