/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.aws.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.DefaultProcessConfigurationVariables;
import com.sap.sse.landscape.Host;
import com.sap.sse.landscape.ProcessConfigurationVariable;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.application.ProcessFactory;
import com.sap.sse.landscape.application.impl.ApplicationProcessImpl;
import com.sap.sse.landscape.aws.ApplicationLoadBalancer;
import com.sap.sse.landscape.aws.AwsApplicationProcess;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.HostSupplier;
import com.sap.sse.landscape.aws.MongoUriParser;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.mongodb.Database;
import com.sap.sse.util.IPAddressUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ActionTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealth;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetHealthStateEnum;

public abstract class AwsApplicationProcessImpl<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends ApplicationProcessImpl<ShardingKey, MetricsT, ProcessT>
implements AwsApplicationProcess<ShardingKey, MetricsT, ProcessT> {
    private final AwsLandscape<ShardingKey> landscape;
    private Database databaseConfiguration;

    public AwsApplicationProcessImpl(int port, Host host, String serverDirectory, AwsLandscape<ShardingKey> landscape) {
        super(port, host, serverDirectory);
        this.landscape = landscape;
    }

    public AwsApplicationProcessImpl(int port, Host host, String serverDirectory, Integer telnetPort, String serverName, AwsLandscape<ShardingKey> landscape) {
        super(port, host, serverDirectory, telnetPort, serverName);
        this.landscape = landscape;
    }

    protected AwsLandscape<ShardingKey> getLandscape() {
        return this.landscape;
    }

    @Override
    public AwsInstance<ShardingKey> getHost() {
        AwsInstance host = (AwsInstance)super.getHost();
        return host;
    }

    @Override
    public Database getDatabaseConfiguration(Region region, Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        if (this.databaseConfiguration == null) {
            this.databaseConfiguration = new MongoUriParser<ShardingKey>(this.landscape, region).parseMongoUri(this.getEnvShValueFor((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.MONGODB_URI, optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase));
        }
        return this.databaseConfiguration;
    }

    @Override
    public <HostT extends AwsInstance<ShardingKey>> ProcessT getMaster(Optional<Duration> optionalTimeout, HostSupplier<ShardingKey, HostT> hostSupplier, ProcessFactory<ShardingKey, MetricsT, ProcessT, HostT> processFactory) throws Exception {
        JSONObject replicationStatus = this.getReplicationStatus(optionalTimeout);
        JSONArray replicables = (JSONArray)replicationStatus.get((Object)"replicables");
        for (Object replicableObject : replicables) {
            JSONObject replicable = (JSONObject)replicableObject;
            JSONObject replicatedFrom = (JSONObject)replicable.get((Object)"replicatedfrom");
            if (replicatedFrom == null) continue;
            String masterAddress = (String)replicatedFrom.get((Object)"hostname");
            Integer port = replicatedFrom.get((Object)"port") == null ? null : Integer.valueOf(((Number)replicatedFrom.getOrDefault((Object)"port", (Object)8888)).intValue());
            Util.Pair<HostT, Integer> hostAndOptionalTargetPort = this.getHostAndOptionalTargetPortFromIpAddress(hostSupplier, masterAddress);
            if (hostAndOptionalTargetPort == null) continue;
            return (ProcessT)((AwsApplicationProcess)processFactory.createProcess((Host)((AwsInstance)hostAndOptionalTargetPort.getA()), (hostAndOptionalTargetPort.getB() != null ? (Integer)hostAndOptionalTargetPort.getB() : port).intValue(), null, null, null, Collections.emptyMap()));
        }
        return null;
    }

    private <HostT extends AwsInstance<ShardingKey>> Util.Pair<HostT, Integer> getHostAndOptionalTargetPortFromIpAddress(HostSupplier<ShardingKey, HostT> hostSupplier, String ipAddressOrHostname) {
        Integer targetPort;
        AwsInstance host;
        ApplicationLoadBalancer<ShardingKey> alb;
        ApplicationLoadBalancer<ShardingKey> applicationLoadBalancer = alb = IPAddressUtil.isIPAddressLiteral((String)ipAddressOrHostname) ? null : this.landscape.getDNSMappedLoadBalancerFor(ipAddressOrHostname);
        if (alb != null) {
            logger.info("Found a hostname mapped to a load balancer; trying to find master through target group...");
            host = null;
            targetPort = null;
            for (Rule rule : alb.getRules()) {
                if (!rule.conditions().stream().filter(r -> r.hostHeaderConfig() != null && r.hostHeaderConfig().values().contains(ipAddressOrHostname)).findAny().isPresent() || !rule.conditions().stream().filter(r -> r.httpHeaderConfig() != null && r.httpHeaderConfig().httpHeaderName().equals("X-SAPSSE-Forward-Request-To") && r.httpHeaderConfig().values().contains(HttpRequestHeaderConstants.HEADER_FORWARD_TO_MASTER.getB())).findAny().isPresent()) continue;
                logger.info("Found rule matching hostname " + ipAddressOrHostname + " for master");
                Optional<String> targetGroupArn = rule.actions().stream().filter(a -> a.type() == ActionTypeEnum.FORWARD).map(act -> act.forwardConfig().targetGroups().stream().findAny().map(tgt -> tgt.targetGroupArn()).orElse(null)).findAny();
                Optional<TargetGroup> targetGroup = targetGroupArn.map(tgArn -> this.landscape.getAwsTargetGroupByArn(alb.getRegion(), (String)tgArn)).map(awsTg -> this.landscape.getTargetGroup(alb.getRegion(), awsTg.targetGroupName()));
                host = targetGroup.map(tg -> tg.getRegisteredTargets()).map(tah -> tah.keySet().stream().filter(t -> ((TargetHealth)tah.get(t)).state() == TargetHealthStateEnum.HEALTHY).findAny().orElse(null)).map(awsInstance -> hostSupplier.supply(awsInstance.getInstanceId(), awsInstance.getAvailabilityZone(), awsInstance.getPrivateAddress(), awsInstance.getLaunchTimePoint(), this.landscape)).orElse(null);
                targetPort = targetGroup.map(TargetGroup::getPort).orElse(null);
                if (host == null) continue;
                logger.info("Identified master in target group for hostname " + ipAddressOrHostname + ": " + host + ":" + targetPort);
                break;
            }
        } else {
            targetPort = null;
            try {
                host = (AwsInstance)this.landscape.getHostByPublicIpAddress(this.getHost().getRegion(), ipAddressOrHostname, hostSupplier);
            }
            catch (Exception e) {
                logger.info("Unable to find master by public IP " + ipAddressOrHostname + " (" + e.getMessage() + "); trying to look up master assuming " + ipAddressOrHostname + " is the private IP");
                try {
                    host = (AwsInstance)this.landscape.getHostByPrivateIpAddress(this.getHost().getRegion(), ipAddressOrHostname, hostSupplier);
                }
                catch (Exception f) {
                    logger.info("Unable to find master by private IP " + ipAddressOrHostname + " (" + f.getMessage() + ") either. Returning null.");
                    host = null;
                }
            }
        }
        return host == null ? null : new Util.Pair(host, targetPort);
    }

    @Override
    public <HostT extends AwsInstance<ShardingKey>> Iterable<ProcessT> getReplicas(Optional<Duration> optionalTimeout, HostSupplier<ShardingKey, HostT> hostSupplier, ProcessFactory<ShardingKey, MetricsT, ProcessT, HostT> processFactory) throws TimeoutException, Exception {
        HashSet<AwsApplicationProcess> result = new HashSet<AwsApplicationProcess>();
        JSONObject replicationStatus = this.getReplicationStatus(optionalTimeout);
        JSONArray replicables = (JSONArray)replicationStatus.get((Object)"replicables");
        for (Object replicableObject : replicables) {
            JSONObject replicable = (JSONObject)replicableObject;
            JSONArray replicatedBy = (JSONArray)replicable.get((Object)"replicatedby");
            if (replicatedBy == null) continue;
            for (Object replicaObject : replicatedBy) {
                JSONObject replica = (JSONObject)replicaObject;
                String replicaAddress = (String)replica.get((Object)"address");
                Integer port = replica.get((Object)"port") == null ? null : Integer.valueOf(((Number)replica.getOrDefault((Object)"port", (Object)8888)).intValue());
                Util.Pair<HostT, Integer> hostAndOptionalTargetPort = this.getHostAndOptionalTargetPortFromIpAddress(hostSupplier, replicaAddress);
                if (hostAndOptionalTargetPort == null) continue;
                result.add((AwsApplicationProcess)processFactory.createProcess((Host)((AwsInstance)hostAndOptionalTargetPort.getA()), (hostAndOptionalTargetPort.getB() != null ? (Integer)hostAndOptionalTargetPort.getB() : port).intValue(), null, null, null, Collections.emptyMap()));
            }
        }
        return result;
    }
}

