/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.shared.server.gateway.jaxrs.api;

import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.server.gateway.serialization.impl.MarkRoleJsonSerializer;
import com.sap.sailing.shared.server.gateway.jaxrs.SharedAbstractSailingServerResource;
import com.sap.sse.shared.json.JsonSerializer;
import com.sun.jersey.api.client.ClientResponse;
import java.util.UUID;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Path(value="/v1/markroles")
public class MarkRoleResource
extends SharedAbstractSailingServerResource {
    private final JsonSerializer<MarkRole> markRoleSerializer = new MarkRoleJsonSerializer();

    private Response getBadMarkRoleValidationErrorResponse(String errorText) {
        return Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)(String.valueOf(StringEscapeUtils.escapeHtml((String)errorText)) + ".")).type("text/plain").build();
    }

    private Response getMarkRoleNotFoundErrorResponse() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getMarkRoles() {
        Iterable markRolesList = this.getSharedSailingData().getAllMarkRoles();
        JSONArray result = new JSONArray();
        for (MarkRole markRole : markRolesList) {
            result.add((Object)this.markRoleSerializer.serialize((Object)markRole));
        }
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @GET
    @Path(value="{markRoleId}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getMarkRole(@PathParam(value="markRoleId") String markRoleId) {
        MarkRole markRole = this.getSharedSailingData().getMarkRoleById(UUID.fromString(markRoleId));
        if (markRole == null) {
            return this.getMarkRoleNotFoundErrorResponse();
        }
        JSONObject serializedMarkRole = this.markRoleSerializer.serialize((Object)markRole);
        return Response.ok((Object)this.streamingOutput(serializedMarkRole)).build();
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    public Response createMarkRole(@FormParam(value="name") String name, @FormParam(value="shortName") String shortName) {
        if (name == null || name.isEmpty()) {
            return this.getBadMarkRoleValidationErrorResponse("name must be given");
        }
        MarkRole markRole = this.getSharedSailingData().createMarkRole(name, shortName);
        JSONObject serializedMarkRole = this.markRoleSerializer.serialize((Object)markRole);
        return Response.ok((Object)this.streamingOutput(serializedMarkRole)).build();
    }
}

