/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.shared.server.gateway.jaxrs;

import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.racelogtracking.RaceLogTrackingAdapter;
import com.sap.sailing.domain.racelogtracking.RaceLogTrackingAdapterFactory;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.gateway.interfaces.SailingServerFactory;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.shared.server.SharedSailingData;
import com.sap.sailing.shared.server.gateway.jaxrs.SharedAbstractSecuredServerResource;
import com.sap.sse.InvalidDateException;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.replication.ReplicationService;
import com.sap.sse.security.SecurityService;
import com.sap.sse.util.DateParser;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class SharedAbstractSailingServerResource
extends SharedAbstractSecuredServerResource {
    private static final String SLASH_ENCODING = "__";

    public RacingEventService getService() {
        ServiceTracker tracker = (ServiceTracker)this.servletContext.getAttribute("racingEventServiceTracker");
        return (RacingEventService)tracker.getService();
    }

    protected SharedSailingData getSharedSailingData() {
        ServiceTracker tracker = (ServiceTracker)this.servletContext.getAttribute("sharedSailingDataTracker");
        return (SharedSailingData)tracker.getService();
    }

    protected SecurityService getSecurityService() {
        ServiceTracker tracker = (ServiceTracker)this.servletContext.getAttribute("securityServiceTracker");
        return (SecurityService)tracker.getService();
    }

    protected ReplicationService getReplicationService() {
        ServiceTracker tracker = (ServiceTracker)this.servletContext.getAttribute("replicationServiceTracker");
        return (ReplicationService)tracker.getService();
    }

    protected SailingServerFactory getSailingServerFactory() {
        ServiceTracker tracker = (ServiceTracker)this.servletContext.getAttribute("sailingServerFactoryTracker");
        return (SailingServerFactory)tracker.getService();
    }

    protected Regatta findRegattaByName(String regattaName) {
        Regatta regatta = this.getService().getRegattaByName(regattaName);
        if (regatta == null && regattaName.contains(SLASH_ENCODING)) {
            regatta = this.getService().getRegattaByName(regattaName.replaceAll(SLASH_ENCODING, "/"));
        }
        return regatta;
    }

    protected RaceColumn findRaceColumnByName(Regatta regatta, String raceColumnName) {
        RaceColumn raceColumn = regatta.getRaceColumnByName(raceColumnName);
        if (raceColumn == null && raceColumnName.contains(SLASH_ENCODING)) {
            raceColumn = regatta.getRaceColumnByName(raceColumnName.replaceAll(SLASH_ENCODING, "/"));
        }
        return raceColumn;
    }

    protected Fleet findFleetByName(RaceColumn raceColumn, String fleetName) {
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        if (fleet == null && fleetName.contains(SLASH_ENCODING)) {
            fleet = raceColumn.getFleetByName(fleetName.replaceAll(SLASH_ENCODING, "/"));
        }
        return fleet;
    }

    protected RaceDefinition findRaceByName(Regatta regatta, String raceName) {
        RaceDefinition result = null;
        if (regatta != null && (result = regatta.getRaceByName(raceName)) == null && raceName.contains(SLASH_ENCODING)) {
            result = regatta.getRaceByName(raceName.replaceAll(SLASH_ENCODING, "/"));
        }
        return result;
    }

    protected TimePoint parseTimePoint(String isoTime, Long timeAsMillis, TimePoint defaultTime) throws InvalidDateException {
        Object timePoint = isoTime != null && isoTime.length() > 0 ? new MillisecondsTimePoint(DateParser.parse((String)isoTime).getTime()) : (timeAsMillis != null ? new MillisecondsTimePoint(timeAsMillis.longValue()) : defaultTime);
        return timePoint;
    }

    protected TrackedRace findTrackedRace(String regattaName, String raceName) {
        DynamicTrackedRegatta trackedRegatta;
        Regatta regatta = this.findRegattaByName(regattaName);
        RaceDefinition race = this.findRaceByName(regatta, raceName);
        DynamicTrackedRace trackedRace = null;
        if (regatta != null && race != null && (trackedRegatta = this.getService().getTrackedRegatta(regatta)) != null) {
            trackedRace = trackedRegatta.getExistingTrackedRace(race);
        }
        return trackedRace;
    }

    protected <T> T[] getServices(Class<T> clazz) {
        ServiceTracker<T, T> tracker = this.getServiceTracker(clazz);
        Object[] objectServices = tracker.getServices();
        Object[] services = (Object[])Array.newInstance(clazz, objectServices.length);
        System.arraycopy(objectServices, 0, services, 0, services.length);
        tracker.close();
        return services;
    }

    protected <T> ServiceTracker<T, T> getServiceTracker(Class<T> clazz) {
        BundleContext context = this.getBundleContext();
        ServiceTracker tracker = new ServiceTracker(context, clazz, null);
        tracker.open();
        return tracker;
    }

    protected TrackedRace findTrackedRace(Regatta regatta, String raceName) {
        DynamicTrackedRegatta trackedRegatta;
        RaceDefinition race = this.findRaceByName(regatta, raceName);
        DynamicTrackedRace trackedRace = race != null ? ((trackedRegatta = this.getService().getTrackedRegatta(regatta)) != null ? trackedRegatta.getExistingTrackedRace(race) : null) : null;
        return trackedRace;
    }

    public RaceLogTrackingAdapter getRaceLogTrackingAdapter() {
        return this.getService(RaceLogTrackingAdapterFactory.class).getAdapter(this.getService().getBaseDomainFactory());
    }

    protected static Double roundDouble(Double value, int places) {
        BigDecimal bigDecimal = new BigDecimal(value);
        bigDecimal = bigDecimal.setScale(places, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }
}

