/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.racegroup;

import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.SeriesBase;
import com.sap.sailing.domain.base.racegroup.FilterableRace;
import com.sap.sailing.domain.base.racegroup.RaceGroup;
import com.sap.sailing.domain.base.racegroup.RaceGroupSeries;
import com.sap.sse.common.Util;

public class RaceGroupSeriesFleet
extends RaceGroupSeries {
    private final Fleet fleet;
    private final int fleetOrder;

    public RaceGroupSeriesFleet(FilterableRace race) {
        this(race.getRaceGroup(), race.getSeries(), race.getFleet());
    }

    public RaceGroupSeriesFleet(RaceGroup raceGroup, SeriesBase series, Fleet fleet) {
        super(raceGroup, series);
        this.fleet = fleet;
        this.fleetOrder = this.getFleetIndex(series.getFleets(), fleet);
    }

    private int getFleetIndex(Iterable<? extends Fleet> fleets, Fleet fleet) {
        return Util.indexOf(fleets, (Object)fleet);
    }

    public Fleet getFleet() {
        return this.fleet;
    }

    public String getFleetName() {
        return this.fleet.getName();
    }

    @Override
    public String getDisplayName() {
        return this.getDisplayName(false);
    }

    @Override
    public String getDisplayName(boolean useDisplayName) {
        String name = super.getDisplayName(useDisplayName);
        if (this.fleet != null && !this.fleet.getName().equals("Default")) {
            name = String.valueOf(name) + " - " + this.fleet.getName();
        }
        return name;
    }

    public int getFleetOrder() {
        return this.fleetOrder;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fleet == null ? 0 : this.fleet.hashCode());
        result = 31 * result + this.fleetOrder;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RaceGroupSeriesFleet other = (RaceGroupSeriesFleet)obj;
        if (this.fleet == null ? other.fleet != null : !this.fleet.equals(other.fleet)) {
            return false;
        }
        return this.fleetOrder == other.fleetOrder;
    }
}

