/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components.aggregators;

import com.sap.sailing.domain.common.BearingCluster;
import com.sap.sse.common.Bearing;
import com.sap.sse.datamining.components.AggregationProcessorDefinition;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.GroupedDataEntry;
import com.sap.sse.datamining.impl.components.SimpleAggregationProcessorDefinition;
import com.sap.sse.datamining.impl.components.aggregators.AbstractParallelGroupedDataStoringAggregationProcessor;
import com.sap.sse.datamining.shared.GroupKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class ParallelBearingAverageDegreesAggregationProcessor
extends AbstractParallelGroupedDataStoringAggregationProcessor<Bearing, Double> {
    private static final AggregationProcessorDefinition<Bearing, Double> DEFINITION = new SimpleAggregationProcessorDefinition(Bearing.class, Double.class, "Average", ParallelBearingAverageDegreesAggregationProcessor.class);
    private final Map<GroupKey, BearingCluster> results = new HashMap<GroupKey, BearingCluster>();

    public static AggregationProcessorDefinition<Bearing, Double> getDefinition() {
        return DEFINITION;
    }

    public ParallelBearingAverageDegreesAggregationProcessor(ExecutorService executor, Collection<Processor<Map<GroupKey, Double>, ?>> resultReceivers) {
        super(executor, resultReceivers, "Average");
    }

    protected void storeElement(GroupedDataEntry<Bearing> element) {
        BearingCluster cluster = this.results.get(element.getKey());
        if (cluster == null) {
            cluster = new BearingCluster();
            this.results.put(element.getKey(), cluster);
        }
        cluster.add((Bearing)element.getDataEntry());
    }

    protected Map<GroupKey, Double> aggregateResult() {
        HashMap<GroupKey, Double> result = new HashMap<GroupKey, Double>();
        for (Map.Entry<GroupKey, BearingCluster> clusterEntry : this.results.entrySet()) {
            if (this.isAborted()) break;
            GroupKey key = clusterEntry.getKey();
            result.put(key, clusterEntry.getValue().getAverage().getDegrees());
        }
        return result;
    }
}

