/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.datamining.data.HasTrackedLegContext;
import com.sap.sailing.datamining.data.HasTrackedLegOfCompetitorContext;
import com.sap.sailing.datamining.impl.data.TrackedLegOfCompetitorWithContext;
import com.sap.sailing.datamining.shared.TackTypeSegmentsDataMiningSettings;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class TrackedLegOfCompetitorRetrievalProcessor
extends AbstractRetrievalProcessor<HasTrackedLegContext, HasTrackedLegOfCompetitorContext> {
    private final TackTypeSegmentsDataMiningSettings settings;

    public TrackedLegOfCompetitorRetrievalProcessor(ExecutorService executor, Collection<Processor<HasTrackedLegOfCompetitorContext, ?>> resultReceivers, TackTypeSegmentsDataMiningSettings settings, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasTrackedLegContext.class, HasTrackedLegOfCompetitorContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
        this.settings = settings;
    }

    protected Iterable<HasTrackedLegOfCompetitorContext> retrieveData(HasTrackedLegContext element) {
        ArrayList<HasTrackedLegOfCompetitorContext> trackedLegOfCompetitorsWithContext = new ArrayList<HasTrackedLegOfCompetitorContext>();
        for (Competitor competitor : element.getTrackedRaceContext().getTrackedRace().getRace().getCompetitors()) {
            if (this.isAborted()) break;
            Subject subject = SecurityUtils.getSubject();
            if (!subject.isPermitted(competitor.getIdentifier().getStringPermission((HasPermissions.Action)SecuredSecurityTypes.PublicReadableActions.READ_PUBLIC))) continue;
            TrackedLegOfCompetitorWithContext trackedLegOfCompetitorWithContext = new TrackedLegOfCompetitorWithContext(element, element.getTrackedLeg().getTrackedLeg(competitor), this.settings);
            trackedLegOfCompetitorsWithContext.add(trackedLegOfCompetitorWithContext);
        }
        return trackedLegOfCompetitorsWithContext;
    }
}

