/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.datamining.data.HasRaceOfCompetitorContext;
import com.sap.sailing.datamining.data.HasTackTypeSegmentContext;
import com.sap.sailing.datamining.impl.data.GPSFixTrackWithContext;
import com.sap.sailing.datamining.impl.data.TackTypeSegmentWithContext;
import com.sap.sailing.datamining.shared.TackTypeSegmentsDataMiningSettings;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.TackType;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.TimePoint;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class TackTypeSegmentRetrievalProcessor
extends AbstractRetrievalProcessor<HasRaceOfCompetitorContext, HasTackTypeSegmentContext> {
    private final TackTypeSegmentsDataMiningSettings settings;

    public TackTypeSegmentRetrievalProcessor(ExecutorService executor, Collection<Processor<HasTackTypeSegmentContext, ?>> resultReceivers, TackTypeSegmentsDataMiningSettings settings, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasRaceOfCompetitorContext.class, HasTackTypeSegmentContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
        this.settings = settings;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterable<HasTackTypeSegmentContext> retrieveData(HasRaceOfCompetitorContext element) {
        Iterator markPassingIterator;
        GPSFixTrack gpsFixTrack;
        ArrayList<HasTackTypeSegmentContext> tackTypeSegments = new ArrayList<HasTackTypeSegmentContext>();
        TrackedRace trackedRace = element.getTrackedRaceContext().getTrackedRace();
        TimePoint startOfRace = element.getTrackedRaceContext().getTrackedRace().getStartOfRace();
        Competitor competitor = element.getCompetitor();
        if (startOfRace != null && (gpsFixTrack = trackedRace.getTrack(element.getCompetitor())) != null && (markPassingIterator = trackedRace.getMarkPassings(competitor).iterator()).hasNext()) {
            MarkPassing legStartMarkPassing = (MarkPassing)markPassingIterator.next();
            TrackedLegOfCompetitor trackedLegOfCompetitor = trackedRace.getTrackedLegStartingAt(legStartMarkPassing.getWaypoint()).getTrackedLeg(competitor);
            MarkPassing nextMarkPassing = markPassingIterator.hasNext() ? (MarkPassing)markPassingIterator.next() : null;
            Waypoint finish = trackedRace.getRace().getCourse().getLastWaypoint();
            TackType currentTackType = null;
            boolean segmentEmpty = true;
            TackType nextTackType = null;
            TimePoint startOfCurrentSegment = legStartMarkPassing.getTimePoint();
            GPSFix gpsFix = null;
            gpsFixTrack.lockForRead();
            try {
                Iterator i = gpsFixTrack.getFixesIterator(startOfCurrentSegment, true);
                while (i.hasNext() && legStartMarkPassing.getWaypoint() != finish) {
                    if (this.isAborted()) break;
                    gpsFix = (GPSFix)i.next();
                    while (nextMarkPassing != null && !gpsFix.getTimePoint().before(nextMarkPassing.getTimePoint())) {
                        legStartMarkPassing = nextMarkPassing;
                        if (!segmentEmpty) {
                            this.addOrMergeTackTypeSegment(element, tackTypeSegments, (GPSFixTrack<Competitor, GPSFixMoving>)gpsFixTrack, startOfCurrentSegment, nextMarkPassing.getTimePoint(), currentTackType);
                            segmentEmpty = gpsFix.getTimePoint().equals(nextMarkPassing.getTimePoint());
                            startOfCurrentSegment = nextMarkPassing.getTimePoint();
                        }
                        trackedLegOfCompetitor = nextMarkPassing.getWaypoint() == finish ? null : trackedRace.getTrackedLegStartingAt(nextMarkPassing.getWaypoint()).getTrackedLeg(competitor);
                        MarkPassing markPassing = nextMarkPassing = markPassingIterator.hasNext() ? (MarkPassing)markPassingIterator.next() : null;
                    }
                    try {
                        nextTackType = trackedLegOfCompetitor == null ? null : trackedLegOfCompetitor.getTackType(gpsFix.getTimePoint());
                    }
                    catch (NoWindException e) {
                        nextTackType = null;
                    }
                    if (!segmentEmpty && nextTackType != currentTackType) {
                        this.addOrMergeTackTypeSegment(element, tackTypeSegments, (GPSFixTrack<Competitor, GPSFixMoving>)gpsFixTrack, startOfCurrentSegment, gpsFix.getTimePoint(), currentTackType);
                        segmentEmpty = true;
                        startOfCurrentSegment = gpsFix.getTimePoint();
                    } else {
                        segmentEmpty = false;
                    }
                    currentTackType = nextTackType;
                }
            }
            finally {
                gpsFixTrack.unlockAfterRead();
            }
            if (!segmentEmpty) {
                this.addOrMergeTackTypeSegment(element, tackTypeSegments, (GPSFixTrack<Competitor, GPSFixMoving>)gpsFixTrack, startOfCurrentSegment, gpsFix.getTimePoint(), currentTackType);
            }
        }
        return tackTypeSegments;
    }

    private void addOrMergeTackTypeSegment(HasRaceOfCompetitorContext element, List<HasTackTypeSegmentContext> tackTypeSegments, GPSFixTrack<Competitor, GPSFixMoving> gpsFixTrack, TimePoint startOfSegment, TimePoint endOfSegment, TackType tackType) {
        if (this.settings.getMinimumTackTypeSegmentDuration() == null || startOfSegment.until(endOfSegment).compareTo((Object)this.settings.getMinimumTackTypeSegmentDuration()) >= 0) {
            if (tackTypeSegments.isEmpty() || this.settings.getMinimumDurationBetweenAdjacentTackTypeSegments() == null) {
                tackTypeSegments.add(this.createTackTypeSegment(startOfSegment, endOfSegment, element, gpsFixTrack, tackType));
            } else {
                HasTackTypeSegmentContext previousSegment = tackTypeSegments.get(tackTypeSegments.size() - 1);
                TimePoint previousEnd = previousSegment.getEndOfTackTypeSegment();
                if (previousSegment.getTackType() == tackType && previousEnd.until(startOfSegment).compareTo((Object)this.settings.getMinimumDurationBetweenAdjacentTackTypeSegments()) < 0) {
                    tackTypeSegments.set(tackTypeSegments.size() - 1, this.createTackTypeSegment(previousSegment.getStartOfTackTypeSegment(), endOfSegment, element, gpsFixTrack, tackType));
                } else {
                    tackTypeSegments.add(this.createTackTypeSegment(startOfSegment, endOfSegment, element, gpsFixTrack, tackType));
                }
            }
        }
    }

    private HasTackTypeSegmentContext createTackTypeSegment(TimePoint startOfSegment, TimePoint endOfSegment, HasRaceOfCompetitorContext raceOfCompetitorContext, GPSFixTrack<Competitor, GPSFixMoving> gpsFixTrack, TackType tackType) {
        return new TackTypeSegmentWithContext(new GPSFixTrackWithContext(raceOfCompetitorContext, gpsFixTrack), startOfSegment, endOfSegment, tackType);
    }
}

