/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.datamining.impl.components;

import com.sap.sailing.domain.common.NauticalSide;
import java.util.function.Function;

public class ManeuverSpeedDetailsUtils {
    public static Function<Integer, Integer> getTWAIterationFunctionForManeuverDirection(NauticalSide maneuverDirection) {
        Function<Integer, Integer> forNextTWA = null;
        switch (maneuverDirection) {
            case STARBOARD: {
                forNextTWA = currentTWA -> (currentTWA + 1) % 360;
                break;
            }
            case PORT: {
                forNextTWA = currentTWA -> currentTWA - 1 < 0 ? currentTWA - 1 + 360 : currentTWA - 1;
            }
        }
        return forNextTWA;
    }

    public static double[] flipManeuversDirection(double[] valuesPerTWA) {
        double[] newValuesPerTWA = new double[360];
        int i = 0;
        while (i < 360) {
            newValuesPerTWA[(360 - i) % 360] = valuesPerTWA[i];
            ++i;
        }
        return newValuesPerTWA;
    }
}

