/*
 * Decompiled with CFR 0.152.
 */
package smile.imputation;

import smile.imputation.MissingValueImputation;
import smile.imputation.MissingValueImputationException;

public class AverageImputation
implements MissingValueImputation {
    @Override
    public void impute(double[][] data) throws MissingValueImputationException {
        for (int i = 0; i < data.length; ++i) {
            int n = 0;
            double sum = 0.0;
            for (double x : data[i]) {
                if (Double.isNaN(x)) continue;
                ++n;
                sum += x;
            }
            if (n == 0) {
                throw new MissingValueImputationException("The whole row " + i + " is missing");
            }
            if (n >= data[i].length) continue;
            double avg = sum / (double)n;
            for (int j = 0; j < data[i].length; ++j) {
                if (!Double.isNaN(data[i][j])) continue;
                data[i][j] = avg;
            }
        }
    }
}

