/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security;

import com.sap.sse.security.AbstractCompositeAuthorizingRealm;
import com.sap.sse.security.interfaces.SimpleSaltedAuthenticationInfo;
import com.sap.sse.security.shared.Account;
import com.sap.sse.security.shared.UsernamePasswordAccount;
import com.sap.sse.security.shared.impl.User;
import java.util.logging.Logger;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;

public class UsernamePasswordRealm
extends AbstractCompositeAuthorizingRealm {
    private static final Logger logger = Logger.getLogger(UsernamePasswordRealm.class.getName());

    public UsernamePasswordRealm() {
        this.setAuthenticationTokenClass(UsernamePasswordToken.class);
    }

    public boolean supports(AuthenticationToken token) {
        boolean result = token == null ? false : token instanceof UsernamePasswordToken;
        return result;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken userPassToken = (UsernamePasswordToken)token;
        String username = userPassToken.getUsername();
        if (username == null) {
            return null;
        }
        String saltedPassword = null;
        byte[] salt = null;
        User user = this.getUserStore().getUserByName(username);
        if (user == null) {
            logger.warning("Rejecting authentication attempt for non-existing user " + username);
            return null;
        }
        if (user.getLockingAndBanning().isAuthenticationLocked()) {
            logger.warning("Rejected attempt to authenticate user " + username + " because it is locked: " + user.getLockingAndBanning());
            throw new LockedAccountException("Password authentication for user " + username + " is currently locked");
        }
        UsernamePasswordAccount upa = (UsernamePasswordAccount)user.getAccount(Account.AccountType.USERNAME_PASSWORD);
        if (upa == null) {
            return null;
        }
        saltedPassword = upa.getSaltedPassword();
        salt = upa.getSalt();
        if (saltedPassword == null) {
            return null;
        }
        if (salt == null) {
            return null;
        }
        SimpleSaltedAuthenticationInfo sai = new SimpleSaltedAuthenticationInfo(username, saltedPassword, salt);
        return sai;
    }
}

