/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security;

import com.sap.sse.security.AbstractCompositeAuthorizingRealm;
import com.sap.sse.security.ClientUtils;
import com.sap.sse.security.GithubApi;
import com.sap.sse.security.InstagramApi;
import com.sap.sse.security.SessionUtils;
import com.sap.sse.security.interfaces.Credential;
import com.sap.sse.security.interfaces.OAuthToken;
import com.sap.sse.security.interfaces.Social;
import com.sap.sse.security.interfaces.SocialSettingsKeys;
import com.sap.sse.security.shared.Account;
import com.sap.sse.security.shared.SocialUserAccount;
import com.sap.sse.security.shared.UserGroupManagementException;
import com.sap.sse.security.shared.UserManagementException;
import com.sap.sse.security.shared.impl.LockingAndBanning;
import com.sap.sse.security.shared.impl.LockingAndBanningImpl;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.scribe.builder.ServiceBuilder;
import org.scribe.builder.api.FacebookApi;
import org.scribe.builder.api.FlickrApi;
import org.scribe.builder.api.Foursquare2Api;
import org.scribe.builder.api.GoogleApi;
import org.scribe.builder.api.ImgUrApi;
import org.scribe.builder.api.LinkedInApi;
import org.scribe.builder.api.LiveApi;
import org.scribe.builder.api.TumblrApi;
import org.scribe.builder.api.TwitterApi;
import org.scribe.builder.api.VimeoApi;
import org.scribe.builder.api.YahooApi;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class OAuthRealm
extends AbstractCompositeAuthorizingRealm {
    private static final Logger logger = Logger.getLogger(OAuthRealm.class.getName());

    public OAuthRealm() {
        this.setAuthenticationTokenClass(OAuthToken.class);
    }

    public boolean supports(AuthenticationToken token) {
        if (token == null) {
            return false;
        }
        return token instanceof OAuthToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        OAuthToken otoken = (OAuthToken)token;
        Credential credential = (Credential)otoken.getCredentials();
        System.out.println("Checking authentication!");
        int authProvider = credential.getAuthProvider();
        logger.info("authProvider: " + authProvider);
        String authProviderName = ClientUtils.getAuthProviderName(authProvider);
        logger.info("Verifying social usr from " + authProviderName);
        Token requestToken = null;
        String yahooGuid = null;
        String protectedResourceUrl = ClientUtils.getProctedResourceUrl(authProvider);
        if (authProvider == 1 || authProvider == 9) {
            logger.info("Verifying state: " + credential.getState());
        }
        requestToken = SessionUtils.getRequestTokenFromSession();
        OAuthService service = null;
        Verifier verifier = null;
        Token accessToken = null;
        if (authProvider != 0) {
            service = this.getOAuthService(authProvider);
            verifier = new Verifier(credential.getVerifier());
            logger.info("Requesting access token with requestToken: " + requestToken);
            logger.info("verifier=" + verifier);
            try {
                accessToken = service.getAccessToken(requestToken, verifier);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error receiving request token:", e);
            }
            if (accessToken == null) {
                logger.severe("Could not get Access Token for " + authProviderName);
                throw new AuthenticationException("Could not get Access Token");
            }
            logger.info("Got the access token: " + accessToken);
            logger.info(" Token: " + accessToken.getToken());
            logger.info(" Secret: " + accessToken.getSecret());
            logger.info(" Raw: " + accessToken.getRawResponse());
        }
        if (authProvider == 10 || authProvider == 14) {
            protectedResourceUrl = String.format(protectedResourceUrl, accessToken.getToken());
        }
        if (authProvider == 4) {
            yahooGuid = this.getQueryStringValue(accessToken.getRawResponse(), "xoauth_yahoo_guid");
            if (yahooGuid == null) {
                throw new RuntimeException("Could not get Yahoo GUID from Query String");
            }
            SessionUtils.saveYahooGuidToSession(yahooGuid);
            protectedResourceUrl = ClientUtils.getProctedResourceUrl(authProvider);
            protectedResourceUrl = String.format(protectedResourceUrl, yahooGuid);
            logger.info("Yahoo protected resource url: " + protectedResourceUrl);
        }
        String sessionId = this.makeRandomString();
        SessionUtils.saveSessionIdToSession(sessionId);
        SessionUtils.saveAuthProviderToSession(authProvider);
        SocialUserAccount socialUser = null;
        SessionUtils.saveAccessTokenToSession(accessToken);
        SessionUtils.saveProtectedResourceUrlToSession(protectedResourceUrl);
        logger.info("Getting protected resource");
        logger.info("Protected resource url: " + protectedResourceUrl);
        try {
            OAuthRequest request = new OAuthRequest(Verb.GET, protectedResourceUrl);
            service.signRequest(accessToken, request);
            Response response = request.send();
            logger.info("Status code: " + response.getCode());
            logger.info("Body: " + response.getBody());
            String json = response.getBody();
            socialUser = this.getSocialUserFromJson(json, authProvider);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Could not retrieve protected resource: ", e);
            throw new RuntimeException("Could not retrieve protected resource: " + e);
        }
        if (socialUser.getProperty("NAME") == null) {
            throw new AuthenticationException("Username cannot be null!");
        }
        socialUser.setSessionId(sessionId);
        socialUser.setProperty(Social.PROVIDER.name(), authProviderName);
        String socialname = String.valueOf(authProviderName) + "*" + socialUser.getProperty(Social.NAME.name());
        User user = this.getUserStore().getUserByName(socialname);
        if (user == null) {
            try {
                UserGroup tenant = this.getUserStore().createUserGroup(UUID.randomUUID(), String.valueOf(socialname) + "-tenant");
                this.getAccessControlStore().setOwnership(tenant.getIdentifier(), user, tenant, tenant.getName());
                user = this.getUserStore().createUser(socialname, socialUser.getProperty(Social.EMAIL.name()), (LockingAndBanning)new LockingAndBanningImpl(), new Account[]{socialUser});
                tenant.add(user);
                this.getUserStore().updateUserGroup(tenant);
            }
            catch (UserGroupManagementException | UserManagementException e) {
                throw new AuthenticationException(e.getMessage());
            }
        }
        SimpleAuthenticationInfo sai = new SimpleAuthenticationInfo();
        SimplePrincipalCollection spc = new SimplePrincipalCollection();
        spc.add(otoken.getPrincipal(), otoken.getPrincipal().toString());
        sai.setCredentials(otoken.getCredentials());
        sai.setPrincipals((PrincipalCollection)spc);
        return sai;
    }

    private OAuthService getOAuthService(int authProvider) throws AuthenticationException {
        OAuthService service = null;
        switch (authProvider) {
            case 1: {
                service = new ServiceBuilder().provider(FacebookApi.class).apiKey((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_FACEBOOK_APP_ID.name(), String.class)).apiSecret((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_FACEBOOK_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 2: {
                service = new ServiceBuilder().provider(GoogleApi.class).apiKey((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_GOOGLE_APP_ID.name(), String.class)).apiSecret((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_GOOGLE_APP_SECRET.name(), String.class)).scope((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_GOOGLE_SCOPE.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 3: {
                service = new ServiceBuilder().provider(TwitterApi.class).apiKey((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_TWITTER_APP_ID.name(), String.class)).apiSecret((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_TWITTER_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 4: {
                service = new ServiceBuilder().provider(YahooApi.class).apiKey((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_YAHOO_APP_ID.name(), String.class)).apiSecret((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_YAHOO_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 7: {
                service = new ServiceBuilder().provider(LinkedInApi.class).apiKey((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_LINKEDIN_APP_ID.name(), String.class)).apiSecret((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_LINKEDIN_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 9: {
                service = new ServiceBuilder().provider(InstagramApi.class).apiKey((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_INSTAGRAM_APP_ID.name(), String.class)).apiSecret((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_INSTAGRAM_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 10: {
                service = new ServiceBuilder().provider(GithubApi.class).apiKey((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_GITHUB_APP_ID.name(), String.class)).apiSecret((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_GITHUB_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 6: {
                service = new ServiceBuilder().provider(ImgUrApi.class).apiKey((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_IMGUR_APP_ID.name(), String.class)).apiSecret((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_IMGUR_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 5: {
                service = new ServiceBuilder().provider(FlickrApi.class).apiKey((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_FLICKR_APP_ID.name(), String.class)).apiSecret((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_FLICKR_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 11: {
                service = new ServiceBuilder().provider(VimeoApi.class).apiKey((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_VIMEO_APP_ID.name(), String.class)).apiSecret((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_VIMEO_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 8: {
                service = new ServiceBuilder().provider(LiveApi.class).apiKey((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_WINDOWS_LIVE_APP_ID.name(), String.class)).apiSecret((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_WINDOWS_LIVE_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).scope("wl.basic").build();
                break;
            }
            case 13: {
                service = new ServiceBuilder().provider(TumblrApi.class).apiKey((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_TUMBLR_LIVE_APP_ID.name(), String.class)).apiSecret((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_TUMBLR_LIVE_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            case 14: {
                service = new ServiceBuilder().provider(Foursquare2Api.class).apiKey((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_FOURSQUARE_APP_ID.name(), String.class)).apiSecret((String)this.getUserStore().getSetting(SocialSettingsKeys.OAUTH_FOURSQUARE_APP_SECRET.name(), String.class)).callback(ClientUtils.getCallbackUrl()).build();
                break;
            }
            default: {
                return null;
            }
        }
        return service;
    }

    public static String stackTraceToString(Throwable caught) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = caught.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            sb.append(e.toString()).append("\n");
            ++n2;
        }
        return sb.toString();
    }

    private String makeRandomString() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    private String getQueryStringValue(String qs, String name) {
        Map<String, String> map = OAuthRealm.parseQueryString(qs);
        return map.get(name);
    }

    private static Map<String, String> parseQueryString(String qs) {
        String[] ps = qs.split("&");
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = ps;
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            String k = p.split("=")[0];
            String v = p.split("=")[1];
            map.put(k, v);
            ++n2;
        }
        return map;
    }

    private SocialUserAccount getSocialUserFromJson(String json, int authProvider) throws AuthenticationException {
        String authProviderName = ClientUtils.getAuthProviderName(authProvider);
        Object obj = null;
        JSONParser jsonParser = new JSONParser();
        SocialUserAccount socialUser = new SocialUserAccount();
        switch (authProvider) {
            case 1: {
                try {
                    obj = jsonParser.parse(json);
                    JSONObject jsonObj = (JSONObject)obj;
                    socialUser.setProperty(Social.NAME.name(), (String)jsonObj.get((Object)"name"));
                    socialUser.setProperty(Social.FIRSTNAME.name(), (String)jsonObj.get((Object)"first_name"));
                    socialUser.setProperty(Social.LASTNAME.name(), (String)jsonObj.get((Object)"last_name"));
                    socialUser.setProperty(Social.GENDER.name(), (String)jsonObj.get((Object)"gender"));
                    socialUser.setProperty(Social.EMAIL.name(), (String)jsonObj.get((Object)"email"));
                    socialUser.setProperty(Social.JSON.name(), json);
                    return socialUser;
                }
                catch (ParseException pe) {
                    throw new AuthenticationException("Could not parse JSON data from " + authProviderName + ":" + pe.getMessage());
                }
            }
            case 4: {
                try {
                    obj = jsonParser.parse(json);
                    JSONObject jsonObj = (JSONObject)obj;
                    JSONObject jsonObjPeople = (JSONObject)jsonObj.get((Object)"profile");
                    socialUser.setProperty(Social.JSON.name(), json);
                    socialUser.setProperty(Social.NICKNAME.name(), (String)jsonObjPeople.get((Object)"nickname"));
                    socialUser.setProperty(Social.GENDER.name(), (String)jsonObjPeople.get((Object)"gender"));
                    socialUser.setProperty(Social.FIRSTNAME.name(), (String)jsonObjPeople.get((Object)"givenName"));
                    socialUser.setProperty(Social.LASTNAME.name(), (String)jsonObjPeople.get((Object)"familyName"));
                    return socialUser;
                }
                catch (Exception e) {
                    throw new AuthenticationException("Could not parse JSON data from " + authProviderName + ":" + e.getMessage());
                }
            }
            case 2: {
                try {
                    obj = jsonParser.parse(json);
                    JSONObject jsonObj = (JSONObject)obj;
                    socialUser.setProperty(Social.JSON.name(), json);
                    socialUser.setProperty(Social.NAME.name(), (String)jsonObj.get((Object)"name"));
                    socialUser.setProperty(Social.FIRSTNAME.name(), (String)jsonObj.get((Object)"given_name"));
                    socialUser.setProperty(Social.LASTNAME.name(), (String)jsonObj.get((Object)"family_name"));
                    socialUser.setProperty(Social.GENDER.name(), (String)jsonObj.get((Object)"gender"));
                    return socialUser;
                }
                catch (Exception e) {
                    throw new AuthenticationException("Could not parse JSON data from " + authProviderName + ":" + e.getMessage());
                }
            }
            case 7: {
                try {
                    obj = jsonParser.parse(json);
                    JSONObject jsonObj = (JSONObject)obj;
                    socialUser.setProperty(Social.JSON.name(), json);
                    socialUser.setProperty(Social.FIRSTNAME.name(), (String)jsonObj.get((Object)"firstName"));
                    socialUser.setProperty(Social.LASTNAME.name(), (String)jsonObj.get((Object)"lastName"));
                    return socialUser;
                }
                catch (Exception e) {
                    throw new AuthenticationException("Could not parse JSON data from " + authProviderName + ":" + e.getMessage());
                }
            }
            case 3: {
                try {
                    obj = jsonParser.parse(json);
                    JSONObject jsonObj = (JSONObject)obj;
                    socialUser.setProperty(Social.JSON.name(), json);
                    socialUser.setProperty(Social.NAME.name(), (String)jsonObj.get((Object)"name"));
                    socialUser.setProperty(Social.GENDER.name(), (String)jsonObj.get((Object)"gender"));
                    return socialUser;
                }
                catch (Exception e) {
                    throw new AuthenticationException("Could not parse JSON data from " + authProviderName + ":" + e.getMessage());
                }
            }
            case 9: {
                try {
                    obj = jsonParser.parse(json);
                    JSONObject jsonObj = (JSONObject)obj;
                    JSONObject jsonObjData = (JSONObject)jsonObj.get((Object)"data");
                    socialUser.setProperty(Social.JSON.name(), json);
                    socialUser.setProperty(Social.NAME.name(), (String)jsonObjData.get((Object)"username"));
                    return socialUser;
                }
                catch (Exception e) {
                    throw new AuthenticationException("Could not parse JSON data from " + authProviderName + ":" + e.getMessage());
                }
            }
            case 10: {
                try {
                    obj = jsonParser.parse(json);
                    JSONObject jsonObj = (JSONObject)obj;
                    socialUser.setProperty(Social.JSON.name(), json);
                    socialUser.setProperty(Social.NAME.name(), (String)jsonObj.get((Object)"login"));
                    return socialUser;
                }
                catch (Exception e) {
                    throw new AuthenticationException("Could not parse JSON data from " + authProviderName + ":" + e.getMessage());
                }
            }
            case 5: {
                try {
                    obj = jsonParser.parse(json);
                    JSONObject jsonObj = (JSONObject)obj;
                    JSONObject jsonObjUser = (JSONObject)jsonObj.get((Object)"user");
                    JSONObject jsonObjUsername = (JSONObject)jsonObjUser.get((Object)"username");
                    socialUser.setProperty(Social.NAME.name(), (String)jsonObjUsername.get((Object)"_content"));
                    socialUser.setProperty(Social.JSON.name(), json);
                    return socialUser;
                }
                catch (Exception e) {
                    throw new AuthenticationException("Could not parse JSON data from " + authProviderName + ":" + e.getMessage());
                }
            }
            case 11: {
                try {
                    obj = jsonParser.parse(json);
                    JSONObject jsonObj = (JSONObject)obj;
                    JSONObject jsonObjPerson = (JSONObject)jsonObj.get((Object)"person");
                    String userName = (String)jsonObjPerson.get((Object)"username");
                    String displayName = (String)jsonObjPerson.get((Object)"display_name");
                    if (displayName != null) {
                        socialUser.setProperty(Social.NAME.name(), displayName);
                    } else if (userName != null) {
                        socialUser.setProperty(Social.NAME.name(), userName);
                    } else {
                        socialUser.setProperty(Social.NAME.name(), "Unknown");
                    }
                    socialUser.setProperty(Social.JSON.name(), json);
                    return socialUser;
                }
                catch (Exception e) {
                    throw new AuthenticationException("Could not parse JSON data from " + authProviderName + ":" + e.getMessage());
                }
            }
            case 8: {
                try {
                    obj = jsonParser.parse(json);
                    JSONObject jsonObj = (JSONObject)obj;
                    JSONObject jsonErrorObj = (JSONObject)jsonObj.get((Object)"error");
                    if (jsonErrorObj != null) {
                        String message = (String)jsonErrorObj.get((Object)"message");
                        throw new AuthenticationException("Error: " + message);
                    }
                    socialUser.setProperty(Social.NAME.name(), (String)jsonObj.get((Object)"name"));
                    socialUser.setProperty(Social.LASTNAME.name(), (String)jsonObj.get((Object)"last_name"));
                    socialUser.setProperty(Social.FIRSTNAME.name(), (String)jsonObj.get((Object)"first_name"));
                    socialUser.setProperty(Social.JSON.name(), json);
                    return socialUser;
                }
                catch (Exception e) {
                    throw new AuthenticationException("Could not parse JSON data from " + authProviderName + ":" + e.getMessage());
                }
            }
            case 13: {
                try {
                    obj = jsonParser.parse(json);
                    JSONObject jsonObj = (JSONObject)obj;
                    JSONObject jsonObjResponse = (JSONObject)jsonObj.get((Object)"response");
                    JSONObject jsonObjUser = (JSONObject)jsonObjResponse.get((Object)"user");
                    String userName = (String)jsonObjUser.get((Object)"name");
                    socialUser.setProperty(Social.NAME.name(), userName);
                    socialUser.setProperty(Social.JSON.name(), json);
                    return socialUser;
                }
                catch (Exception e) {
                    throw new AuthenticationException("Could not parse JSON data from " + authProviderName + ":" + e.getMessage());
                }
            }
            case 14: {
                try {
                    obj = jsonParser.parse(json);
                    JSONObject jsonObj = (JSONObject)obj;
                    JSONObject jsonObjResponse = (JSONObject)jsonObj.get((Object)"response");
                    JSONObject jsonObjUser = (JSONObject)jsonObjResponse.get((Object)"user");
                    String firstName = (String)jsonObjUser.get((Object)"firstName");
                    String lastName = (String)jsonObjUser.get((Object)"lastName");
                    if (firstName != null && lastName != null) {
                        socialUser.setProperty(Social.NAME.name(), String.valueOf(firstName) + " " + lastName);
                    } else {
                        socialUser.setProperty(Social.NAME.name(), "UNKNOWN");
                    }
                    socialUser.setProperty(Social.NAME.name(), json);
                    return socialUser;
                }
                catch (Exception e) {
                    throw new AuthenticationException("Could not parse JSON data from " + authProviderName + ":" + e.getMessage());
                }
            }
        }
        throw new AuthenticationException("Unknown Auth Provider: " + authProviderName);
    }
}

