/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.simulator.racemap;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.maps.client.MapWidget;
import com.google.gwt.maps.client.base.LatLng;
import com.google.gwt.maps.client.base.Point;
import com.google.gwt.maps.client.events.center.CenterChangeMapHandler;
import com.google.gwt.maps.client.overlays.overlayhandlers.OverlayViewOnDrawHandler;
import com.google.gwt.user.client.ui.RequiresResize;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.gwt.ui.client.shared.racemap.CoordinateSystem;
import com.sap.sailing.gwt.ui.shared.SimulatorWindDTO;
import com.sap.sailing.gwt.ui.shared.racemap.CanvasOverlayV3;
import com.sap.sailing.gwt.ui.simulator.streamlets.Vector;
import java.util.logging.Logger;

public abstract class FullCanvasOverlay
extends CanvasOverlayV3
implements RequiresResize {
    protected double widgetPosLeft = 0.0;
    protected double widgetPosTop = 0.0;
    protected Vector diffPx;
    protected Integer mapWidth;
    protected Integer mapHeight;
    public String pointColor = "Red";
    public String textColor = "Black";
    private boolean mapProjectionSet = false;
    protected static Logger logger = Logger.getLogger(FullCanvasOverlay.class.getName());

    public FullCanvasOverlay(MapWidget map, int zIndex, CoordinateSystem coordinateSystem) {
        super(map, zIndex, coordinateSystem);
        this.getMap().addCenterChangeHandler((CenterChangeMapHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.diffPx = new Vector(0.0, 0.0);
    }

    protected OverlayViewOnDrawHandler getOnDrawHandler() {
        return methods -> {
            if (!this.mapProjectionSet && methods.getProjection() != null) {
                Scheduler.get().scheduleFixedDelay(() -> {
                    this.mapProjectionSet = true;
                    this.setCanvasSettings();
                    super.getOnDrawHandler().onDraw(methods);
                    return false;
                }, 1000);
            } else {
                super.getOnDrawHandler().onDraw(methods);
            }
        };
    }

    public void setCanvasSettings() {
        if (this.mapWidth == null) {
            this.mapWidth = this.getMap().getDiv().getClientWidth();
        }
        if (this.mapHeight == null) {
            this.mapHeight = this.getMap().getDiv().getClientHeight();
        }
        this.canvas.setWidth(String.valueOf(Math.max(1, this.mapWidth)));
        this.canvas.setHeight(String.valueOf(Math.max(1, this.mapHeight)));
        this.canvas.setCoordinateSpaceWidth(Math.max(1, this.mapWidth));
        this.canvas.setCoordinateSpaceHeight(Math.max(1, this.mapHeight));
        if (this.getMapProjection() != null) {
            Point upperLeftCorner = this.getMapProjection().fromLatLngToDivPixel(this.getMapProjection().fromContainerPixelToLatLng(Point.newInstance((double)0.0, (double)0.0)));
            this.setWidgetPosLeft((double)Math.round(upperLeftCorner.getX()));
            this.setWidgetPosTop((double)Math.round(upperLeftCorner.getY()));
            this.setCanvasPosition(this.getWidgetPosLeft(), this.getWidgetPosTop());
        }
    }

    public void onResize() {
        this.mapWidth = null;
        this.mapHeight = null;
        Scheduler.get().scheduleDeferred(() -> this.draw());
    }

    public void addToMap() {
        if (this.map != null) {
            this.map.addResizeHandler(e -> this.onResize());
        }
        super.addToMap();
    }

    protected void drawCenterChanged() {
        this.draw();
    }

    protected void draw() {
        if (!this.mapProjectionSet && this.getMapProjection() != null) {
            this.setCanvasSettings();
        }
    }

    protected void drawPoint(double x, double y) {
        Context2d context2d = this.canvas.getContext2d();
        context2d.setStrokeStyle(this.pointColor);
        context2d.setLineWidth(3.0);
        context2d.beginPath();
        context2d.moveTo(x - 1.0, y - 1.0);
        context2d.lineTo(x + 1.0, y + 1.0);
        context2d.closePath();
        context2d.stroke();
    }

    protected void drawPointWithText(double x, double y, String text) {
        Context2d context2d = this.canvas.getContext2d();
        this.drawPoint(x, y);
        if (this.getMap().getZoom() >= 11.0) {
            context2d.setFillStyle(this.textColor);
            context2d.fillText(text, x, y);
        }
    }

    protected void drawCircle(double x, double y, double radius, String color) {
        Context2d context2d = this.canvas.getContext2d();
        context2d.setLineWidth(3.0);
        context2d.setStrokeStyle(color);
        context2d.beginPath();
        context2d.arc(x, y, radius, 0.0, Math.PI * 2);
        context2d.closePath();
        context2d.stroke();
    }

    protected void drawCircleWithText(double x, double y, double radius, String color, String text) {
        Context2d context2d = this.canvas.getContext2d();
        context2d.setGlobalAlpha((double)0.9f);
        this.drawCircle(x, y, radius, color);
        context2d.setGlobalAlpha(1.0);
        if (this.getMap().getZoom() >= 11.0) {
            context2d.setFillStyle(this.textColor);
            double fontsize = 9.0 + 3.0 * (this.getMap().getZoom() - 10.0) / 2.0;
            context2d.setFont("normal " + fontsize + "px Calibri");
            context2d.fillText(text, x + 0.7 * fontsize, y + 0.3 * fontsize);
        }
    }

    protected void drawLine(double x, double y, double x1, double y1, double weight, String color) {
        Context2d context2d = this.canvas.getContext2d();
        context2d.setLineWidth(weight);
        context2d.setStrokeStyle(color);
        context2d.beginPath();
        context2d.moveTo(x, y);
        context2d.lineTo(x1, y1);
        context2d.closePath();
        context2d.stroke();
    }

    protected void drawCanvas() {
        Context2d context2d = this.canvas.getContext2d();
        context2d.setStrokeStyle("Black");
        context2d.setLineWidth(3.0);
        context2d.beginPath();
        context2d.moveTo(0.0, 0.0);
        context2d.lineTo(0.0, (double)this.canvas.getCoordinateSpaceHeight());
        context2d.closePath();
        context2d.stroke();
        context2d.beginPath();
        context2d.moveTo(0.0, 0.0);
        context2d.lineTo((double)this.canvas.getCoordinateSpaceWidth(), 0.0);
        context2d.closePath();
        context2d.stroke();
        context2d.beginPath();
        context2d.moveTo((double)this.canvas.getCoordinateSpaceWidth(), 0.0);
        context2d.lineTo((double)this.canvas.getCoordinateSpaceWidth(), (double)this.canvas.getCoordinateSpaceHeight());
        context2d.closePath();
        context2d.stroke();
        context2d.beginPath();
        context2d.moveTo(0.0, (double)this.canvas.getCoordinateSpaceHeight());
        context2d.lineTo((double)this.canvas.getCoordinateSpaceWidth(), (double)this.canvas.getCoordinateSpaceHeight());
        context2d.closePath();
        context2d.stroke();
    }

    protected void drawArrow(SimulatorWindDTO windDTO, double angle, double length, double weight, String color, int index, boolean drawHead) {
        String msg = "Wind @ P" + index + ": time : " + windDTO.timepoint + " speed: " + windDTO.trueWindSpeedInKnots + "knots " + windDTO.trueWindBearingDeg;
        logger.fine(msg);
        Position position = windDTO.position;
        LatLng positionLatLng = this.coordinateSystem.toLatLng(position);
        Point canvasPositionInPx = this.getMapProjection().fromLatLngToDivPixel(positionLatLng);
        double x = canvasPositionInPx.getX() - this.getWidgetPosLeft();
        double y = canvasPositionInPx.getY() - this.getWidgetPosTop();
        this.drawArrowPx(x, y, angle, length, weight, drawHead, color);
    }

    protected void drawArrowPx(double x, double y, double angle, double length, double weight, boolean drawHead, String color) {
        double dx = length * Math.sin(angle);
        double dy = -length * Math.cos(angle);
        double x1 = x + dx / 2.0;
        double y1 = y + dy / 2.0;
        this.drawLine(x - dx / 2.0, y - dy / 2.0, x1, y1, weight, color);
        double theta = Math.atan2(-dy, dx);
        double hLength = Math.max(6.0, 6.0 + 0.2 * Math.max(length - 6.0, 0.0));
        logger.finer("headlength: " + hLength + ", arrowlength: " + length);
        if (drawHead) {
            this.drawHead(x1, y1, theta, hLength, weight, color);
        }
    }

    protected void drawHead(double x, double y, double theta, double headLength, double weight, String color) {
        double t2;
        double t = theta + 0.7853981633974483;
        if (t > Math.PI) {
            t -= Math.PI * 2;
        }
        if ((t2 = theta - 0.7853981633974483) <= -Math.PI) {
            t2 += Math.PI * 2;
        }
        double x1 = x - Math.cos(t) * headLength;
        double y1 = y + Math.sin(t) * headLength;
        double x1o = x + Math.cos(t) * weight / 2.0;
        double y1o = y - Math.sin(t) * weight / 2.0;
        double x2 = x - Math.cos(t2) * headLength;
        double y2 = y + Math.sin(t2) * headLength;
        double x2o = x + Math.cos(t2) * weight / 2.0;
        double y2o = y - Math.sin(t2) * weight / 2.0;
        this.drawLine(x1o, y1o, x1, y1, weight, color);
        this.drawLine(x2o, y2o, x2, y2, weight, color);
    }

    public double getWidgetPosLeft() {
        return this.widgetPosLeft;
    }

    public void setWidgetPosLeft(double widgetPosLeft) {
        this.widgetPosLeft = widgetPosLeft;
    }

    public double getWidgetPosTop() {
        return this.widgetPosTop;
    }

    public void setWidgetPosTop(double widgetPosTop) {
        this.widgetPosTop = widgetPosTop;
    }

    public Vector getDiffPx() {
        return this.diffPx;
    }
}

