/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.shared;

import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.dto.CourseAreaDTO;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RaceColumnDTO;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapSettings;
import com.sap.sailing.gwt.ui.shared.DeviceConfigurationDTO;
import com.sap.sailing.gwt.ui.shared.RaceWithCompetitorsAndBoatsDTO;
import com.sap.sailing.gwt.ui.shared.SeriesDTO;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.dto.NamedSecuredObjectDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RegattaDTO
extends NamedSecuredObjectDTO
implements SecuredDTO {
    private static final long serialVersionUID = -4594784946348402759L;
    public BoatClassDTO boatClass;
    public Date startDate;
    public Date endDate;
    public List<RaceWithCompetitorsAndBoatsDTO> races;
    public List<SeriesDTO> series;
    public ScoringSchemeType scoringScheme;
    public List<CourseAreaDTO> courseAreas = new ArrayList();
    public DeviceConfigurationDTO.RegattaConfigurationDTO configuration;
    public boolean useStartTimeInference = true;
    public boolean controlTrackingFromStartAndFinishTimes = false;
    public boolean autoRestartTrackingUponCompetitorSetChange = false;
    public boolean canBoatsOfCompetitorsChangePerRace = false;
    public CompetitorRegistrationType competitorRegistrationType = CompetitorRegistrationType.CLOSED;
    public RankingMetrics rankingMetricType;
    public Double buoyZoneRadiusInHullLengths;
    public String registrationLinkSecret;

    @Deprecated
    RegattaDTO() {
    }

    public RegattaDTO(String name, ScoringSchemeType scoringScheme) {
        super(name);
        this.scoringScheme = scoringScheme;
    }

    public RegattaDTO(RegattaDTO other) {
        super(other.getName());
        this.boatClass = other.boatClass;
        this.startDate = other.startDate;
        this.endDate = other.endDate;
        this.races = other.races;
        this.series = new ArrayList();
        for (SeriesDTO otherSeries : other.series) {
            this.series.add(new SeriesDTO(otherSeries));
        }
        this.scoringScheme = other.scoringScheme;
        this.courseAreas = other.courseAreas;
        this.rankingMetricType = other.rankingMetricType;
        this.configuration = other.configuration;
        this.useStartTimeInference = other.useStartTimeInference;
        this.controlTrackingFromStartAndFinishTimes = other.controlTrackingFromStartAndFinishTimes;
        this.autoRestartTrackingUponCompetitorSetChange = other.autoRestartTrackingUponCompetitorSetChange;
        this.canBoatsOfCompetitorsChangePerRace = other.canBoatsOfCompetitorsChangePerRace;
        this.competitorRegistrationType = other.competitorRegistrationType;
        this.buoyZoneRadiusInHullLengths = other.buoyZoneRadiusInHullLengths;
        this.registrationLinkSecret = other.registrationLinkSecret;
    }

    public Util.Pair<SeriesDTO, FleetDTO> getSeriesAndFleet(RegattaAndRaceIdentifier raceIdentifier) {
        for (SeriesDTO s : this.series) {
            for (RaceColumnDTO raceColumn : s.getRaceColumns()) {
                FleetDTO fleet = raceColumn.getFleet((RaceIdentifier)raceIdentifier);
                if (fleet == null) continue;
                return new Util.Pair((Object)s, (Object)fleet);
            }
        }
        return null;
    }

    public RegattaIdentifier getRegattaIdentifier() {
        return new RegattaName(this.getName());
    }

    public Date getStartDate() {
        if (this.races.size() > 0) {
            return ((RaceWithCompetitorsAndBoatsDTO)this.races.get((int)0)).startOfRace;
        }
        return null;
    }

    public boolean currentlyTracked() {
        boolean tracked = false;
        for (RaceDTO race : this.races) {
            tracked = race.isTracked;
            if (tracked) break;
        }
        return tracked;
    }

    public boolean definesSeriesDiscardThresholds() {
        for (SeriesDTO s : this.series) {
            if (!s.definesSeriesDiscardThresholds()) continue;
            return true;
        }
        return false;
    }

    public Distance getCalculatedBuoyZoneRadius() {
        Distance boatHullLength = this.boatClass == null ? null : this.boatClass.getHullLength();
        double hullLengthFactor = this.buoyZoneRadiusInHullLengths == null ? 3.0 : this.buoyZoneRadiusInHullLengths;
        return boatHullLength == null ? RaceMapSettings.DEFAULT_BUOY_ZONE_RADIUS : boatHullLength.scale(hullLengthFactor);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.scoringScheme == null ? 0 : this.scoringScheme.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RegattaDTO other = (RegattaDTO)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        return this.scoringScheme == other.scoringScheme;
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.REGATTA;
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return new TypeRelativeObjectIdentifier(new String[]{this.getName()});
    }
}

