/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.raceboard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.ServiceDefTarget;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.dto.AbstractLeaderboardDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.common.authentication.FixedSailingAuthentication;
import com.sap.sailing.gwt.common.authentication.SailingHeaderWithAuthentication;
import com.sap.sailing.gwt.common.communication.routing.ProvidesLeaderboardRouting;
import com.sap.sailing.gwt.settings.client.raceboard.RaceBoardPerspectiveOwnSettings;
import com.sap.sailing.gwt.settings.client.raceboard.RaceboardContextDefinition;
import com.sap.sailing.gwt.settings.client.utils.StoredSettingsLocationFactory;
import com.sap.sailing.gwt.ui.client.AbstractSailingReadEntryPoint;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionChangeListener;
import com.sap.sailing.gwt.ui.client.MediaService;
import com.sap.sailing.gwt.ui.client.MediaServiceAsync;
import com.sap.sailing.gwt.ui.client.MediaServiceWrite;
import com.sap.sailing.gwt.ui.client.MediaServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.RaceTimesInfoProvider;
import com.sap.sailing.gwt.ui.client.SailingServiceHelper;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardComponentContext;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardModes;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardPanel;
import com.sap.sailing.gwt.ui.raceboard.RaceBoardPerspectiveLifecycle;
import com.sap.sailing.gwt.ui.shared.RaceWithCompetitorsAndBoatsDTO;
import com.sap.sailing.gwt.ui.shared.RaceboardDataDTO;
import com.sap.sse.common.HttpRequestHeaderConstants;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.gwt.client.EntryPointHelper;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.formfactor.DeviceDetector;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.perspective.PerspectiveCompositeSettings;
import com.sap.sse.gwt.client.shared.settings.OnSettingsLoadedCallback;
import com.sap.sse.gwt.settings.SettingsToUrlSerializer;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.WithSecurity;
import com.sap.sse.security.ui.client.premium.PaywallResolver;
import com.sap.sse.security.ui.client.premium.PaywallResolverImpl;
import com.sap.sse.security.ui.settings.ComponentContextWithSettingsStorage;
import com.sap.sse.security.ui.settings.StoredSettingsLocation;
import java.util.Collections;
import java.util.HashSet;

public class RaceBoardEntryPoint
extends AbstractSailingReadEntryPoint
implements ProvidesLeaderboardRouting {
    private final MediaServiceAsync mediaService = (MediaServiceAsync)GWT.create(MediaService.class);
    private final MediaServiceWriteAsync mediaServiceWrite = (MediaServiceWriteAsync)GWT.create(MediaServiceWrite.class);
    private RaceboardContextDefinition raceboardContextDefinition;

    protected void doOnModuleLoad() {
        super.doOnModuleLoad();
        EntryPointHelper.registerASyncService((ServiceDefTarget)((ServiceDefTarget)this.mediaService), (String)"service/media", (Util.Pair[])new Util.Pair[]{HttpRequestHeaderConstants.HEADER_FORWARD_TO_REPLICA});
        EntryPointHelper.registerASyncService((ServiceDefTarget)((ServiceDefTarget)this.mediaServiceWrite), (String)"service/media", (Util.Pair[])new Util.Pair[]{HttpRequestHeaderConstants.HEADER_FORWARD_TO_MASTER});
        this.raceboardContextDefinition = (RaceboardContextDefinition)new SettingsToUrlSerializer().deserializeFromCurrentLocation((GenericSerializableSettings)new RaceboardContextDefinition());
        if (this.raceboardContextDefinition.getRegattaName() == null || this.raceboardContextDefinition.getRegattaName().isEmpty() || this.raceboardContextDefinition.getRaceName() == null || this.raceboardContextDefinition.getRaceName().isEmpty() || this.raceboardContextDefinition.getLeaderboardName() == null || this.raceboardContextDefinition.getLeaderboardName().isEmpty()) {
            this.createErrorPage(((StringMessages)this.getStringMessages()).requiresRegattaRaceAndLeaderboard());
        } else {
            this.getSailingService().getRaceboardData(this.raceboardContextDefinition.getRegattaName(), this.raceboardContextDefinition.getRaceName(), this.raceboardContextDefinition.getLeaderboardName(), this.raceboardContextDefinition.getLeaderboardGroupName(), this.raceboardContextDefinition.getLeaderboardGroupId(), this.raceboardContextDefinition.getEventId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void startWithRaceboardData(RaceboardDataDTO raceboardData) {
        RaceBoardModes mode;
        String modeString = this.raceboardContextDefinition.getMode();
        RaceBoardModes raceBoardModes = mode = modeString == null ? null : RaceBoardModes.valueOf((String)modeString);
        if (raceboardData.getLeaderboard() == null) {
            this.createErrorPage(((StringMessages)this.getStringMessages()).noSuchLeaderboard());
            return;
        }
        if (this.raceboardContextDefinition.getEventId() != null && !raceboardData.isValidEvent()) {
            this.createErrorPage(((StringMessages)this.getStringMessages()).noSuchEvent());
            return;
        }
        if (this.raceboardContextDefinition.getLeaderboardGroupName() != null) {
            if (!raceboardData.isValidLeaderboardGroup()) {
                this.createErrorPage(((StringMessages)this.getStringMessages()).leaderboardNotContainedInLeaderboardGroup(this.raceboardContextDefinition.getLeaderboardName(), this.raceboardContextDefinition.getLeaderboardGroupName()));
                return;
            }
            if (this.raceboardContextDefinition.getEventId() != null && raceboardData.isValidLeaderboardGroup() && !raceboardData.isValidEvent()) {
                this.createErrorPage(((StringMessages)this.getStringMessages()).leaderboardGroupNotContainedInEvent(this.raceboardContextDefinition.getLeaderboardGroupName(), this.raceboardContextDefinition.getEventId().toString()));
                return;
            }
        }
        if (raceboardData.getRace() == null) {
            this.createErrorPage(((StringMessages)this.getStringMessages()).couldNotFindRaceInRegatta(this.raceboardContextDefinition.getRaceName(), this.raceboardContextDefinition.getRegattaName()));
            return;
        }
        StoredSettingsLocation storageDefinition = StoredSettingsLocationFactory.createStoredSettingsLocatorForRaceBoard((RaceboardContextDefinition)this.raceboardContextDefinition, (String)(mode != null ? mode.name() : null));
        PaywallResolverImpl paywallResolver = new PaywallResolverImpl(this.getUserService(), this.getSubscriptionServiceFactory());
        RaceBoardPerspectiveLifecycle lifeCycle = new RaceBoardPerspectiveLifecycle((AbstractLeaderboardDTO)raceboardData.getLeaderboard(), StringMessages.INSTANCE, raceboardData.getDetailTypesForCompetitorChart(), this.getUserService(), (PaywallResolver)paywallResolver, raceboardData.getAvailableDetailTypesForLeaderboard(), (SecuredDTO)raceboardData.getRace());
        RaceBoardComponentContext componentContext = new RaceBoardComponentContext(lifeCycle, this.getUserService(), storageDefinition);
        componentContext.getInitialSettings((OnSettingsLoadedCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createErrorPage(String message) {
        DockLayoutPanel vp = new DockLayoutPanel(Style.Unit.PX);
        SailingHeaderWithAuthentication header = new SailingHeaderWithAuthentication();
        PaywallResolverImpl paywallResolver = new PaywallResolverImpl(this.getUserService(), this.getSubscriptionServiceFactory());
        new FixedSailingAuthentication(this.getUserService(), (PaywallResolver)paywallResolver, header.getAuthenticationMenuView());
        RootLayoutPanel.get().add((Widget)vp);
        vp.addNorth((Widget)header, 100.0);
        Label infoText = new Label(message);
        infoText.getElement().getStyle().setMargin(1.0, Style.Unit.EM);
        vp.add((Widget)infoText);
    }

    private void createPerspective(RaceBoardModes raceBoardMode, ComponentContextWithSettingsStorage<PerspectiveCompositeSettings<RaceBoardPerspectiveOwnSettings>> context, PerspectiveCompositeSettings<RaceBoardPerspectiveOwnSettings> settings, RaceboardDataDTO raceboardData, RaceBoardPerspectiveLifecycle raceLifeCycle, Iterable<DetailType> availableDetailTypes, RaceboardContextDefinition raceboardContextDefinition) {
        Timer timer = new Timer(Timer.PlayModes.Replay, 1000L);
        boolean showChartMarkEditMediaButtonsAndVideo = !DeviceDetector.isMobile();
        RaceWithCompetitorsAndBoatsDTO selectedRace = raceboardData.getRace();
        Window.setTitle((String)selectedRace.getName());
        AsyncActionsExecutor asyncActionsExecutor = new AsyncActionsExecutor();
        RaceTimesInfoProvider raceTimesInfoProvider = new RaceTimesInfoProvider(this.getSailingService(), asyncActionsExecutor, (ErrorReporter)this, Collections.singletonList(selectedRace.getRaceIdentifier()), 5000L);
        RaceBoardPanel raceBoardPerspective = new RaceBoardPanel(null, context, raceLifeCycle, settings, this.getSailingService(), this.mediaService, this.mediaServiceWrite, asyncActionsExecutor, raceboardData.getCompetitorAndTheirBoats(), timer, selectedRace.getRaceIdentifier(), raceboardContextDefinition.getLeaderboardName(), raceboardContextDefinition.getLeaderboardGroupName(), raceboardContextDefinition.getLeaderboardGroupId(), raceboardContextDefinition.getEventId(), (ErrorReporter)this, (StringMessages)this.getStringMessages(), this.userAgent, raceTimesInfoProvider, showChartMarkEditMediaButtonsAndVideo, true, availableDetailTypes, raceboardData.getLeaderboard(), selectedRace, raceboardData.getTrackingConnectorInfo(), SailingServiceHelper.createSailingServiceWriteInstance(), raceboardContextDefinition, (WithSecurity)this);
        RootLayoutPanel.get().add(raceBoardPerspective.getEntryWidget());
        if (raceBoardMode != null) {
            raceBoardMode.getMode().applyTo(raceBoardPerspective);
            raceBoardMode.getMode().addInitializationFinishedRunner(() -> this.selectCompetitorFromPerspectiveOwnSetting(raceBoardPerspective, (RaceBoardPerspectiveOwnSettings)settings.getPerspectiveOwnSettings()));
        } else {
            this.selectCompetitorFromPerspectiveOwnSetting(raceBoardPerspective, (RaceBoardPerspectiveOwnSettings)settings.getPerspectiveOwnSettings());
        }
    }

    protected void selectCompetitorFromPerspectiveOwnSetting(RaceBoardPanel raceBoardPanel, RaceBoardPerspectiveOwnSettings perspectiveOwnSettings) {
        if (perspectiveOwnSettings != null) {
            HashSet<String> selectedCompetitorIds = new HashSet<String>();
            Util.addAll((Iterable)perspectiveOwnSettings.getSelectedCompetitors(), selectedCompetitorIds);
            String selectedCompetitorId = perspectiveOwnSettings.getSelectedCompetitor();
            if (selectedCompetitorId != null) {
                selectedCompetitorIds.add(selectedCompetitorId);
            }
            if (!selectedCompetitorIds.isEmpty()) {
                HashSet<CompetitorDTO> selectedCompetitors = new HashSet<CompetitorDTO>();
                for (String competitorId : selectedCompetitorIds) {
                    for (CompetitorDTO comp : raceBoardPanel.getCompetitorSelectionProvider().getAllCompetitors()) {
                        if (!competitorId.equals(comp.getIdAsString())) continue;
                        selectedCompetitors.add(comp);
                    }
                }
                raceBoardPanel.getCompetitorSelectionProvider().setSelection(selectedCompetitors, new CompetitorSelectionChangeListener[0]);
            }
        }
    }

    public String getLeaderboardName() {
        return this.raceboardContextDefinition.getLeaderboardName();
    }

    static /* synthetic */ void access$0(RaceBoardEntryPoint raceBoardEntryPoint, RaceboardDataDTO raceboardDataDTO) {
        raceBoardEntryPoint.startWithRaceboardData(raceboardDataDTO);
    }

    static /* synthetic */ RaceboardContextDefinition access$1(RaceBoardEntryPoint raceBoardEntryPoint) {
        return raceBoardEntryPoint.raceboardContextDefinition;
    }

    static /* synthetic */ void access$2(RaceBoardEntryPoint raceBoardEntryPoint, RaceBoardModes raceBoardModes, ComponentContextWithSettingsStorage componentContextWithSettingsStorage, PerspectiveCompositeSettings perspectiveCompositeSettings, RaceboardDataDTO raceboardDataDTO, RaceBoardPerspectiveLifecycle raceBoardPerspectiveLifecycle, Iterable iterable, RaceboardContextDefinition raceboardContextDefinition) {
        raceBoardEntryPoint.createPerspective(raceBoardModes, componentContextWithSettingsStorage, perspectiveCompositeSettings, raceboardDataDTO, raceBoardPerspectiveLifecycle, iterable, raceboardContextDefinition);
    }
}

