/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.polarmining;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.datamining.presentation.AbstractSailingResultsPresenter;
import com.sap.sailing.gwt.ui.datamining.presentation.ChartFactory;
import com.sap.sailing.polars.datamining.shared.PolarAggregation;
import com.sap.sailing.polars.datamining.shared.PolarDataMiningSettings;
import com.sap.sse.common.settings.Settings;
import com.sap.sse.datamining.shared.GroupKey;
import com.sap.sse.datamining.shared.dto.StatisticQueryDefinitionDTO;
import com.sap.sse.datamining.shared.impl.dto.QueryResultDTO;
import com.sap.sse.datamining.ui.client.ChartToCsvExporter;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.moxieapps.gwt.highcharts.client.Chart;
import org.moxieapps.gwt.highcharts.client.Point;
import org.moxieapps.gwt.highcharts.client.Series;
import org.moxieapps.gwt.highcharts.client.events.PointSelectEventHandler;
import org.moxieapps.gwt.highcharts.client.events.PointUnselectEventHandler;
import org.moxieapps.gwt.highcharts.client.events.SeriesHideEventHandler;
import org.moxieapps.gwt.highcharts.client.events.SeriesShowEventHandler;
import org.moxieapps.gwt.highcharts.client.plotOptions.SeriesPlotOptions;

public class PolarResultsPresenter
extends AbstractSailingResultsPresenter<Settings> {
    private final DockLayoutPanel dockLayoutPanel;
    private final Chart polarChart;
    private final SimpleLayoutPanel polarChartWrapperPanel;
    private final Chart dataCountHistogramChart;
    private final Chart dataCountPerAngleHistogramChart;
    private final DockLayoutPanel histogramChartsWrapperPanel;
    private final Map<Series, Series> histogramSeriesForPolarSeries = new HashMap();
    private final Map<Series, Map<Long, Series>> perAngleHistogramSeriesForAngle = new HashMap();

    public PolarResultsPresenter(Component<?> parent, ComponentContext<?> context, StringMessages stringMessages) {
        super(parent, context, stringMessages);
        this.polarChart = ChartFactory.createPolarChart();
        this.polarChart.getYAxis().setMin((Number)0);
        this.polarChartWrapperPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.polarChartWrapperPanel.add((Widget)this.polarChart);
        this.dataCountHistogramChart = ChartFactory.createDataCountHistogramChart((String)(String.valueOf(stringMessages.TWA()) + " (" + stringMessages.degreesShort() + ")"), (StringMessages)stringMessages);
        this.dataCountPerAngleHistogramChart = ChartFactory.createDataCountHistogramChart((String)stringMessages.windSpeed(), (StringMessages)stringMessages);
        this.histogramChartsWrapperPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.histogramChartsWrapperPanel.addNorth((Widget)this.dataCountHistogramChart, 50.0);
        this.histogramChartsWrapperPanel.addSouth((Widget)this.dataCountPerAngleHistogramChart, 50.0);
        this.dockLayoutPanel = new DockLayoutPanel(Style.Unit.PCT);
        this.dockLayoutPanel.addWest((Widget)this.polarChartWrapperPanel, 40.0);
        this.dockLayoutPanel.addEast((Widget)this.histogramChartsWrapperPanel, 60.0);
        ChartToCsvExporter chartToCsvExporter = new ChartToCsvExporter(stringMessages.csvCopiedToClipboard());
        Button exportStatisticsCurveToCsvButton = new Button(stringMessages.exportStatisticsCurveToCsv(), e -> chartToCsvExporter.exportChartAsCsvToClipboard(this.polarChart));
        this.addControl((Widget)exportStatisticsCurveToCsvButton);
        Button exportTWAHistogramToCsvButton = new Button(stringMessages.exportTWAHistogramToCsv(), e -> chartToCsvExporter.exportChartAsCsvToClipboard(this.dataCountHistogramChart));
        this.addControl((Widget)exportTWAHistogramToCsvButton);
        Button exportWindSpeedHistogramToCsvButton = new Button(stringMessages.exportWindSpeedHistogramToCsv(), e -> chartToCsvExporter.exportChartAsCsvToClipboard(this.dataCountPerAngleHistogramChart));
        this.addControl((Widget)exportWindSpeedHistogramToCsvButton);
        this.setSeriesShowAndHideHandler();
    }

    private void setSeriesShowAndHideHandler() {
        SeriesPlotOptions seriesPlotOptions = new SeriesPlotOptions();
        seriesPlotOptions.setSeriesShowEventHandler(this.createSeriesShowEventHandler());
        seriesPlotOptions.setSeriesHideEventHandler(this.createSeriesHideEventHandler());
        seriesPlotOptions.setPointSelectEventHandler(this.createPointSelectEventHandler());
        seriesPlotOptions.setPointUnselectEventHandler(this.createPointUnselectEventHandler());
        seriesPlotOptions.setAllowPointSelect(true);
        this.polarChart.setSeriesPlotOptions(seriesPlotOptions);
    }

    private PointUnselectEventHandler createPointUnselectEventHandler() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private PointSelectEventHandler createPointSelectEventHandler() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private SeriesShowEventHandler createSeriesShowEventHandler() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private SeriesHideEventHandler createSeriesHideEventHandler() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected Widget getPresentationWidget() {
        return this.dockLayoutPanel;
    }

    protected void internalShowResults(StatisticQueryDefinitionDTO queryDefinition, QueryResultDTO<?> result) {
        this.polarChart.removeAllSeries(false);
        this.dataCountHistogramChart.removeAllSeries(false);
        this.dataCountPerAngleHistogramChart.removeAllSeries(false);
        this.histogramSeriesForPolarSeries.clear();
        this.perAngleHistogramSeriesForAngle.clear();
        Map results = result.getResults();
        ArrayList sortedNaturally = new ArrayList(results.keySet());
        Collections.sort(sortedNaturally, new /* Unavailable Anonymous Inner Class!! */);
        for (GroupKey key : sortedNaturally) {
            PolarAggregation aggregation = (PolarAggregation)results.get(key);
            double[] speedsPerAngle = aggregation.getAverageSpeedsPerAngle();
            int count = aggregation.getCount();
            int[] countPerAngle = aggregation.getCountPerAngle();
            PolarDataMiningSettings settings = aggregation.getSettings();
            if (settings.getMinimumDataCountPerGraph() > count) continue;
            Series polarSeries = this.polarChart.createSeries();
            Series histogramSeries = this.dataCountHistogramChart.createSeries();
            Map histogramData = aggregation.getCountHistogramPerAngle();
            HashMap<Long, Series> seriesPerAngle = new HashMap<Long, Series>();
            this.perAngleHistogramSeriesForAngle.put(polarSeries, seriesPerAngle);
            int convertedAngle = -179;
            while (convertedAngle <= 180) {
                int index = convertedAngle < 0 ? convertedAngle + 360 : convertedAngle;
                double speed = speedsPerAngle[index];
                Point point = null;
                if (countPerAngle[index] >= settings.getMinimumDataCountPerAngle() && speed != 0.0) {
                    point = new Point((Number)convertedAngle, (Number)speed);
                    polarSeries.addPoint(point, false, false, false);
                } else {
                    polarSeries.addPoint((Number)convertedAngle, (Number)0, false, false, false);
                }
                histogramSeries.addPoint((Number)convertedAngle, (Number)countPerAngle[index], false, false, false);
                if (point != null) {
                    Map histogramDataForAngle = (Map)histogramData.get(index);
                    Series dataCountPerAngleSeries = this.dataCountPerAngleHistogramChart.createSeries();
                    dataCountPerAngleSeries.setName(String.valueOf(key.asString()) + " - " + convertedAngle + this.stringMessages.degreesShort());
                    ArrayList sortedAngles = new ArrayList(histogramDataForAngle.keySet());
                    Collections.sort(sortedAngles);
                    for (Double angle : sortedAngles) {
                        dataCountPerAngleSeries.addPoint((Number)angle, (Number)histogramDataForAngle.get(angle));
                    }
                    this.dataCountPerAngleHistogramChart.addSeries(dataCountPerAngleSeries, false, false);
                    dataCountPerAngleSeries.setVisible(false, false);
                    seriesPerAngle.put(Long.valueOf(convertedAngle), dataCountPerAngleSeries);
                }
                ++convertedAngle;
            }
            polarSeries.setName(key.asString());
            histogramSeries.setName(key.asString());
            histogramSeries.setVisible(false, false);
            this.histogramSeriesForPolarSeries.put(polarSeries, histogramSeries);
            this.polarChart.addSeries(polarSeries, false, false);
            this.dataCountHistogramChart.addSeries(histogramSeries);
            for (Series seriesToHide : seriesPerAngle.values()) {
                seriesToHide.setVisible(false, false);
            }
        }
        Scheduler.get().scheduleDeferred(() -> {
            this.polarChart.setSizeToMatchContainer();
            this.dataCountHistogramChart.setSizeToMatchContainer();
            this.dataCountPerAngleHistogramChart.setSizeToMatchContainer();
            this.dataCountPerAngleHistogramChart.redraw();
        });
    }

    public String getLocalizedShortName() {
        return this.stringMessages.polarResultsPresenter();
    }

    public boolean hasSettings() {
        return false;
    }

    public SettingsDialogComponent<Settings> getSettingsDialogComponent(Settings settings) {
        return null;
    }

    public void updateSettings(Settings newSettings) {
    }

    public String getDependentCssClassName() {
        return "polarResultsPresenter";
    }

    public Settings getSettings() {
        return null;
    }

    public String getId() {
        return "PolarResultsPresenter";
    }

    static /* synthetic */ Chart access$0(PolarResultsPresenter polarResultsPresenter) {
        return polarResultsPresenter.polarChart;
    }

    static /* synthetic */ Chart access$1(PolarResultsPresenter polarResultsPresenter) {
        return polarResultsPresenter.dataCountHistogramChart;
    }

    static /* synthetic */ Chart access$2(PolarResultsPresenter polarResultsPresenter) {
        return polarResultsPresenter.dataCountPerAngleHistogramChart;
    }

    static /* synthetic */ Map access$3(PolarResultsPresenter polarResultsPresenter) {
        return polarResultsPresenter.perAngleHistogramSeriesForAngle;
    }

    static /* synthetic */ Map access$4(PolarResultsPresenter polarResultsPresenter) {
        return polarResultsPresenter.histogramSeriesForPolarSeries;
    }
}

