/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboardedit;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.FuzzyBoatClassNameMatcher;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboardedit.EditableLeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboardedit.ResultSelectionAndApplyDialog;
import com.sap.sailing.gwt.ui.shared.ScoreCorrectionProviderDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.security.ui.client.UserService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResultSelectionAndApplyDialog
extends DataEntryDialog<Util.Triple<String, String, Util.Pair<String, Date>>> {
    private static final String USER_PREFERENCE_LAST_SCORE_CORRECTION_PROVIDER_USED = "ResultSelectionAndApplyDialog.lastScoreCorrectionProviderUsed";
    private final LinkedHashMap<String, Util.Pair<String, Util.Pair<String, Date>>> scoreCorrections;
    private final ListBox scoreCorrectionListBox;
    private final ListBox scoreCorrectionProviderListBox;
    private final BusyIndicator busyIndicator;
    private final SailingServiceAsync sailingService;
    private final StringMessages stringMessages;
    private final ErrorReporter errorReporter;
    private final BoatClassDTO boatClass;
    private final String leaderboardName;

    public ResultSelectionAndApplyDialog(EditableLeaderboardPanel leaderboardPanel, Iterable<String> scoreCorrectionProviderNames, SailingServiceWriteAsync sailingServiceWrite, StringMessages stringMessages, ErrorReporter errorReporter, UserService userService) {
        super(stringMessages.importOfficialResults(), null, stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new Validator(stringMessages), (DataEntryDialog.DialogCallback)new Callback(sailingServiceWrite, leaderboardPanel, errorReporter, stringMessages));
        this.sailingService = sailingServiceWrite;
        this.stringMessages = stringMessages;
        this.errorReporter = errorReporter;
        this.boatClass = leaderboardPanel.getLeaderboard().getBoatClass();
        this.leaderboardName = leaderboardPanel.getLeaderboard().getName();
        this.scoreCorrections = new LinkedHashMap();
        this.scoreCorrectionProviderListBox = this.createListBox(false);
        this.scoreCorrectionListBox = this.createListBox(false);
        this.scoreCorrectionListBox.setVisible(false);
        this.busyIndicator = new SimpleBusyIndicator();
        this.scoreCorrectionProviderListBox.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<String> sortedProviderNames = new ArrayList<String>();
        for (String providerName : scoreCorrectionProviderNames) {
            sortedProviderNames.add(providerName);
        }
        HashMap<String, Integer> indexOfProviderInList = new HashMap<String, Integer>();
        Collections.sort(sortedProviderNames);
        this.scoreCorrectionProviderListBox.addItem(stringMessages.selectResultImportProvider());
        for (String providerName : sortedProviderNames) {
            indexOfProviderInList.put(providerName, this.scoreCorrectionProviderListBox.getItemCount());
            this.scoreCorrectionProviderListBox.addItem(providerName);
        }
        userService.getPreference(USER_PREFERENCE_LAST_SCORE_CORRECTION_PROVIDER_USED, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void scoreCorrectionProviderChanged(String selectedProviderName) {
        if (selectedProviderName != null) {
            this.busyIndicator.setBusy(true);
            this.scoreCorrectionProviderListBox.setEnabled(false);
            this.sailingService.getScoreCorrectionsOfProvider(selectedProviderName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.scoreCorrectionListBox.setVisible(false);
            this.updateScoreCorrections(null);
        }
    }

    private void updateScoreCorrections(ScoreCorrectionProviderDTO scp) {
        this.scoreCorrections.clear();
        this.scoreCorrectionListBox.clear();
        if (scp != null) {
            Integer indexInList;
            this.scoreCorrectionListBox.addItem(this.stringMessages.pleaseSelectAScoringResult());
            ArrayList<Util.Pair> eventNameBoatClassNameAndLastModified = new ArrayList<Util.Pair>();
            for (Map.Entry entry : scp.getHasResultsForBoatClassFromDateByEventName().entrySet()) {
                for (Util.Pair se : (Set)entry.getValue()) {
                    eventNameBoatClassNameAndLastModified.add(new Util.Pair((Object)((String)entry.getKey()), (Object)se));
                }
            }
            Map matchQualities = this.sortOfficialResultsByRelevance(eventNameBoatClassNameAndLastModified);
            HashMap<Util.Pair, Integer> indexOfResultInScoreCorrectionListBox = new HashMap<Util.Pair, Integer>();
            for (Util.Pair pair : eventNameBoatClassNameAndLastModified) {
                String eventName = (String)pair.getA();
                Util.Pair boatClassAndLastModified = (Util.Pair)pair.getB();
                String scoreCorrectionName = String.valueOf(eventName) + ", " + (String)boatClassAndLastModified.getA() + ", " + boatClassAndLastModified.getB();
                indexOfResultInScoreCorrectionListBox.put(pair, this.scoreCorrectionListBox.getItemCount());
                this.scoreCorrections.put(scoreCorrectionName, pair);
                this.scoreCorrectionListBox.addItem(scoreCorrectionName);
            }
            if (!eventNameBoatClassNameAndLastModified.isEmpty() && matchQualities.containsKey(eventNameBoatClassNameAndLastModified.get(0)) && (Double)matchQualities.get(eventNameBoatClassNameAndLastModified.get(0)) > 0.5 && (indexInList = (Integer)indexOfResultInScoreCorrectionListBox.get(eventNameBoatClassNameAndLastModified.get(0))) != null) {
                this.scoreCorrectionListBox.setSelectedIndex(indexInList.intValue());
                this.validateAndUpdate();
                this.getOkButton().setFocus(true);
            }
        }
    }

    private Map<Util.Pair<String, Util.Pair<String, Date>>, Double> sortOfficialResultsByRelevance(List<Util.Pair<String, Util.Pair<String, Date>>> eventNameBoatClassNameCapturedWhen) {
        return new FuzzyBoatClassNameMatcher().sortOfficialResultsByRelevance(this.boatClass, eventNameBoatClassNameCapturedWhen, this.leaderboardName);
    }

    protected Widget getAdditionalWidget() {
        VerticalPanel vPanel = new VerticalPanel();
        vPanel.add((Widget)this.busyIndicator);
        vPanel.add((Widget)this.scoreCorrectionProviderListBox);
        vPanel.add((Widget)this.scoreCorrectionListBox);
        return vPanel;
    }

    protected Focusable getInitialFocusWidget() {
        return this.scoreCorrectionProviderListBox;
    }

    protected Util.Triple<String, String, Util.Pair<String, Date>> getResult() {
        Util.Triple result = null;
        int selectedProviderIndex = this.scoreCorrectionProviderListBox.getSelectedIndex();
        if (selectedProviderIndex > 0) {
            String selectedProviderName = this.scoreCorrectionProviderListBox.getItemText(selectedProviderIndex);
            int selectedScoreCorrectionIndex = this.scoreCorrectionListBox.getSelectedIndex();
            if (selectedScoreCorrectionIndex > 0) {
                Util.Pair pair = (Util.Pair)this.scoreCorrections.get(this.scoreCorrectionListBox.getValue(selectedScoreCorrectionIndex));
                result = new Util.Triple((Object)selectedProviderName, (Object)((String)pair.getA()), (Object)((Util.Pair)pair.getB()));
            }
        }
        return result;
    }

    private void onScoreCorrectionProviderListBoxSelectionChanged(UserService userService) {
        int selectedIndex = this.scoreCorrectionProviderListBox.getSelectedIndex();
        if (selectedIndex > 0) {
            String selectedProviderName = this.scoreCorrectionProviderListBox.getItemText(selectedIndex);
            this.scoreCorrectionProviderChanged(selectedProviderName);
            userService.setPreference(USER_PREFERENCE_LAST_SCORE_CORRECTION_PROVIDER_USED, selectedProviderName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.scoreCorrectionProviderChanged(null);
        }
    }

    static /* synthetic */ void access$1(ResultSelectionAndApplyDialog resultSelectionAndApplyDialog, UserService userService) {
        resultSelectionAndApplyDialog.onScoreCorrectionProviderListBoxSelectionChanged(userService);
    }

    static /* synthetic */ ListBox access$2(ResultSelectionAndApplyDialog resultSelectionAndApplyDialog) {
        return resultSelectionAndApplyDialog.scoreCorrectionProviderListBox;
    }

    static /* synthetic */ void access$3(ResultSelectionAndApplyDialog resultSelectionAndApplyDialog, ScoreCorrectionProviderDTO scoreCorrectionProviderDTO) {
        resultSelectionAndApplyDialog.updateScoreCorrections(scoreCorrectionProviderDTO);
    }

    static /* synthetic */ ListBox access$4(ResultSelectionAndApplyDialog resultSelectionAndApplyDialog) {
        return resultSelectionAndApplyDialog.scoreCorrectionListBox;
    }

    static /* synthetic */ BusyIndicator access$5(ResultSelectionAndApplyDialog resultSelectionAndApplyDialog) {
        return resultSelectionAndApplyDialog.busyIndicator;
    }

    static /* synthetic */ ErrorReporter access$6(ResultSelectionAndApplyDialog resultSelectionAndApplyDialog) {
        return resultSelectionAndApplyDialog.errorReporter;
    }

    static /* synthetic */ StringMessages access$7(ResultSelectionAndApplyDialog resultSelectionAndApplyDialog) {
        return resultSelectionAndApplyDialog.stringMessages;
    }
}

