/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.leaderboard;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.gwt.settings.client.leaderboard.LeaderboardSettings;
import com.sap.sailing.gwt.settings.client.leaderboard.MultiRaceLeaderboardSettings;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionModel;
import com.sap.sailing.gwt.ui.client.CompetitorSelectionProvider;
import com.sap.sailing.gwt.ui.client.FlagImageResolver;
import com.sap.sailing.gwt.ui.client.LeaderboardUpdateListener;
import com.sap.sailing.gwt.ui.client.SailingServiceAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.leaderboard.ClassicLeaderboardStyle;
import com.sap.sailing.gwt.ui.leaderboard.LeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.MultiRaceLeaderboardPanel;
import com.sap.sailing.gwt.ui.leaderboard.SelectedLeaderboardChangeListener;
import com.sap.sailing.gwt.ui.leaderboard.SelectedLeaderboardChangeProvider;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.client.player.Timer;
import com.sap.sse.gwt.client.shared.components.AbstractLazyComponent;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialogComponent;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import com.sap.sse.security.ui.client.WithSecurity;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public class MultiLeaderboardProxyPanel
extends AbstractLazyComponent<MultiRaceLeaderboardSettings>
implements TimeListener,
SelectedLeaderboardChangeProvider<MultiRaceLeaderboardPanel> {
    private MultiRaceLeaderboardPanel selectedLeaderboardPanel;
    private FlowPanel selectedLeaderboardFlowPanel;
    private final StringMessages stringMessages;
    private final ErrorReporter errorReporter;
    private final SailingServiceAsync sailingService;
    private String selectedLeaderboardName;
    private final AsyncActionsExecutor asyncActionsExecutor;
    private final boolean showRaceDetails;
    private final Timer timer;
    private VerticalPanel mainPanel;
    private final List<Util.Pair<String, String>> leaderboardNamesAndDisplayNames;
    private TabPanel leaderboardsTabPanel;
    private Label leaderboardsLabel;
    private final String metaLeaderboardName;
    private final boolean isEmbedded;
    private final Set<LeaderboardUpdateListener> leaderboardUpdateListeners;
    private final Set<SelectedLeaderboardChangeListener<MultiRaceLeaderboardPanel>> selectedLeaderboardChangeListeners;
    private HashMap<String, MultiRaceLeaderboardSettings> contextStore;
    private MultiRaceLeaderboardSettings loadedSettings;
    private final FlagImageResolver flagImageResolver;
    private final Iterable<DetailType> availableDetailTypes;
    private Function<String, SailingServiceAsync> sailingServiceFactory;
    protected final WithSecurity withSecurity;

    public MultiLeaderboardProxyPanel(Component<?> parent, ComponentContext<?> context, Function<String, SailingServiceAsync> sailingServiceFactory, String metaLeaderboardName, AsyncActionsExecutor asyncActionsExecutor, Timer timer, boolean isEmbedded, String preselectedLeaderboardName, ErrorReporter errorReporter, StringMessages stringMessages, boolean showRaceDetails, boolean autoExpandLastRaceColumn, MultiRaceLeaderboardSettings settings, FlagImageResolver flagImageResolver, Iterable<DetailType> availableDetailTypes, WithSecurity withSecurity) {
        super(parent, context);
        this.sailingServiceFactory = sailingServiceFactory;
        this.loadedSettings = settings;
        this.availableDetailTypes = availableDetailTypes;
        this.stringMessages = stringMessages;
        this.errorReporter = errorReporter;
        this.sailingService = sailingServiceFactory.apply(metaLeaderboardName);
        this.metaLeaderboardName = metaLeaderboardName;
        this.asyncActionsExecutor = asyncActionsExecutor;
        this.showRaceDetails = showRaceDetails;
        this.timer = timer;
        this.isEmbedded = isEmbedded;
        this.selectedLeaderboardName = preselectedLeaderboardName;
        this.flagImageResolver = flagImageResolver;
        this.withSecurity = withSecurity;
        this.selectedLeaderboardFlowPanel = null;
        this.selectedLeaderboardPanel = null;
        this.leaderboardNamesAndDisplayNames = new ArrayList();
        this.leaderboardUpdateListeners = new HashSet();
        this.selectedLeaderboardChangeListeners = new HashSet();
        this.contextStore = new HashMap();
    }

    public Widget createWidget() {
        this.mainPanel = new VerticalPanel();
        if (!this.isEmbedded) {
            this.leaderboardsLabel = new Label(this.stringMessages.regattaLeaderboards());
            this.leaderboardsLabel.setVisible(false);
            this.leaderboardsLabel.getElement().getStyle().setFontWeight(Style.FontWeight.BOLD);
            this.leaderboardsLabel.getElement().getStyle().setMargin(5.0, Style.Unit.PX);
            this.mainPanel.add((Widget)this.leaderboardsLabel);
        }
        this.leaderboardsTabPanel = new TabPanel();
        this.leaderboardsTabPanel.setVisible(false);
        this.leaderboardsTabPanel.setAnimationEnabled(false);
        this.leaderboardsTabPanel.setWidth("100%");
        this.leaderboardsTabPanel.addSelectionHandler((SelectionHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.mainPanel.add((Widget)this.leaderboardsTabPanel);
        this.updateLeaderboardSelection();
        return this.mainPanel;
    }

    public String getLocalizedShortName() {
        return this.stringMessages.leaderboards();
    }

    public boolean hasSettings() {
        return true;
    }

    public MultiRaceLeaderboardSettings getSettings() {
        return this.selectedLeaderboardPanel.getSettings();
    }

    public SettingsDialogComponent<MultiRaceLeaderboardSettings> getSettingsDialogComponent(MultiRaceLeaderboardSettings settings) {
        return this.selectedLeaderboardPanel.getSettingsDialogComponent(settings);
    }

    public void updateSettings(MultiRaceLeaderboardSettings newSettings) {
        this.contextStore.put(this.selectedLeaderboardPanel.getLeaderboardName(), newSettings);
        this.selectedLeaderboardPanel.updateSettings((LeaderboardSettings)newSettings);
    }

    public void addLeaderboardUpdateListener(LeaderboardUpdateListener listener) {
        this.leaderboardUpdateListeners.add(listener);
    }

    public void setLeaderboardNames(List<Util.Pair<String, String>> newLeaderboardNamesAndDisplayNames) {
        this.leaderboardNamesAndDisplayNames.clear();
        this.leaderboardNamesAndDisplayNames.addAll(newLeaderboardNamesAndDisplayNames);
        this.updateLeaderboardSelection();
    }

    private void readAndUpdateLeaderboardsOfMetaleaderboard() {
        this.sailingService.getLeaderboardsNamesOfMetaLeaderboard(this.metaLeaderboardName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateLeaderboardSelection() {
        if (this.leaderboardsTabPanel != null) {
            this.leaderboardsTabPanel.clear();
            int index = 0;
            int leaderboardCount = this.leaderboardNamesAndDisplayNames.size();
            for (Util.Pair leaderboardNameAndDisplayName : this.leaderboardNamesAndDisplayNames) {
                FlowPanel tabFlowPanel = new FlowPanel();
                this.leaderboardsTabPanel.add((Widget)tabFlowPanel, (String)leaderboardNameAndDisplayName.getB(), false);
                if (this.selectedLeaderboardName != null && this.selectedLeaderboardName.equals(leaderboardNameAndDisplayName.getA())) {
                    this.leaderboardsTabPanel.selectTab(index);
                }
                ++index;
            }
            if (this.selectedLeaderboardName == null && leaderboardCount > 0) {
                this.leaderboardsTabPanel.selectTab(leaderboardCount - 1);
            }
            this.leaderboardsTabPanel.setVisible(leaderboardCount > 0);
            if (!this.isEmbedded) {
                this.leaderboardsLabel.setVisible(leaderboardCount > 0);
            }
        }
    }

    private void updateSelectedLeaderboard(String newSelectedLeaderboardName, int newTabIndex) {
        if (newSelectedLeaderboardName != null) {
            if (this.selectedLeaderboardPanel != null && this.selectedLeaderboardFlowPanel != null) {
                this.selectedLeaderboardPanel.removeAllListeners();
                this.selectedLeaderboardFlowPanel.remove((Widget)this.selectedLeaderboardPanel);
                this.selectedLeaderboardPanel = null;
                this.selectedLeaderboardFlowPanel = null;
            }
            this.selectedLeaderboardFlowPanel = (FlowPanel)this.leaderboardsTabPanel.getWidget(newTabIndex);
            MultiRaceLeaderboardSettings toMerge = (MultiRaceLeaderboardSettings)this.contextStore.get(newSelectedLeaderboardName);
            toMerge = toMerge != null ? this.loadedSettings.withRaceColumnSelectionValuesFrom(toMerge) : this.loadedSettings;
            MultiRaceLeaderboardPanel newSelectedLeaderboardPanel = new MultiRaceLeaderboardPanel((Component)this, this.getComponentContext(), (SailingServiceAsync)this.sailingServiceFactory.apply(newSelectedLeaderboardName), this.asyncActionsExecutor, toMerge, this.isEmbedded, (CompetitorSelectionProvider)new CompetitorSelectionModel(true), this.timer, newSelectedLeaderboardName, this.errorReporter, this.stringMessages, this.showRaceDetails, null, true, null, false, true, false, false, false, (LeaderboardPanel.LeaderBoardStyle)new ClassicLeaderboardStyle(), this.flagImageResolver, this.availableDetailTypes, this.withSecurity);
            this.selectedLeaderboardFlowPanel.add((Widget)newSelectedLeaderboardPanel);
            for (LeaderboardUpdateListener listener : this.leaderboardUpdateListeners) {
                newSelectedLeaderboardPanel.addLeaderboardUpdateListener(listener);
            }
            this.setSelectedLeaderboard(newSelectedLeaderboardPanel);
        } else if (this.selectedLeaderboardPanel != null && this.selectedLeaderboardFlowPanel != null) {
            this.selectedLeaderboardPanel.removeAllListeners();
            this.selectedLeaderboardFlowPanel.remove((Widget)this.selectedLeaderboardPanel);
            this.selectedLeaderboardPanel = null;
            this.selectedLeaderboardFlowPanel = null;
        }
        this.selectedLeaderboardName = newSelectedLeaderboardName;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.readAndUpdateLeaderboardsOfMetaleaderboard();
        } else {
            this.updateSelectedLeaderboard(null, -1);
        }
    }

    public void timeChanged(Date newTime, Date oldTime) {
        if (this.selectedLeaderboardPanel != null) {
            this.selectedLeaderboardPanel.timeChanged(newTime, oldTime);
        }
    }

    public void addSelectedLeaderboardChangeListener(SelectedLeaderboardChangeListener<MultiRaceLeaderboardPanel> listener) {
        this.selectedLeaderboardChangeListeners.add(listener);
    }

    public void removeSelectedLeaderboardChangeListener(SelectedLeaderboardChangeListener<MultiRaceLeaderboardPanel> listener) {
        this.selectedLeaderboardChangeListeners.remove(listener);
    }

    public void setSelectedLeaderboard(MultiRaceLeaderboardPanel selectedLeaderboard) {
        if (this.selectedLeaderboardPanel != selectedLeaderboard) {
            this.selectedLeaderboardPanel = selectedLeaderboard;
            for (SelectedLeaderboardChangeListener listener : this.selectedLeaderboardChangeListeners) {
                listener.onSelectedLeaderboardChanged((LeaderboardPanel)this.selectedLeaderboardPanel);
            }
        }
    }

    public void removeLeaderboardUpdateListener(LeaderboardUpdateListener leaderboardUpdateListener) {
        this.leaderboardUpdateListeners.remove(leaderboardUpdateListener);
    }

    public String getId() {
        return "mlb";
    }

    static /* synthetic */ List access$3(MultiLeaderboardProxyPanel multiLeaderboardProxyPanel) {
        return multiLeaderboardProxyPanel.leaderboardNamesAndDisplayNames;
    }

    static /* synthetic */ void access$4(MultiLeaderboardProxyPanel multiLeaderboardProxyPanel, String string, int n) {
        multiLeaderboardProxyPanel.updateSelectedLeaderboard(string, n);
    }
}

