/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.client.media;

import com.google.gwt.core.client.JavaScriptObject;

public class YoutubeVideoControl {
    private JavaScriptObject youtubePlayer;
    private boolean deferredIsPlaying;
    private double deferredCurrentTime;
    private boolean deferredIsMuted;
    private boolean deferredIsControlsVisible;
    private double deferredPlaybackSpeed;

    YoutubeVideoControl(String videoUrl, String videoContainerId) {
        if (!this.isYoutubeApiInitialized()) {
            this.loadInitialYoutubePlayer(videoUrl, videoContainerId);
        } else {
            this.loadYoutubePlayer(videoUrl, videoContainerId);
        }
    }

    private native boolean isYoutubeApiInitialized();

    private native void setYoutubeApiInitialized();

    private native void loadInitialYoutubePlayer(String var1, String var2);

    private native void loadYoutubePlayer(String var1, String var2);

    public void initPlayState(JavaScriptObject youtubePlayer) {
        this.youtubePlayer = youtubePlayer;
        this.nativeSetPlaybackSpeed(this.deferredPlaybackSpeed);
        this.nativeSetControlsVisible(this.deferredIsControlsVisible);
        this.nativeSetCurrentTime(this.deferredCurrentTime);
        this.nativeSetMuted(this.deferredIsMuted);
        if (this.deferredIsPlaying) {
            this.nativePlay();
        } else {
            this.nativePause();
        }
    }

    public void play() {
        if (this.youtubePlayer != null) {
            this.nativePlay();
        } else {
            this.deferredIsPlaying = true;
        }
    }

    private native void nativePlay();

    public void pause() {
        if (this.youtubePlayer != null) {
            this.nativePause();
        } else {
            this.deferredIsPlaying = false;
        }
    }

    private native void nativePause();

    public void setCurrentTime(double time) {
        if (this.youtubePlayer != null) {
            this.nativeSetCurrentTime(time);
        } else {
            this.deferredCurrentTime = time;
        }
    }

    private native void nativeSetCurrentTime(double var1);

    public void setMuted(boolean muted) {
        if (this.youtubePlayer != null) {
            this.nativeSetMuted(muted);
        } else {
            this.deferredIsMuted = muted;
        }
    }

    private native void nativeSetMuted(boolean var1);

    public boolean isPaused() {
        boolean isPaused = this.youtubePlayer == null ? !this.deferredIsPlaying : this.nativeIsPaused();
        return isPaused;
    }

    private native boolean nativeIsPaused();

    public double getDuration() {
        return this.youtubePlayer == null ? Double.NaN : this.nativeGetDuration();
    }

    private native double nativeGetDuration();

    public double getCurrentTime() {
        return this.youtubePlayer == null ? this.deferredCurrentTime : this.nativeGetCurrentTime();
    }

    private native double nativeGetCurrentTime();

    public void setPlaybackSpeed(double newPlaySpeedFactor) {
        if (this.youtubePlayer != null) {
            this.nativeSetPlaybackSpeed(newPlaySpeedFactor);
        } else {
            this.deferredPlaybackSpeed = newPlaySpeedFactor;
        }
    }

    private native void nativeSetPlaybackSpeed(double var1);

    public void setControlsVisible(boolean isVisible) {
        if (this.youtubePlayer != null) {
            this.nativeSetControlsVisible(isVisible);
        } else {
            this.deferredIsControlsVisible = isVisible;
        }
    }

    native void nativeSetControlsVisible(boolean var1);
}

