/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole.coursecreation;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionModel;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.coursecreation.MarkRoleEditDialog;
import com.sap.sailing.gwt.ui.adminconsole.coursecreation.MarkRolePanel;
import com.sap.sailing.gwt.ui.client.SailingServiceWriteAsync;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.courseCreation.MarkRoleDTO;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.adminconsole.FilterablePanelProvider;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.Flushable;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.gwt.client.panels.AbstractFilterablePanel;
import com.sap.sse.gwt.client.panels.LabeledAbstractFilterablePanel;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.AccessControlListDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.DefaultActionsImagesBarCell;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class MarkRolePanel
extends FlowPanel
implements FilterablePanelProvider<MarkRoleDTO> {
    private static AdminConsoleTableResources tableResources = (AdminConsoleTableResources)GWT.create(AdminConsoleTableResources.class);
    private final SailingServiceWriteAsync sailingServiceWrite;
    private final ErrorReporter errorReporter;
    private final StringMessages stringMessages;
    private final ListDataProvider<MarkRoleDTO> markRoleListDataProvider = new ListDataProvider();
    private final LabeledAbstractFilterablePanel<MarkRoleDTO> filterableMarkRoles;
    private List<MarkRoleDTO> allMarkRoles;
    private FlushableCellTable<MarkRoleDTO> markRolesTable;
    private RefreshableMultiSelectionModel<MarkRoleDTO> refreshableSelectionModel;

    public MarkRolePanel(SailingServiceWriteAsync sailingServiceWrite, ErrorReporter errorReporter, StringMessages stringMessages, UserService userService) {
        this.sailingServiceWrite = sailingServiceWrite;
        this.errorReporter = errorReporter;
        this.stringMessages = stringMessages;
        AccessControlledButtonPanel buttonAndFilterPanel = new AccessControlledButtonPanel(userService, SecuredDomainType.MARK_ROLE);
        this.add((Widget)buttonAndFilterPanel);
        this.allMarkRoles = new ArrayList();
        buttonAndFilterPanel.addUnsecuredAction(stringMessages.refresh(), (Command)new /* Unavailable Anonymous Inner Class!! */);
        buttonAndFilterPanel.addCreateAction(stringMessages.add(), (Command)new /* Unavailable Anonymous Inner Class!! */);
        Label lblFilter = new Label(String.valueOf(stringMessages.filterMarkRoles()) + ":");
        lblFilter.setWordWrap(false);
        buttonAndFilterPanel.addUnsecuredWidget((Widget)lblFilter);
        this.filterableMarkRoles = new /* Unavailable Anonymous Inner Class!! */;
        this.createMarkRoleTable(userService);
        this.filterableMarkRoles.getTextBox().ensureDebugId("MarkRolesFilterTextBox");
        buttonAndFilterPanel.addUnsecuredWidget((Widget)this.filterableMarkRoles);
        this.filterableMarkRoles.setUpdatePermissionFilterForCheckbox(event -> userService.hasPermission((SecuredDTO)event, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE));
    }

    public void loadMarkRoles() {
        this.markRoleListDataProvider.getList().clear();
        this.sailingServiceWrite.getMarkRoles((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void refreshMarkRoles() {
        this.loadMarkRoles();
    }

    private void createMarkRoleTable(UserService userService) {
        this.markRolesTable = new FlushableCellTable(1000, (CellTable.Resources)tableResources);
        this.markRolesTable.setWidth("100%");
        ColumnSortEvent.ListHandler sortHandler = new ColumnSortEvent.ListHandler(this.markRoleListDataProvider.getList());
        this.markRolesTable.addColumnSortHandler((ColumnSortEvent.Handler)sortHandler);
        this.markRolesTable.setSelectionModel((SelectionModel)this.refreshableSelectionModel, (CellPreviewEvent.Handler)DefaultSelectionEventManager.createCustomManager((DefaultSelectionEventManager.EventTranslator)new /* Unavailable Anonymous Inner Class!! */));
        this.initTableColumns(sortHandler, userService);
        this.markRoleListDataProvider.addDataDisplay((HasData)this.markRolesTable);
        this.add((Widget)this.markRolesTable);
        this.allMarkRoles.clear();
        this.allMarkRoles.addAll(this.markRoleListDataProvider.getList());
    }

    private void initTableColumns(ColumnSortEvent.ListHandler<MarkRoleDTO> sortHandler, UserService userService) {
        SelectionCheckboxColumn checkColumn = new SelectionCheckboxColumn(tableResources.cellTableStyle().cellTableCheckboxSelected(), tableResources.cellTableStyle().cellTableCheckboxDeselected(), tableResources.cellTableStyle().cellTableCheckboxColumnCell(), (EntityIdentityComparator)new /* Unavailable Anonymous Inner Class!! */, this.filterableMarkRoles.getAllListDataProvider(), (Flushable)this.markRolesTable);
        this.markRolesTable.addColumn((Column)checkColumn, SafeHtmlUtils.fromSafeConstant((String)"<br/>"));
        this.markRolesTable.setColumnWidth((Column)checkColumn, 40.0, Style.Unit.PX);
        7 idColumn = new /* Unavailable Anonymous Inner Class!! */;
        8 nameColumn = new /* Unavailable Anonymous Inner Class!! */;
        nameColumn.setSortable(true);
        sortHandler.setComparator((Column)nameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        10 shortNameColumn = new /* Unavailable Anonymous Inner Class!! */;
        nameColumn.setSortable(true);
        sortHandler.setComparator((Column)nameColumn, (Comparator)new /* Unavailable Anonymous Inner Class!! */);
        this.markRolesTable.addColumn((Column)nameColumn, this.stringMessages.name());
        this.markRolesTable.addColumn((Column)shortNameColumn, this.stringMessages.shortName());
        SecuredDTOOwnerColumn.configureOwnerColumns((AbstractCellTable)this.markRolesTable, sortHandler, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        AccessControlledActionsColumn actionsColumn = AccessControlledActionsColumn.create((ImagesBarCell)new DefaultActionsImagesBarCell((com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages), (UserService)userService);
        EditOwnershipDialog.DialogConfig configOwnership = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)SecuredDomainType.MARK_ROLE, markRole -> this.markRoleListDataProvider.refresh(), (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)SecuredDomainType.MARK_ROLE, markRole -> {
            AccessControlListDTO accessControlListDTO = markRole.getAccessControlList();
        }, (com.sap.sse.security.ui.client.i18n.StringMessages)this.stringMessages);
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)configOwnership).openOwnershipDialog(arg_0));
        actionsColumn.addAction(DefaultActionsImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, markRole -> configACL.openDialog((SecuredDTO)markRole));
        this.markRolesTable.addColumn((Column)idColumn, this.stringMessages.id());
        this.markRolesTable.addColumn((Column)actionsColumn, this.stringMessages.actions());
        this.refreshableSelectionModel = checkColumn.getSelectionModel();
        this.markRolesTable.setSelectionModel((SelectionModel)this.refreshableSelectionModel, checkColumn.getSelectionManager());
    }

    private void openEditMarkRoleDialog(MarkRoleDTO originalMarkRole) {
        MarkRoleEditDialog dialog = new MarkRoleEditDialog(this.stringMessages, originalMarkRole, (DataEntryDialog.DialogCallback)new /* Unavailable Anonymous Inner Class!! */);
        dialog.ensureDebugId("MarkRoleEditDialog");
        dialog.show();
    }

    public AbstractFilterablePanel<MarkRoleDTO> getFilterablePanel() {
        return this.filterableMarkRoles;
    }

    static /* synthetic */ void access$0(MarkRolePanel markRolePanel, MarkRoleDTO markRoleDTO) {
        markRolePanel.openEditMarkRoleDialog(markRoleDTO);
    }

    static /* synthetic */ FlushableCellTable access$1(MarkRolePanel markRolePanel) {
        return markRolePanel.markRolesTable;
    }

    static /* synthetic */ ErrorReporter access$2(MarkRolePanel markRolePanel) {
        return markRolePanel.errorReporter;
    }

    static /* synthetic */ ListDataProvider access$3(MarkRolePanel markRolePanel) {
        return markRolePanel.markRoleListDataProvider;
    }

    static /* synthetic */ LabeledAbstractFilterablePanel access$4(MarkRolePanel markRolePanel) {
        return markRolePanel.filterableMarkRoles;
    }

    static /* synthetic */ RefreshableMultiSelectionModel access$5(MarkRolePanel markRolePanel) {
        return markRolePanel.refreshableSelectionModel;
    }

    static /* synthetic */ SailingServiceWriteAsync access$6(MarkRolePanel markRolePanel) {
        return markRolePanel.sailingServiceWrite;
    }
}

