/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.gwt.ui.adminconsole;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaNameAndRaceName;
import com.sap.sailing.domain.common.dto.RaceDTO;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.gwt.ui.adminconsole.AbstractTrackedRacesListComposite;
import com.sap.sailing.gwt.ui.adminconsole.ExportPopup;
import com.sap.sailing.gwt.ui.adminconsole.TrackedRaceChangedListener;
import com.sap.sailing.gwt.ui.adminconsole.TrackedRacesSettings;
import com.sap.sailing.gwt.ui.adminconsole.places.AdminConsoleView;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.shared.RegattaDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import com.sap.sse.gwt.client.shared.components.Component;
import com.sap.sse.gwt.client.shared.components.SettingsDialog;
import com.sap.sse.gwt.client.shared.settings.ComponentContext;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.component.SelectedElementsCountingButton;
import java.util.ArrayList;
import java.util.Set;

public class TrackedRacesListComposite
extends AbstractTrackedRacesListComposite {
    private Button btnUntrack;
    private Button btnRemoveRace;
    private Button btnSetDelayToLive;
    private Button btnExport;
    private ExportPopup exportPopup;
    private boolean actionButtonsEnabled;

    public TrackedRacesListComposite(Component<?> parent, ComponentContext<?> context, AdminConsoleView.Presenter presenter, StringMessages stringMessages, boolean hasMultiSelection, boolean actionButtonsEnabled) {
        super(parent, context, presenter, stringMessages, hasMultiSelection);
        this.actionButtonsEnabled = actionButtonsEnabled;
        this.createUI();
    }

    private void showSetDelayToLiveDialog() {
        TrackedRacesSettings settings = new TrackedRacesSettings();
        settings.setDelayToLiveInSeconds(5000L);
        SettingsDialog settingsDialog = new SettingsDialog((Component)this, (com.sap.sse.gwt.client.StringMessages)this.stringMessages);
        settingsDialog.show();
    }

    public void addTrackedRaceChangeListener(TrackedRaceChangedListener listener) {
        this.raceIsTrackedRaceChangeListener.add(listener);
    }

    void stopTrackingRaces(Iterable<RaceDTO> races) {
        ArrayList<RegattaAndRaceIdentifier> racesToStopTracking = new ArrayList<RegattaAndRaceIdentifier>();
        for (RaceDTO race : races) {
            if (!race.isTracked) continue;
            racesToStopTracking.add(race.getRaceIdentifier());
        }
        this.sailingService.stopTrackingRaces(racesToStopTracking, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void removeAndUntrackRaces(Iterable<RaceDTO> races) {
        ArrayList<RegattaNameAndRaceName> regattaNamesAndRaceNames = new ArrayList<RegattaNameAndRaceName>();
        for (RaceDTO race : races) {
            regattaNamesAndRaceNames.add((RegattaNameAndRaceName)race.getRaceIdentifier());
        }
        this.sailingService.removeAndUntrackRaces(regattaNamesAndRaceNames, (AsyncCallback)new MarkedAsyncCallback((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */));
    }

    protected void addControlButtons(HorizontalPanel trackedRacesButtonPanel) {
        if (this.actionButtonsEnabled) {
            this.btnUntrack = new Button(this.stringMessages.stopTracking());
            this.btnUntrack.ensureDebugId("StopTrackingButton");
            this.btnUntrack.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.btnUntrack.setEnabled(false);
            trackedRacesButtonPanel.add((Widget)this.btnUntrack);
            this.btnSetDelayToLive = new Button(String.valueOf(this.stringMessages.setDelayToLive()) + "...");
            this.btnSetDelayToLive.ensureDebugId("SetDelayToLiveButton");
            this.btnSetDelayToLive.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            trackedRacesButtonPanel.add((Widget)this.btnSetDelayToLive);
            this.exportPopup = new ExportPopup(this.stringMessages);
            this.btnExport = new Button(this.stringMessages.export());
            this.btnExport.ensureDebugId("ExportButton");
            this.btnExport.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            this.btnExport.setEnabled(false);
            trackedRacesButtonPanel.add((Widget)this.btnExport);
            this.btnRemoveRace = new SelectedElementsCountingButton(this.stringMessages.remove(), (SetSelectionModel)this.refreshableSelectionModel, e -> String.valueOf(e.getRegattaName()) + " - " + e.getName(), arg_0 -> ((StringMessages)StringMessages.INSTANCE).doYouReallyWantToRemoveSelectedElements(arg_0), event -> this.removeAndUntrackRaces((Iterable)this.refreshableSelectionModel.getSelectedSet()));
            this.btnRemoveRace.ensureDebugId("RemoveRaceButton");
            trackedRacesButtonPanel.add((Widget)this.btnRemoveRace);
        }
    }

    protected void makeControlsReactToSelectionChange(Set<RaceDTO> selectedRaces) {
        if (this.actionButtonsEnabled) {
            if (selectedRaces.isEmpty()) {
                this.btnRemoveRace.setEnabled(false);
                this.btnRemoveRace.setText(this.stringMessages.remove());
                this.btnUntrack.setEnabled(false);
                this.btnExport.setEnabled(false);
                this.btnSetDelayToLive.setEnabled(false);
            } else {
                int numberOfItemsSelected = selectedRaces.size();
                this.btnRemoveRace.setText(numberOfItemsSelected <= 1 ? this.stringMessages.remove() : this.stringMessages.removeNumber(numberOfItemsSelected));
                boolean canUpdateAll = true;
                boolean canDeleteAll = true;
                boolean canExportAll = true;
                for (RaceDTO race : selectedRaces) {
                    if (!this.userService.hasPermission((SecuredDTO)race, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE)) {
                        canUpdateAll = false;
                    }
                    if (!this.userService.hasPermission((SecuredDTO)race, (HasPermissions.Action)HasPermissions.DefaultActions.DELETE)) {
                        canDeleteAll = false;
                    }
                    if (this.userService.hasPermission((SecuredDTO)race, (HasPermissions.Action)SecuredDomainType.TrackedRaceActions.EXPORT)) continue;
                    canExportAll = false;
                }
                this.btnSetDelayToLive.setEnabled(canUpdateAll);
                this.btnRemoveRace.setEnabled(canDeleteAll);
                this.btnUntrack.setEnabled(canUpdateAll);
                this.btnExport.setEnabled(canExportAll);
            }
        }
    }

    protected void makeControlsReactToFillRegattas(Iterable<RegattaDTO> regattas) {
        if (this.actionButtonsEnabled) {
            if (Util.isEmpty(regattas)) {
                this.btnUntrack.setVisible(false);
                this.btnRemoveRace.setVisible(false);
                this.btnSetDelayToLive.setVisible(false);
                this.btnExport.setVisible(false);
            } else {
                this.btnUntrack.setVisible(true);
                this.btnUntrack.setEnabled(false);
                this.btnRemoveRace.setVisible(true);
                this.btnRemoveRace.setEnabled(false);
                this.btnSetDelayToLive.setVisible(true);
                this.btnExport.setVisible(true);
            }
        }
    }

    public String getDependentCssClassName() {
        return "trackedRacesListComposite";
    }

    public TrackedRacesSettings getSettings() {
        return this.settings;
    }

    public String getId() {
        return "TrackedRacesListComposite";
    }

    static /* synthetic */ void access$1(TrackedRacesListComposite trackedRacesListComposite) {
        trackedRacesListComposite.showSetDelayToLiveDialog();
    }

    static /* synthetic */ ExportPopup access$2(TrackedRacesListComposite trackedRacesListComposite) {
        return trackedRacesListComposite.exportPopup;
    }
}

